/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.test.json;

import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonPolymorphicTypeMap;
import com.google.api.client.json.JsonString;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.StringUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.TestCase;

public abstract class AbstractJsonFactoryTest
extends TestCase {
    private static final String EMPTY = "";
    private static final String JSON_THREE_ELEMENTS = "{  \"one\": { \"num\": 1 }, \"two\": { \"num\": 2 }, \"three\": { \"num\": 3 }}";
    private static final String EMPTY_OBJECT = "{}";
    private static final String JSON_ENTRY = "{\"title\":\"foo\"}";
    private static final String JSON_FEED = "{\"entries\":[{\"title\":\"foo\"},{\"title\":\"bar\"}]}";
    static final String CONTAINED_MAP = "{\"map\":{\"title\":\"foo\"}}";
    static final String NUMBER_TYPES = "{\"bigDecimalValue\":1.0,\"bigIntegerValue\":1,\"byteObjValue\":1,\"byteValue\":1,\"doubleObjValue\":1.0,\"doubleValue\":1.0,\"floatObjValue\":1.0,\"floatValue\":1.0,\"intObjValue\":1,\"intValue\":1,\"longListValue\":[1],\"longMapValue\":{\"a\":1},\"longObjValue\":1,\"longValue\":1,\"shortObjValue\":1,\"shortValue\":1,\"yetAnotherBigDecimalValue\":1}";
    static final String NUMBER_TYPES_AS_STRING = "{\"bigDecimalValue\":\"1.0\",\"bigIntegerValue\":\"1\",\"byteObjValue\":\"1\",\"byteValue\":\"1\",\"doubleObjValue\":\"1.0\",\"doubleValue\":\"1.0\",\"floatObjValue\":\"1.0\",\"floatValue\":\"1.0\",\"intObjValue\":\"1\",\"intValue\":\"1\",\"longListValue\":[\"1\"],\"longMapValue\":{\"a\":\"1\"},\"longObjValue\":\"1\",\"longValue\":\"1\",\"shortObjValue\":\"1\",\"shortValue\":\"1\",\"yetAnotherBigDecimalValue\":\"1\"}";
    private static final String UTF8_VALUE = "123\u05d9\u05e0\u05d9\u05d1";
    private static final String UTF8_JSON = "{\"value\":\"123\u05d9\u05e0\u05d9\u05d1\"}";
    static final String ANY_TYPE = "{\"arr\":[1],\"bool\":true,\"nul\":null,\"num\":5,\"obj\":{\"key\":\"value\"},\"str\":\"value\"}";
    static final String ARRAY_TYPE = "{\"arr\":[4,5],\"arr2\":[[1,2],[3]],\"integerArr\":[6,7]}";
    static final String COLLECTION_TYPE = "{\"arr\":[[\"a\",\"b\"],[\"c\"]]}";
    static final String MAP_TYPE = "{\"value\":[{\"map1\":{\"k1\":1,\"k2\":2},\"map2\":{\"kk1\":3,\"kk2\":4}}]}";
    static final String WILDCARD_TYPE = "{\"lower\":[[1,2,3]],\"map\":{\"v\":1},\"mapInWild\":[{\"v\":1}],\"mapUpper\":{\"v\":1},\"simple\":[[1,2,3]],\"upper\":[[1,2,3]]}";
    static final String INTEGER_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,1]],\"list\":[null,[null,1]],\"nullValue\":null,\"value\":1}";
    static final String INT_ARRAY_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,[1]]],\"list\":[null,[null,[1]]],\"nullValue\":null,\"value\":[1]}";
    static final String DOUBLE_LIST_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,[1.0]]],\"list\":[null,[null,[1.0]]],\"nullValue\":null,\"value\":[1.0]}";
    static final String FLOAT_MAP_TYPE_VARIABLE_TYPE = "{\"arr\":[null,[null,{\"a\":1.0}]],\"list\":[null,[null,{\"a\":1.0}]],\"nullValue\":null,\"value\":{\"a\":1.0}}";
    static final String NULL_VALUE = "{\"arr\":[null],\"arr2\":[null,[null]],\"value\":null}";
    static final String ENUM_VALUE = "{\"nullValue\":null,\"otherValue\":\"other\",\"value\":\"VALUE\"}";
    static final String TYPE_VARS = "{\"y\":{\"z\":{\"f\":[\"abc\"]}}}";
    static final String STRING_ARRAY = "[\"a\",\"b\",\"c\"]";
    static final String INT_ARRAY = "[1,2,3]";
    private static final String EMPTY_ARRAY = "[]";
    private static final String NUMBER_TOP_VALUE = "1";
    private static final String STRING_TOP_VALUE = "\"a\"";
    private static final String NULL_TOP_VALUE = "null";
    private static final String BOOL_TOP_VALUE = "true";
    static final String EXTENDS_JSON = "{\"numAsString\":\"1\",\"num\":1}";
    static final String SIMPLE = "{\"a\":\"b\"}";
    static final String SIMPLE_WRAPPED = "{\"d\":{\"a\":\"b\"}}";
    public static final String BOOLEAN_TYPE_EMPTY = "{}";
    public static final String BOOLEAN_TYPE_EMPTY_OUTPUT = "{\"bool\":false}";
    public static final String BOOLEAN_TYPE_TRUE = "{\"bool\":true,\"boolObj\":true}";
    public static final String BOOLEAN_TYPE_FALSE = "{\"bool\":false,\"boolObj\":false}";
    public static final String BOOLEAN_TYPE_NULL = "{\"boolObj\":null}";
    public static final String BOOLEAN_TYPE_NULL_OUTPUT = "{\"bool\":false,\"boolObj\":null}";
    public static final String BOOLEAN_TYPE_WRONG = "{\"boolObj\":{}}";
    public static final String DOG = "{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"dog\"}";
    public static final String CENTIPEDE = "{\"bodyColor\":\"green\",\"legCount\":68,\"name\":\"Mr. Icky\",\"type\":\"bug\"}";
    public static final String DOG_OPTIMIZED = "{\"type\":\"dog\",\"name\":\"Fido\",\"legCount\":4,\"tricksKnown\":3}";
    public static final String CENTIPEDE_OPTIMIZED = "{\"type\":\"bug\",\"bodyColor\":\"green\",\"name\":\"Mr. Icky\",\"legCount\":68}";
    public static final String DOG_EXTRA_INFO = "{\"name\":\"Fido\",\"legCount\":4,\"unusedInfo\":\"this is not being used!\",\"tricksKnown\":3,\"type\":\"dog\",\"unused\":{\"foo\":200}}";
    public static final String CENTIPEDE_EXTRA_INFO = "{\"unused\":0, \"bodyColor\":\"green\",\"name\":\"Mr. Icky\",\"legCount\":68,\"type\":\"bug\"}";
    public static final String ANIMAL_WITHOUT_TYPE = "{\"legCount\":3,\"name\":\"Confused\"}";
    public static final String HUMAN = "{\"bestFriend\":{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"dog\"},\"legCount\":2,\"name\":\"Joe\",\"type\":\"human\"}";
    public static final String DOG_EXTRA_INFO_ORDERED = "{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"dog\",\"unusedInfo\":\"this is not being used!\",\"unused\":{\"foo\":200}}";
    public static final String DOG_WITH_FAMILY = "{\"children\":[{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"dog\"},{\"bodyColor\":\"green\",\"legCount\":68,\"name\":\"Mr. Icky\",\"type\":\"bug\"}],\"legCount\":4,\"name\":\"Bob\",\"nicknames\":[\"Fluffy\",\"Hey, you\"],\"tricksKnown\":10,\"type\":\"dogwithfamily\"}";
    public static final String DOG_WITH_NO_FAMILY = "{\"legCount\":4,\"type\":\"dogwithfamily\"}";
    public static final String DOG_WITH_NO_FAMILY_PARSED = "{\"legCount\":4,\"tricksKnown\":0,\"type\":\"dogwithfamily\"}";
    public static final String MULTIPLE_ANNOTATIONS_JSON = "{\"a\":\"foo\",\"b\":\"dog\",\"c\":\"bar\",\"d\":\"bug\"}";
    public static final String POLYMORPHIC_NUMERIC_TYPE_1 = "{\"foo\":\"bar\",\"type\":1}";
    public static final String POLYMORPHIC_NUMERIC_TYPE_2 = "{\"foo\":\"bar\",\"type\":2}";
    public static final String POLYMORPHIC_NUMERIC_UNSPECIFIED_TYPE = "{\"foo\":\"bar\"}";
    public static final String POLYMORPHIC_WITH_UNKNOWN_KEY = "{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"unknown\"}";
    public static final String POLYMORPHIC_SELF_REFERENCING = "{\"info\":\"blah\",\"type\":\"self\"}";
    public static final String HUMAN_WITH_PETS = "{\"bestFriend\":{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"dog\"},\"legCount\":2,\"name\":\"Joe\",\"pets\":{\"first\":{\"bodyColor\":\"green\",\"legCount\":68,\"name\":\"Mr. Icky\",\"type\":\"bug\"},\"second\":{\"type\":\"dog\"}},\"type\":\"human with pets\",\"unused\":\"foo\"}";
    public static final String HUMAN_WITH_PETS_PARSED = "{\"bestFriend\":{\"legCount\":4,\"name\":\"Fido\",\"tricksKnown\":3,\"type\":\"dog\"},\"legCount\":2,\"name\":\"Joe\",\"pets\":{\"first\":{\"bodyColor\":\"green\",\"legCount\":68,\"name\":\"Mr. Icky\",\"type\":\"bug\"},\"second\":{\"legCount\":0,\"tricksKnown\":0,\"type\":\"dog\"}},\"type\":\"human with pets\"}";

    public AbstractJsonFactoryTest(String name) {
        super(name);
    }

    protected abstract JsonFactory newFactory();

    public void testParse_empty() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(EMPTY);
        parser.nextToken();
        try {
            parser.parseAndClose(HashMap.class);
            AbstractJsonFactoryTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_emptyMap() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser("{}");
        parser.nextToken();
        HashMap map = (HashMap)parser.parseAndClose(HashMap.class);
        AbstractJsonFactoryTest.assertTrue((boolean)map.isEmpty());
    }

    public void testParse_emptyGenericJson() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser("{}");
        parser.nextToken();
        GenericJson json = (GenericJson)parser.parseAndClose(GenericJson.class);
        AbstractJsonFactoryTest.assertTrue((boolean)json.isEmpty());
    }

    public void testParser_partialEmpty() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser("{}");
        parser.nextToken();
        parser.nextToken();
        HashMap result = (HashMap)parser.parseAndClose(HashMap.class);
        AbstractJsonFactoryTest.assertEquals((String)"{}", (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertTrue((boolean)result.isEmpty());
    }

    public void testParseEntry() throws Exception {
        Entry entry = (Entry)this.newFactory().createJsonParser(JSON_ENTRY).parseAndClose(Entry.class);
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)entry.title);
    }

    public void testParser_partialEntry() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.nextToken();
        Entry result = (Entry)parser.parseAndClose(Entry.class);
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)result.title);
    }

    public void testParseFeed() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        parser.nextToken();
        Feed feed = (Feed)parser.parseAndClose(Feed.class);
        Iterator<Entry> iterator = feed.entries.iterator();
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)iterator.next().title);
        AbstractJsonFactoryTest.assertEquals((String)"bar", (String)iterator.next().title);
        AbstractJsonFactoryTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testParseEntryAsMap() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        HashMap map = (HashMap)parser.parseAndClose(HashMap.class);
        AbstractJsonFactoryTest.assertEquals((Object)"foo", map.remove("title"));
        AbstractJsonFactoryTest.assertTrue((boolean)map.isEmpty());
    }

    public void testSkipToKey_missingEmpty() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser("{}");
        parser.nextToken();
        parser.skipToKey("missing");
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
    }

    public void testSkipToKey_missing() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipToKey("missing");
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
    }

    public void testSkipToKey_found() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipToKey("title");
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.getCurrentToken());
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)parser.getText());
    }

    public void testSkipToKey_startWithFieldName() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.nextToken();
        parser.skipToKey("title");
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.getCurrentToken());
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)parser.getText());
    }

    public void testSkipChildren_string() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipToKey("title");
        parser.skipChildren();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.getCurrentToken());
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)parser.getText());
    }

    public void testSkipChildren_object() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_ENTRY);
        parser.nextToken();
        parser.skipChildren();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
    }

    public void testSkipChildren_array() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        parser.nextToken();
        parser.skipToKey("entries");
        parser.skipChildren();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_ARRAY, (Object)parser.getCurrentToken());
    }

    public void testNextToken() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_ARRAY, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_ARRAY, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.nextToken());
        AbstractJsonFactoryTest.assertNull((Object)parser.nextToken());
    }

    public void testCurrentToken() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(JSON_FEED);
        AbstractJsonFactoryTest.assertNull((Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_ARRAY, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_STRING, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_ARRAY, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
        parser.nextToken();
        AbstractJsonFactoryTest.assertNull((Object)parser.getCurrentToken());
    }

    public void testParse() throws Exception {
        JsonParser parser = this.newFactory().createJsonParser(CONTAINED_MAP);
        parser.nextToken();
        A a = (A)parser.parse(A.class);
        AbstractJsonFactoryTest.assertEquals((Object)ImmutableMap.of((Object)"title", (Object)"foo"), a.map);
    }

    public void testParser_numberTypes() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(NUMBER_TYPES);
        parser.nextToken();
        NumberTypes result = (NumberTypes)parser.parse(NumberTypes.class);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TYPES, (String)factory.toString((Object)result));
        parser = factory.createJsonParser(NUMBER_TYPES_AS_STRING);
        parser.nextToken();
        NumberTypesAsString resultAsString = (NumberTypesAsString)parser.parse(NumberTypesAsString.class);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TYPES_AS_STRING, (String)factory.toString((Object)resultAsString));
        try {
            parser = factory.createJsonParser(NUMBER_TYPES_AS_STRING);
            parser.nextToken();
            parser.parse(NumberTypes.class);
            AbstractJsonFactoryTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            parser = factory.createJsonParser(NUMBER_TYPES);
            parser.nextToken();
            parser.parse(NumberTypesAsString.class);
            AbstractJsonFactoryTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToFromString() throws Exception {
        JsonFactory factory = this.newFactory();
        NumberTypes result = (NumberTypes)factory.fromString(NUMBER_TYPES, NumberTypes.class);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TYPES, (String)factory.toString((Object)result));
    }

    public void testToFromString_UTF8() throws Exception {
        JsonFactory factory = this.newFactory();
        GenericJson result = (GenericJson)factory.fromString(UTF8_JSON, GenericJson.class);
        AbstractJsonFactoryTest.assertEquals((Object)UTF8_VALUE, (Object)result.get((Object)"value"));
        AbstractJsonFactoryTest.assertEquals((String)UTF8_JSON, (String)factory.toString((Object)result));
    }

    public void testParser_anyType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ANY_TYPE);
        parser.nextToken();
        AnyType result = (AnyType)parser.parse(AnyType.class);
        AbstractJsonFactoryTest.assertEquals((String)ANY_TYPE, (String)factory.toString((Object)result));
    }

    public void testParser_arrayType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ARRAY_TYPE);
        parser.nextToken();
        ArrayType result = (ArrayType)parser.parse(ArrayType.class);
        AbstractJsonFactoryTest.assertEquals((String)ARRAY_TYPE, (String)factory.toString((Object)result));
        int[] arr = result.arr;
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{4, 5}, arr));
        int[][] arr2 = result.arr2;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr2.length);
        int[] arr20 = arr2[0];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr20.length);
        int arr200 = arr20[0];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arr200);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr20[1]);
        int[] arr21 = arr2[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arr21.length);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)arr21[0]);
        Integer[] integerArr = result.integerArr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)integerArr.length);
        AbstractJsonFactoryTest.assertEquals((int)6, (int)integerArr[0]);
    }

    public void testParser_collectionType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(COLLECTION_TYPE);
        parser.nextToken();
        CollectionOfCollectionType result = (CollectionOfCollectionType)parser.parse(CollectionOfCollectionType.class);
        AbstractJsonFactoryTest.assertEquals((String)COLLECTION_TYPE, (String)factory.toString((Object)result));
        LinkedList<LinkedList<String>> arr = result.arr;
        LinkedList<String> linkedlist = arr.get(0);
        AbstractJsonFactoryTest.assertEquals((String)"a", (String)linkedlist.get(0));
    }

    public void testParser_mapType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(MAP_TYPE);
        parser.nextToken();
        MapOfMapType result = (MapOfMapType)parser.parse(MapOfMapType.class);
        AbstractJsonFactoryTest.assertEquals((String)MAP_TYPE, (String)factory.toString((Object)result));
        Map<String, Map<String, Integer>>[] value = result.value;
        Map<String, Map<String, Integer>> firstMap = value[0];
        Map<String, Integer> map1 = firstMap.get("map1");
        Integer integer = map1.get("k1");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)integer);
        Map<String, Integer> map2 = firstMap.get("map2");
        AbstractJsonFactoryTest.assertEquals((int)3, (int)map2.get("kk1"));
        AbstractJsonFactoryTest.assertEquals((int)4, (int)map2.get("kk2"));
    }

    public void testParser_hashmapForMapType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(MAP_TYPE);
        parser.nextToken();
        HashMap result = (HashMap)parser.parse(HashMap.class);
        AbstractJsonFactoryTest.assertEquals((String)MAP_TYPE, (String)factory.toString((Object)result));
        ArrayList value = (ArrayList)result.get("value");
        ArrayMap firstMap = (ArrayMap)value.get(0);
        ArrayMap map1 = (ArrayMap)firstMap.get((Object)"map1");
        BigDecimal integer = (BigDecimal)map1.get((Object)"k1");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)integer.intValue());
    }

    public void testParser_wildCardType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(WILDCARD_TYPE);
        parser.nextToken();
        WildCardTypes result = (WildCardTypes)parser.parse(WildCardTypes.class);
        AbstractJsonFactoryTest.assertEquals((String)WILDCARD_TYPE, (String)factory.toString((Object)result));
        Collection<?>[] simple = result.simple;
        ArrayList wildcard = (ArrayList)simple[0];
        BigDecimal wildcardFirstValue = (BigDecimal)wildcard.get(0);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)wildcardFirstValue.intValue());
        Collection<? extends Integer>[] upper = result.upper;
        ArrayList wildcardUpper = (ArrayList)upper[0];
        Integer wildcardFirstValueUpper = (Integer)wildcardUpper.get(0);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)wildcardFirstValueUpper);
        Collection<? super Integer>[] lower = result.lower;
        ArrayList wildcardLower = (ArrayList)lower[0];
        Integer wildcardFirstValueLower = (Integer)wildcardLower.get(0);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)wildcardFirstValueLower);
        Map<String, ?> map = result.map;
        BigDecimal mapValue = (BigDecimal)map.get("v");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)mapValue.intValue());
        Map<String, ? extends Integer> mapUpper = result.mapUpper;
        Integer mapUpperValue = mapUpper.get("v");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)mapUpperValue);
        Collection<? super TreeMap<String, ? extends Integer>> mapInWild = result.mapInWild;
        TreeMap mapInWildFirst = (TreeMap)mapInWild.toArray()[0];
        Integer mapInWildFirstValue = (Integer)mapInWildFirst.get("v");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)mapInWildFirstValue);
    }

    public void testParser_integerTypeVariableType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INTEGER_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        IntegerTypeVariableType result = (IntegerTypeVariableType)parser.parse(IntegerTypeVariableType.class);
        AbstractJsonFactoryTest.assertEquals((String)INTEGER_TYPE_VARIABLE_TYPE, (String)factory.toString((Object)result));
        Integer[][] arr = (Integer[][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(Integer[].class), (Object)arr[0]);
        Integer[] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.NULL_INTEGER, (Object)subArr[0]);
        Integer arrValue = subArr[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue);
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.NULL_INTEGER, subList.get(0));
        arrValue = (Integer)subList.get(1);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue);
        Integer nullValue = (Integer)result.nullValue;
        AbstractJsonFactoryTest.assertEquals((Object)Data.NULL_INTEGER, (Object)nullValue);
        Integer value = (Integer)result.value;
        AbstractJsonFactoryTest.assertEquals((int)1, (int)value);
    }

    public void testParser_intArrayTypeVariableType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INT_ARRAY_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        IntArrayTypeVariableType result = (IntArrayTypeVariableType)parser.parse(IntArrayTypeVariableType.class);
        AbstractJsonFactoryTest.assertEquals((String)INT_ARRAY_TYPE_VARIABLE_TYPE, (String)factory.toString((Object)result));
        int[][][] arr = (int[][][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(int[][].class), (Object)arr[0]);
        int[][] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(int[].class), (Object)subArr[0]);
        int[] arrValue = subArr[1];
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1}, arrValue));
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(int[].class), subList.get(0));
        arrValue = (int[])subList.get(1);
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1}, arrValue));
        int[] nullValue = (int[])result.nullValue;
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(int[].class), (Object)nullValue);
        int[] value = (int[])result.value;
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1}, value));
    }

    public void testParser_doubleListTypeVariableType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(DOUBLE_LIST_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        DoubleListTypeVariableType result = (DoubleListTypeVariableType)parser.parse(DoubleListTypeVariableType.class);
        AbstractJsonFactoryTest.assertEquals((String)DOUBLE_LIST_TYPE_VARIABLE_TYPE, (String)factory.toString((Object)result));
        List[][] arr = (List[][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(List[].class), (Object)arr[0]);
        List[] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(ArrayList.class), (Object)subArr[0]);
        List arrValue = subArr[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.size());
        Double dValue = (Double)arrValue.get(0);
        AbstractJsonFactoryTest.assertEquals((Object)1.0, (Object)dValue);
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(ArrayList.class), subList.get(0));
        arrValue = (List)subList.get(1);
        AbstractJsonFactoryTest.assertEquals((Object)ImmutableList.of((Object)1.0), (Object)arrValue);
        List nullValue = (List)result.nullValue;
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(ArrayList.class), (Object)nullValue);
        List value = (List)result.value;
        AbstractJsonFactoryTest.assertEquals((Object)ImmutableList.of((Object)1.0), (Object)value);
    }

    public void testParser_floatMapTypeVariableType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(FLOAT_MAP_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        FloatMapTypeVariableType result = (FloatMapTypeVariableType)parser.parse(FloatMapTypeVariableType.class);
        AbstractJsonFactoryTest.assertEquals((String)FLOAT_MAP_TYPE_VARIABLE_TYPE, (String)factory.toString((Object)result));
        Map[][] arr = (Map[][])result.arr;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(Map[].class), (Object)arr[0]);
        Map[] subArr = arr[1];
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(HashMap.class), (Object)subArr[0]);
        Map arrValue = subArr[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.size());
        Float fValue = (Float)arrValue.get("a");
        AbstractJsonFactoryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)fValue);
        LinkedList list = result.list;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)list.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(LinkedList.class), list.get(0));
        LinkedList subList = (LinkedList)list.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subList.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(HashMap.class), subList.get(0));
        arrValue = (Map)subList.get(1);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.size());
        fValue = (Float)arrValue.get("a");
        AbstractJsonFactoryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)fValue);
        Map nullValue = (Map)result.nullValue;
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(HashMap.class), (Object)nullValue);
        Map value = (Map)result.value;
        AbstractJsonFactoryTest.assertEquals((int)1, (int)value.size());
        fValue = (Float)value.get("a");
        AbstractJsonFactoryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)fValue);
    }

    public void testParser_treemapForTypeVariableType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INTEGER_TYPE_VARIABLE_TYPE);
        parser.nextToken();
        TreeMap result = (TreeMap)parser.parse(TreeMap.class);
        AbstractJsonFactoryTest.assertEquals((String)INTEGER_TYPE_VARIABLE_TYPE, (String)factory.toString((Object)result));
        ArrayList arr = (ArrayList)result.get("arr");
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(Object.class), arr.get(0));
        ArrayList subArr = (ArrayList)arr.get(1);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)subArr.size());
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(Object.class), subArr.get(0));
        BigDecimal arrValue = (BigDecimal)subArr.get(1);
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arrValue.intValue());
        Object nullValue = result.get("nullValue");
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(Object.class), nullValue);
        BigDecimal value = (BigDecimal)result.get("value");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)value.intValue());
    }

    public void testParser_nullValue() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(NULL_VALUE);
        parser.nextToken();
        StringNullValue result = (StringNullValue)parser.parse(StringNullValue.class);
        AbstractJsonFactoryTest.assertEquals((String)NULL_VALUE, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((String)Data.NULL_STRING, (String)result.value);
        String[] arr = result.arr;
        AbstractJsonFactoryTest.assertEquals((int)1, (int)arr.length);
        AbstractJsonFactoryTest.assertEquals((String)((String)Data.nullOf(String.class)), (String)arr[0]);
        String[][] arr2 = result.arr2;
        AbstractJsonFactoryTest.assertEquals((int)2, (int)arr2.length);
        AbstractJsonFactoryTest.assertEquals((Object)Data.nullOf(String[].class), (Object)arr2[0]);
        String[] subArr2 = arr2[1];
        AbstractJsonFactoryTest.assertEquals((int)1, (int)subArr2.length);
        AbstractJsonFactoryTest.assertEquals((String)Data.NULL_STRING, (String)subArr2[0]);
    }

    public void testParser_enumValue() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ENUM_VALUE);
        parser.nextToken();
        EnumValue result = (EnumValue)parser.parse(EnumValue.class);
        AbstractJsonFactoryTest.assertEquals((String)ENUM_VALUE, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)E.VALUE), (Object)((Object)result.value));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)E.OTHER_VALUE), (Object)((Object)result.otherValue));
        AbstractJsonFactoryTest.assertEquals((Object)((Object)E.NULL), (Object)((Object)result.nullValue));
    }

    public void testParser_typeVariablesPassAround() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(TYPE_VARS);
        parser.nextToken();
        TypeVariablesPassedAround result = (TypeVariablesPassedAround)parser.parse(TypeVariablesPassedAround.class);
        AbstractJsonFactoryTest.assertEquals((String)TYPE_VARS, (String)factory.toString((Object)result));
        LinkedList f = (LinkedList)result.y.z.f;
        AbstractJsonFactoryTest.assertEquals((String)"abc", (String)((String)f.get(0)));
    }

    public void testParser_stringArray() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(STRING_ARRAY);
        parser.nextToken();
        Object[] result = (String[])parser.parse(String[].class);
        AbstractJsonFactoryTest.assertEquals((String)STRING_ARRAY, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c"}, result));
    }

    public void testParser_intArray() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(INT_ARRAY);
        parser.nextToken();
        int[] result = (int[])parser.parse(int[].class);
        AbstractJsonFactoryTest.assertEquals((String)INT_ARRAY, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3}, result));
    }

    public void testParser_emptyArray() throws Exception {
        JsonFactory factory = this.newFactory();
        String[] result = (String[])factory.createJsonParser(EMPTY_ARRAY).parse(String[].class);
        AbstractJsonFactoryTest.assertEquals((String)EMPTY_ARRAY, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((int)0, (int)result.length);
    }

    public void testParser_partialEmptyArray() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(EMPTY_ARRAY);
        parser.nextToken();
        parser.nextToken();
        String[] result = (String[])parser.parse(String[].class);
        AbstractJsonFactoryTest.assertEquals((String)EMPTY_ARRAY, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((int)0, (int)result.length);
    }

    public void testParser_num() throws Exception {
        JsonFactory factory = this.newFactory();
        int result = (Integer)factory.createJsonParser(NUMBER_TOP_VALUE).parse(Integer.TYPE);
        AbstractJsonFactoryTest.assertEquals((String)NUMBER_TOP_VALUE, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((int)1, (int)result);
    }

    public void testParser_string() throws Exception {
        JsonFactory factory = this.newFactory();
        String result = (String)factory.createJsonParser(STRING_TOP_VALUE).parse(String.class);
        AbstractJsonFactoryTest.assertEquals((String)STRING_TOP_VALUE, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertEquals((String)"a", (String)result);
    }

    public void testParser_null() throws Exception {
        JsonFactory factory = this.newFactory();
        String result = (String)factory.createJsonParser(NULL_TOP_VALUE).parse(String.class);
        AbstractJsonFactoryTest.assertEquals((String)NULL_TOP_VALUE, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertTrue((boolean)Data.isNull((Object)result));
    }

    public void testParser_bool() throws Exception {
        JsonFactory factory = this.newFactory();
        boolean result = (Boolean)factory.createJsonParser(BOOL_TOP_VALUE).parse(Boolean.TYPE);
        AbstractJsonFactoryTest.assertEquals((String)BOOL_TOP_VALUE, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertTrue((boolean)result);
    }

    public final void testGenerateEntry() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator generator = this.newFactory().createJsonGenerator((OutputStream)out, Charsets.UTF_8);
        Entry entry = new Entry();
        entry.title = "foo";
        generator.serialize((Object)entry);
        generator.flush();
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)StringUtils.newStringUtf8((byte[])out.toByteArray()));
    }

    public final void testGenerateFeed() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator generator = this.newFactory().createJsonGenerator((OutputStream)out, Charsets.UTF_8);
        Feed feed = new Feed();
        Entry entryFoo = new Entry();
        entryFoo.title = "foo";
        Entry entryBar = new Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList<Entry>();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        generator.serialize((Object)feed);
        generator.flush();
        AbstractJsonFactoryTest.assertEquals((String)JSON_FEED, (String)StringUtils.newStringUtf8((byte[])out.toByteArray()));
    }

    public final void testToString_entry() throws Exception {
        Entry entry = new Entry();
        entry.title = "foo";
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)this.newFactory().toString((Object)entry));
    }

    public final void testToString_Feed() throws Exception {
        Feed feed = new Feed();
        Entry entryFoo = new Entry();
        entryFoo.title = "foo";
        Entry entryBar = new Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList<Entry>();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        AbstractJsonFactoryTest.assertEquals((String)JSON_FEED, (String)this.newFactory().toString((Object)feed));
    }

    public final void testToByteArray_entry() throws Exception {
        Entry entry = new Entry();
        entry.title = "foo";
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(StringUtils.getBytesUtf8((String)JSON_ENTRY), this.newFactory().toByteArray((Object)entry)));
    }

    public final void testToPrettyString_entryApproximate() throws Exception {
        Entry entry = new Entry();
        entry.title = "foo";
        JsonFactory factory = this.newFactory();
        String prettyString = factory.toPrettyString((Object)entry);
        AbstractJsonFactoryTest.assertEquals((String)JSON_ENTRY, (String)factory.toString(factory.fromString(prettyString, Entry.class)));
    }

    public final void testToPrettyString_FeedApproximate() throws Exception {
        Feed feed = new Feed();
        Entry entryFoo = new Entry();
        entryFoo.title = "foo";
        Entry entryBar = new Entry();
        entryBar.title = "bar";
        feed.entries = new ArrayList<Entry>();
        feed.entries.add(entryFoo);
        feed.entries.add(entryBar);
        JsonFactory factory = this.newFactory();
        String prettyString = factory.toPrettyString((Object)feed);
        AbstractJsonFactoryTest.assertEquals((String)JSON_FEED, (String)factory.toString(factory.fromString(prettyString, Feed.class)));
    }

    public void testParser_nullInputStream() throws Exception {
        try {
            this.newFactory().createJsonParser((InputStream)null, Charsets.UTF_8);
            AbstractJsonFactoryTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParser_nullString() throws Exception {
        try {
            this.newFactory().createJsonParser((String)null);
            AbstractJsonFactoryTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParser_nullReader() throws Exception {
        try {
            this.newFactory().createJsonParser((Reader)null);
            AbstractJsonFactoryTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testObjectParserParse_entry() throws Exception {
        Entry entry = (Entry)this.newFactory().createJsonObjectParser().parseAndClose((Reader)new StringReader(JSON_ENTRY), new TypeToken<Entry>(){}.getType());
        AbstractJsonFactoryTest.assertEquals((String)"foo", (String)entry.title);
    }

    public void testObjectParserParse_stringList() throws Exception {
        JsonFactory factory = this.newFactory();
        List result = (List)factory.createJsonObjectParser().parseAndClose((Reader)new StringReader(STRING_ARRAY), new TypeToken<List<String>>(){}.getType());
        result.get(0);
        AbstractJsonFactoryTest.assertEquals((String)STRING_ARRAY, (String)factory.toString((Object)result));
        AbstractJsonFactoryTest.assertTrue((boolean)ImmutableList.of((Object)"a", (Object)"b", (Object)"c").equals((Object)result));
    }

    public void testToString_withFactory() {
        GenericJson data = new GenericJson();
        data.put("a", (Object)"b");
        data.setFactory(this.newFactory());
        AbstractJsonFactoryTest.assertEquals((String)SIMPLE, (String)data.toString());
    }

    public void testFactory() {
        JsonFactory factory = this.newFactory();
        GenericJson data = new GenericJson();
        data.setFactory(factory);
        AbstractJsonFactoryTest.assertEquals((Object)factory, (Object)data.getFactory());
    }

    private JsonParser createParser(String json) throws Exception {
        return this.newFactory().createJsonParser(json);
    }

    public void testSkipToKey_firstKey() throws Exception {
        JsonParser parser = this.createParser(JSON_THREE_ELEMENTS);
        AbstractJsonFactoryTest.assertEquals((String)"one", (String)parser.skipToKey((Set)ImmutableSet.of((Object)"one")));
        parser.skipToKey("num");
        AbstractJsonFactoryTest.assertEquals((int)1, (int)parser.getIntValue());
    }

    public void testSkipToKey_lastKey() throws Exception {
        JsonParser parser = this.createParser(JSON_THREE_ELEMENTS);
        AbstractJsonFactoryTest.assertEquals((String)"three", (String)parser.skipToKey((Set)ImmutableSet.of((Object)"three")));
        parser.skipToKey("num");
        AbstractJsonFactoryTest.assertEquals((int)3, (int)parser.getIntValue());
    }

    public void testSkipToKey_multipleKeys() throws Exception {
        JsonParser parser = this.createParser(JSON_THREE_ELEMENTS);
        AbstractJsonFactoryTest.assertEquals((String)"two", (String)parser.skipToKey((Set)ImmutableSet.of((Object)"foo", (Object)"three", (Object)"two")));
        parser.skipToKey("num");
        AbstractJsonFactoryTest.assertEquals((int)2, (int)parser.getIntValue());
    }

    public void testSkipToKey_noMatch() throws Exception {
        JsonParser parser = this.createParser(JSON_THREE_ELEMENTS);
        AbstractJsonFactoryTest.assertEquals(null, (String)parser.skipToKey((Set)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"num")));
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)parser.getCurrentToken());
    }

    public final void testGson() throws Exception {
        byte[] asciiJson = Charsets.UTF_8.encode("{ \"foo\": 123 }").array();
        JsonParser jp = this.newFactory().createJsonParser((InputStream)new ByteArrayInputStream(asciiJson), Charsets.UTF_8);
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.START_OBJECT, (Object)jp.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.FIELD_NAME, (Object)jp.nextToken());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.VALUE_NUMBER_INT, (Object)jp.nextToken());
        AbstractJsonFactoryTest.assertEquals((int)123, (int)jp.getIntValue());
        AbstractJsonFactoryTest.assertEquals((Object)JsonToken.END_OBJECT, (Object)jp.nextToken());
    }

    public final void testParse_array() throws Exception {
        byte[] jsonData = Charsets.UTF_8.encode("[ 123, 456 ]").array();
        JsonParser jp = this.newFactory().createJsonParser((InputStream)new ByteArrayInputStream(jsonData), Charsets.UTF_8);
        Class<Integer[]> myType = Integer[].class;
        Integer[] array = (Integer[])jp.parse(myType, true);
        AbstractJsonFactoryTest.assertNotNull((Object)array);
        AbstractJsonFactoryTest.assertEquals((Object)123, (Object)array[0]);
        AbstractJsonFactoryTest.assertEquals((Object)456, (Object)array[1]);
    }

    public final void testParse_class() throws Exception {
        byte[] jsonData = Charsets.UTF_8.encode("{ \"foo\": 123 }").array();
        JsonParser jp = this.newFactory().createJsonParser((InputStream)new ByteArrayInputStream(jsonData), Charsets.UTF_8);
        Class<TestClass> myType = TestClass.class;
        TestClass instance = (TestClass)jp.parse(myType, true);
        AbstractJsonFactoryTest.assertNotNull((Object)instance);
        AbstractJsonFactoryTest.assertEquals((int)123, (int)instance.foo);
    }

    public final void testCreateJsonParser_nullCharset() throws Exception {
        byte[] jsonData = Charsets.UTF_8.encode("{ \"foo\": 123 }").array();
        JsonParser jp = this.newFactory().createJsonParser((InputStream)new ByteArrayInputStream(jsonData), null);
        Class<TestClass> myType = TestClass.class;
        TestClass instance = (TestClass)jp.parse(myType, true);
        AbstractJsonFactoryTest.assertNotNull((Object)instance);
        AbstractJsonFactoryTest.assertEquals((int)123, (int)instance.foo);
    }

    public final void testGenerate_infinityOrNanError() throws Exception {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator generator = this.newFactory().createJsonGenerator((OutputStream)out, Charsets.UTF_8);
        NumberTypes num = new NumberTypes();
        float[] objectArray = new float[]{Float.NaN, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            float f;
            num.floatValue = f = objectArray[n];
            try {
                generator.serialize((Object)num);
                AbstractJsonFactoryTest.fail((String)("expected " + IllegalArgumentException.class));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        num.floatValue = 0.0f;
        double[] dArray = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            double d;
            num.doubleValue = d = dArray[n];
            try {
                generator.serialize((Object)num);
                AbstractJsonFactoryTest.fail((String)("expected " + IllegalArgumentException.class));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testParser_extendsGenericJson() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(EXTENDS_JSON);
        parser.nextToken();
        ExtendsGenericJson result = (ExtendsGenericJson)((Object)parser.parse(ExtendsGenericJson.class));
        AbstractJsonFactoryTest.assertEquals((String)EXTENDS_JSON, (String)factory.toString((Object)result));
    }

    public void testJsonObjectParser_reader() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonObjectParser parser = new JsonObjectParser(factory);
        Simple simple = (Simple)parser.parseAndClose((Reader)new StringReader(SIMPLE), Simple.class);
        AbstractJsonFactoryTest.assertEquals((String)"b", (String)simple.a);
    }

    public void testJsonObjectParser_inputStream() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonObjectParser parser = new JsonObjectParser(factory);
        Simple simple = (Simple)parser.parseAndClose((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)SIMPLE)), Charsets.UTF_8, Simple.class);
        AbstractJsonFactoryTest.assertEquals((String)"b", (String)simple.a);
    }

    public void testJsonObjectParser_readerWrapped() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonObjectParser parser = new JsonObjectParser.Builder(factory).setWrapperKeys(Collections.singleton("d")).build();
        Simple simple = (Simple)parser.parseAndClose((Reader)new StringReader(SIMPLE_WRAPPED), Simple.class);
        AbstractJsonFactoryTest.assertEquals((String)"b", (String)simple.a);
    }

    public void testJsonObjectParser_inputStreamWrapped() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonObjectParser parser = new JsonObjectParser.Builder(factory).setWrapperKeys(Collections.singleton("d")).build();
        Simple simple = (Simple)parser.parseAndClose((InputStream)new ByteArrayInputStream(StringUtils.getBytesUtf8((String)SIMPLE_WRAPPED)), Charsets.UTF_8, Simple.class);
        AbstractJsonFactoryTest.assertEquals((String)"b", (String)simple.a);
    }

    public void testJsonHttpContent_simple() throws Exception {
        JsonFactory factory = this.newFactory();
        Simple simple = new Simple();
        simple.a = "b";
        JsonHttpContent content = new JsonHttpContent(factory, (Object)simple);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        AbstractJsonFactoryTest.assertEquals((String)SIMPLE, (String)out.toString("UTF-8"));
    }

    public void testJsonHttpContent_wrapped() throws Exception {
        JsonFactory factory = this.newFactory();
        Simple simple = new Simple();
        simple.a = "b";
        JsonHttpContent content = new JsonHttpContent(factory, (Object)simple).setWrapperKey("d");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        AbstractJsonFactoryTest.assertEquals((String)SIMPLE_WRAPPED, (String)out.toString("UTF-8"));
    }

    public void testParse_void() throws Exception {
        this.subtestParse_void(null);
        this.subtestParse_void(STRING_TOP_VALUE);
        this.subtestParse_void(NULL_TOP_VALUE);
        this.subtestParse_void(BOOL_TOP_VALUE);
        this.subtestParse_void("false");
        this.subtestParse_void("123");
        this.subtestParse_void("123.456");
        this.subtestParse_void("[1]");
        this.subtestParse_void("{\"v\":\"ignored\"}");
    }

    public void subtestParse_void(String value) throws Exception {
        JsonFactory factory = this.newFactory();
        String inputString = "{" + (value == null ? EMPTY : "\"v\":" + value + ",") + "\"s\":\"svalue\"}";
        V v = (V)factory.fromString(inputString, V.class);
        AbstractJsonFactoryTest.assertNull((Object)v.v);
        AbstractJsonFactoryTest.assertEquals((String)"svalue", (String)v.s);
        AbstractJsonFactoryTest.assertNull((Object)factory.fromString(inputString, Void.class));
    }

    public void testParse_boolean() throws Exception {
        JsonFactory factory = this.newFactory();
        BooleanTypes parsed = (BooleanTypes)factory.fromString("{}", BooleanTypes.class);
        AbstractJsonFactoryTest.assertFalse((boolean)parsed.bool);
        AbstractJsonFactoryTest.assertNull((Object)parsed.boolObj);
        AbstractJsonFactoryTest.assertEquals((String)BOOLEAN_TYPE_EMPTY_OUTPUT, (String)factory.toString((Object)parsed));
        parsed = (BooleanTypes)factory.fromString(BOOLEAN_TYPE_TRUE, BooleanTypes.class);
        AbstractJsonFactoryTest.assertTrue((boolean)parsed.bool);
        AbstractJsonFactoryTest.assertTrue((parsed.boolObj != false && !Data.isNull((Object)parsed.boolObj) ? 1 : 0) != 0);
        AbstractJsonFactoryTest.assertEquals((String)BOOLEAN_TYPE_TRUE, (String)factory.toString((Object)parsed));
        parsed = (BooleanTypes)factory.fromString(BOOLEAN_TYPE_FALSE, BooleanTypes.class);
        AbstractJsonFactoryTest.assertFalse((boolean)parsed.bool);
        AbstractJsonFactoryTest.assertTrue((parsed.boolObj == false && !Data.isNull((Object)parsed.boolObj) ? 1 : 0) != 0);
        AbstractJsonFactoryTest.assertEquals((String)BOOLEAN_TYPE_FALSE, (String)factory.toString((Object)parsed));
        parsed = (BooleanTypes)factory.fromString(BOOLEAN_TYPE_NULL, BooleanTypes.class);
        AbstractJsonFactoryTest.assertFalse((boolean)parsed.bool);
        AbstractJsonFactoryTest.assertTrue((boolean)Data.isNull((Object)parsed.boolObj));
        AbstractJsonFactoryTest.assertEquals((String)BOOLEAN_TYPE_NULL_OUTPUT, (String)factory.toString((Object)parsed));
        try {
            factory.fromString(BOOLEAN_TYPE_WRONG, BooleanTypes.class);
            AbstractJsonFactoryTest.fail((String)("expected " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParser_heterogeneousSchemata() throws Exception {
        this.testParser_heterogeneousSchemata_Helper(DOG, CENTIPEDE);
        this.testParser_heterogeneousSchemata_Helper(DOG_OPTIMIZED, CENTIPEDE_OPTIMIZED);
        this.testParser_heterogeneousSchemata_Helper(DOG_EXTRA_INFO, CENTIPEDE_EXTRA_INFO);
    }

    private void testParser_heterogeneousSchemata_Helper(String dogJson, String centipedeJson) throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(dogJson);
        Animal dog = (Animal)parser.parse(Animal.class);
        AbstractJsonFactoryTest.assertEquals((String)DOG, (String)factory.toString((Object)dog));
        AbstractJsonFactoryTest.assertEquals(Dog.class, dog.getClass());
        AbstractJsonFactoryTest.assertEquals((String)"Fido", (String)dog.name);
        AbstractJsonFactoryTest.assertEquals((String)"dog", (String)dog.type);
        AbstractJsonFactoryTest.assertEquals((int)4, (int)dog.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)((Dog)dog).tricksKnown);
        parser = factory.createJsonParser(centipedeJson);
        parser.nextToken();
        Animal centipede = (Animal)parser.parse(Animal.class);
        AbstractJsonFactoryTest.assertEquals((String)CENTIPEDE, (String)factory.toString((Object)centipede));
        AbstractJsonFactoryTest.assertEquals(Centipede.class, centipede.getClass());
        AbstractJsonFactoryTest.assertEquals((String)"Mr. Icky", (String)centipede.name);
        AbstractJsonFactoryTest.assertEquals((String)"bug", (String)centipede.type);
        AbstractJsonFactoryTest.assertEquals((int)68, (int)centipede.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((String)"green", (String)((Centipede)centipede).color);
    }

    public void testParser_heterogeneousSchema_missingType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(ANIMAL_WITHOUT_TYPE);
        try {
            parser.parse(Animal.class);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AbstractJsonFactoryTest.fail((String)"IllegalArgumentException expected on heterogeneous schema without type field specified");
    }

    public void testParser_heterogeneousSchema_withObject() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(HUMAN);
        Animal human = (Animal)parser.parse(Animal.class);
        AbstractJsonFactoryTest.assertEquals((String)HUMAN, (String)factory.toString((Object)human));
        Dog dog = ((Human)human).bestFriend;
        AbstractJsonFactoryTest.assertEquals((String)DOG, (String)factory.toString((Object)dog));
        AbstractJsonFactoryTest.assertEquals(Dog.class, dog.getClass());
        AbstractJsonFactoryTest.assertEquals((String)"Fido", (String)dog.name);
        AbstractJsonFactoryTest.assertEquals((String)"dog", (String)dog.type);
        AbstractJsonFactoryTest.assertEquals((int)4, (int)dog.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)dog.tricksKnown);
        AbstractJsonFactoryTest.assertEquals((String)"Joe", (String)human.name);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)human.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((String)"human", (String)human.type);
    }

    public void testParser_heterogeneousSchema_genericJson() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(DOG_EXTRA_INFO);
        AnimalGenericJson dog = (AnimalGenericJson)((Object)parser.parse(AnimalGenericJson.class));
        AbstractJsonFactoryTest.assertEquals((String)DOG_EXTRA_INFO_ORDERED, (String)factory.toString((Object)dog));
        AbstractJsonFactoryTest.assertEquals(DogGenericJson.class, ((Object)((Object)dog)).getClass());
        AbstractJsonFactoryTest.assertEquals((String)"Fido", (String)dog.name);
        AbstractJsonFactoryTest.assertEquals((String)"dog", (String)dog.type);
        AbstractJsonFactoryTest.assertEquals((int)4, (int)dog.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)((DogGenericJson)dog).tricksKnown);
        AbstractJsonFactoryTest.assertEquals((Object)"this is not being used!", (Object)dog.get("unusedInfo"));
        BigDecimal foo = (BigDecimal)((ArrayMap)dog.get("unused")).get((Object)"foo");
        AbstractJsonFactoryTest.assertEquals((int)200, (int)foo.intValue());
    }

    public void testParser_heterogeneousSchema_withArrays() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(DOG_WITH_FAMILY);
        Animal dog = (Animal)parser.parse(DogWithFamily.class);
        AbstractJsonFactoryTest.assertEquals((String)DOG_WITH_FAMILY, (String)factory.toString((Object)dog));
        AbstractJsonFactoryTest.assertEquals(DogWithFamily.class, dog.getClass());
        AbstractJsonFactoryTest.assertEquals((String)"Bob", (String)dog.name);
        AbstractJsonFactoryTest.assertEquals((String)"dogwithfamily", (String)dog.type);
        AbstractJsonFactoryTest.assertEquals((int)4, (int)dog.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((int)10, (int)((DogWithFamily)dog).tricksKnown);
        Object[] nicknames = new String[]{"Fluffy", "Hey, you"};
        AbstractJsonFactoryTest.assertTrue((boolean)Arrays.equals(nicknames, ((DogWithFamily)dog).nicknames));
        Animal child = ((DogWithFamily)dog).children[0];
        AbstractJsonFactoryTest.assertEquals((String)"Fido", (String)child.name);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)((Dog)child).tricksKnown);
        Animal child2 = ((DogWithFamily)dog).children[1];
        AbstractJsonFactoryTest.assertEquals((String)"Mr. Icky", (String)child2.name);
        AbstractJsonFactoryTest.assertEquals((int)68, (int)((Centipede)child2).numberOfLegs);
    }

    public void testParser_heterogeneousSchema_withNullArrays() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(DOG_WITH_NO_FAMILY);
        Animal dog = (Animal)parser.parse(DogWithFamily.class);
        AbstractJsonFactoryTest.assertEquals(DogWithFamily.class, dog.getClass());
        AbstractJsonFactoryTest.assertEquals((String)DOG_WITH_NO_FAMILY_PARSED, (String)factory.toString((Object)dog));
        AbstractJsonFactoryTest.assertEquals((int)4, (int)dog.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((int)0, (int)((Dog)dog).tricksKnown);
        AbstractJsonFactoryTest.assertEquals(null, (String)dog.name);
        AbstractJsonFactoryTest.assertEquals(null, (Object)((DogWithFamily)dog).nicknames);
        AbstractJsonFactoryTest.assertEquals(null, (Object)((DogWithFamily)dog).children);
    }

    public void testParser_polymorphicClass_tooManyAnnotations() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(MULTIPLE_ANNOTATIONS_JSON);
        try {
            parser.parse(PolymorphicWithMultipleAnnotations.class);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AbstractJsonFactoryTest.fail((String)"Expected IllegalArgumentException on class with multiple @JsonPolymorphicTypeMap annotations.");
    }

    public void testParser_heterogeneousSchema_numericType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(POLYMORPHIC_NUMERIC_TYPE_1);
        PolymorphicWithNumericType t1 = (PolymorphicWithNumericType)parser.parse(PolymorphicWithNumericType.class);
        AbstractJsonFactoryTest.assertEquals(NumericTypedSubclass1.class, t1.getClass());
        factory = this.newFactory();
        parser = factory.createJsonParser(POLYMORPHIC_NUMERIC_TYPE_2);
        PolymorphicWithNumericType t2 = (PolymorphicWithNumericType)parser.parse(PolymorphicWithNumericType.class);
        AbstractJsonFactoryTest.assertEquals(NumericTypedSubclass2.class, t2.getClass());
    }

    public void testParser_heterogeneousSchema_numericValueType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(POLYMORPHIC_NUMERIC_TYPE_1);
        PolymorphicWithNumericValueType t1 = (PolymorphicWithNumericValueType)parser.parse(PolymorphicWithNumericValueType.class);
        AbstractJsonFactoryTest.assertEquals(NumericValueTypedSubclass1.class, t1.getClass());
        factory = this.newFactory();
        parser = factory.createJsonParser(POLYMORPHIC_NUMERIC_TYPE_2);
        PolymorphicWithNumericValueType t2 = (PolymorphicWithNumericValueType)parser.parse(PolymorphicWithNumericValueType.class);
        AbstractJsonFactoryTest.assertEquals(NumericValueTypedSubclass2.class, t2.getClass());
        factory = this.newFactory();
        parser = factory.createJsonParser(POLYMORPHIC_NUMERIC_UNSPECIFIED_TYPE);
        try {
            parser.parse(PolymorphicWithNumericValueType.class);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AbstractJsonFactoryTest.fail((String)"IllegalArgumentException expected on heterogeneous schema without type field specified");
    }

    public void testParser_heterogeneousSchema_illegalValueType() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(POLYMORPHIC_NUMERIC_TYPE_1);
        try {
            parser.parse(PolymorphicWithIllegalValueType.class);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AbstractJsonFactoryTest.fail((String)"Expected IllegalArgumentException on class with illegal @JsonPolymorphicTypeMap type");
    }

    public void testParser_polymorphicClass_duplicateTypeKeys() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser("{}");
        try {
            parser.parse(PolymorphicWithDuplicateTypeKeys.class);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AbstractJsonFactoryTest.fail((String)"Expected IllegalArgumentException on class with duplicate typeDef keys");
    }

    public void testParser_polymorphicClass_noMatchingTypeKey() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(POLYMORPHIC_WITH_UNKNOWN_KEY);
        try {
            parser.parse(Animal.class);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        AbstractJsonFactoryTest.fail((String)"Expected IllegalArgumentException when provided with unknown typeDef key");
    }

    public void testParser_polymorphicClass_selfReferencing() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(POLYMORPHIC_SELF_REFERENCING);
        PolymorphicSelfReferencing p = (PolymorphicSelfReferencing)parser.parse(PolymorphicSelfReferencing.class);
        AbstractJsonFactoryTest.assertEquals(PolymorphicSelfReferencing.class, p.getClass());
        AbstractJsonFactoryTest.assertEquals((String)POLYMORPHIC_SELF_REFERENCING, (String)factory.toString((Object)p));
        AbstractJsonFactoryTest.assertEquals((String)"self", (String)p.type);
        AbstractJsonFactoryTest.assertEquals((String)"blah", (String)p.info);
    }

    public void testParser_polymorphicClass_mapOfPolymorphicClasses() throws Exception {
        JsonFactory factory = this.newFactory();
        JsonParser parser = factory.createJsonParser(HUMAN_WITH_PETS);
        Animal human = (Animal)parser.parse(Animal.class);
        AbstractJsonFactoryTest.assertEquals(HumanWithPets.class, human.getClass());
        AbstractJsonFactoryTest.assertEquals((String)HUMAN_WITH_PETS_PARSED, (String)factory.toString((Object)human));
        AbstractJsonFactoryTest.assertEquals((int)2, (int)human.numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((String)"human with pets", (String)human.type);
        HumanWithPets humanWithPets = (HumanWithPets)human;
        AbstractJsonFactoryTest.assertEquals((String)"Fido", (String)humanWithPets.bestFriend.name);
        AbstractJsonFactoryTest.assertEquals((int)3, (int)humanWithPets.bestFriend.tricksKnown);
        AbstractJsonFactoryTest.assertEquals((String)"Mr. Icky", (String)humanWithPets.pets.get((Object)"first").name);
        AbstractJsonFactoryTest.assertEquals((String)"bug", (String)humanWithPets.pets.get((Object)"first").type);
        AbstractJsonFactoryTest.assertEquals((int)68, (int)humanWithPets.pets.get((Object)"first").numberOfLegs);
        AbstractJsonFactoryTest.assertEquals((String)"green", (String)((Centipede)humanWithPets.pets.get((Object)"first")).color);
        AbstractJsonFactoryTest.assertEquals((String)"dog", (String)humanWithPets.pets.get((Object)"second").type);
        AbstractJsonFactoryTest.assertEquals((int)0, (int)((Dog)humanWithPets.pets.get((Object)"second")).tricksKnown);
        AbstractJsonFactoryTest.assertEquals((int)2, (int)humanWithPets.pets.size());
    }

    public static class HumanWithPets
    extends Human {
        @Key
        Map<String, Animal> pets;
    }

    public static class PolymorphicSelfReferencing {
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="self", ref=PolymorphicSelfReferencing.class)})
        String type;
        @Key
        String info;
    }

    public static class PolymorphicWithDuplicateTypeKeys {
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="foo", ref=Object.class), @JsonPolymorphicTypeMap.TypeDef(key="foo", ref=Object.class)})
        String type;
    }

    public static class PolymorphicWithIllegalValueType {
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="foo", ref=Object.class), @JsonPolymorphicTypeMap.TypeDef(key="bar", ref=Object.class)})
        Object type;
    }

    public static class NumericValueTypedSubclass2
    extends PolymorphicWithNumericValueType {
    }

    public static class NumericValueTypedSubclass1
    extends PolymorphicWithNumericValueType {
    }

    public static class PolymorphicWithNumericValueType {
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="1", ref=NumericValueTypedSubclass1.class), @JsonPolymorphicTypeMap.TypeDef(key="2", ref=NumericValueTypedSubclass2.class)})
        int type;
    }

    public static class NumericTypedSubclass2
    extends PolymorphicWithNumericType {
    }

    public static class NumericTypedSubclass1
    extends PolymorphicWithNumericType {
    }

    public static class PolymorphicWithNumericType {
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="1", ref=NumericTypedSubclass1.class), @JsonPolymorphicTypeMap.TypeDef(key="2", ref=NumericTypedSubclass2.class)})
        Integer type;
    }

    public static class PolymorphicWithMultipleAnnotations {
        @Key
        String a;
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="dog", ref=Dog.class)})
        String b;
        @Key
        String c;
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="bug", ref=Centipede.class)})
        String d;
    }

    public static class DogWithFamily
    extends Dog {
        @Key
        public String[] nicknames;
        @Key
        public Animal[] children;
    }

    public static class DogGenericJson
    extends AnimalGenericJson {
        @Key
        public int tricksKnown;
    }

    public static class AnimalGenericJson
    extends GenericJson {
        @Key
        public String name;
        @Key(value="legCount")
        public int numberOfLegs;
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="dog", ref=DogGenericJson.class)})
        public String type;
    }

    public static class Human
    extends Animal {
        @Key
        public Dog bestFriend;
    }

    public static class Centipede
    extends Animal {
        @Key(value="bodyColor")
        public String color;
    }

    public static class Dog
    extends Animal {
        @Key
        public int tricksKnown;
    }

    public static abstract class Animal {
        @Key
        public String name;
        @Key(value="legCount")
        public int numberOfLegs;
        @Key
        @JsonPolymorphicTypeMap(typeDefinitions={@JsonPolymorphicTypeMap.TypeDef(key="dog", ref=Dog.class), @JsonPolymorphicTypeMap.TypeDef(key="bug", ref=Centipede.class), @JsonPolymorphicTypeMap.TypeDef(key="human", ref=Human.class), @JsonPolymorphicTypeMap.TypeDef(key="dogwithfamily", ref=DogWithFamily.class), @JsonPolymorphicTypeMap.TypeDef(key="human with pets", ref=HumanWithPets.class)})
        public String type;
    }

    public static class BooleanTypes {
        @Key
        Boolean boolObj;
        @Key
        boolean bool;
    }

    public static class V {
        @Key
        Void v;
        @Key
        String s;
    }

    public static class Simple {
        @Key
        String a;
    }

    public static class ExtendsGenericJson
    extends GenericJson {
        @Key
        @JsonString
        Long numAsString;

        public ExtendsGenericJson set(String fieldName, Object value) {
            return (ExtendsGenericJson)super.set(fieldName, value);
        }
    }

    public static class TestClass {
        @Key(value="foo")
        public int foo;
    }

    public static class TypeVariablesPassedAround
    extends X<LinkedList<String>> {
    }

    public static class Z<ZT> {
        @Key
        ZT f;
    }

    public static class Y<YT> {
        @Key
        Z<YT> z;
    }

    public static class X<XT> {
        @Key
        Y<XT> y;
    }

    public static class EnumValue {
        @Key
        public E value;
        @Key
        public E otherValue;
        @Key
        public E nullValue;
    }

    public static enum E {
        VALUE,
        OTHER_VALUE,
        NULL,
        IGNORED_VALUE;

    }

    public static class StringNullValue {
        @Key
        public String[][] arr2;
        @Key
        public String[] arr;
        @Key
        public String value;
    }

    public static class FloatMapTypeVariableType
    extends TypeVariableType<Map<String, Float>> {
    }

    public static class DoubleListTypeVariableType
    extends TypeVariableType<List<Double>> {
    }

    public static class IntArrayTypeVariableType
    extends TypeVariableType<int[]> {
    }

    public static class IntegerTypeVariableType
    extends TypeVariableType<Integer> {
    }

    public static class TypeVariableType<T> {
        @Key
        public T[][] arr;
        @Key
        public LinkedList<LinkedList<T>> list;
        @Key
        public T nullValue;
        @Key
        public T value;
    }

    public static class WildCardTypes {
        @Key
        public Collection<? super Integer>[] lower;
        @Key
        public Map<String, ?> map;
        @Key
        public Collection<? super TreeMap<String, ? extends Integer>> mapInWild;
        @Key
        public Map<String, ? extends Integer> mapUpper;
        @Key
        public Collection<?>[] simple;
        @Key
        public Collection<? extends Integer>[] upper;
    }

    public static class MapOfMapType {
        @Key
        public Map<String, Map<String, Integer>>[] value;
    }

    public static class CollectionOfCollectionType {
        @Key
        public LinkedList<LinkedList<String>> arr;
    }

    public static class ArrayType {
        @Key
        int[] arr;
        @Key
        int[][] arr2;
        @Key
        public Integer[] integerArr;
    }

    public static class AnyType {
        @Key
        public Object arr;
        @Key
        public Object bool;
        @Key
        public Object num;
        @Key
        public Object obj;
        @Key
        public Object str;
        @Key
        public Object nul;
    }

    public static class NumberTypesAsString {
        @Key
        @JsonString
        byte byteValue;
        @Key
        @JsonString
        Byte byteObjValue;
        @Key
        @JsonString
        short shortValue;
        @Key
        @JsonString
        Short shortObjValue;
        @Key
        @JsonString
        int intValue;
        @Key
        @JsonString
        Integer intObjValue;
        @Key
        @JsonString
        float floatValue;
        @Key
        @JsonString
        Float floatObjValue;
        @Key
        @JsonString
        long longValue;
        @Key
        @JsonString
        Long longObjValue;
        @Key
        @JsonString
        double doubleValue;
        @Key
        @JsonString
        Double doubleObjValue;
        @Key
        @JsonString
        BigInteger bigIntegerValue;
        @Key
        @JsonString
        BigDecimal bigDecimalValue;
        @Key(value="yetAnotherBigDecimalValue")
        @JsonString
        BigDecimal anotherBigDecimalValue;
        @Key
        @JsonString
        List<Long> longListValue;
        @Key
        @JsonString
        Map<String, Long> longMapValue;
    }

    public static class NumberTypes {
        @Key
        byte byteValue;
        @Key
        Byte byteObjValue;
        @Key
        short shortValue;
        @Key
        Short shortObjValue;
        @Key
        int intValue;
        @Key
        Integer intObjValue;
        @Key
        float floatValue;
        @Key
        Float floatObjValue;
        @Key
        long longValue;
        @Key
        Long longObjValue;
        @Key
        double doubleValue;
        @Key
        Double doubleObjValue;
        @Key
        BigInteger bigIntegerValue;
        @Key
        BigDecimal bigDecimalValue;
        @Key(value="yetAnotherBigDecimalValue")
        BigDecimal anotherBigDecimalValue;
        @Key
        List<Long> longListValue;
        @Key
        Map<String, Long> longMapValue;
    }

    public static class A {
        @Key
        public Map<String, String> map;
    }

    public static class Feed {
        @Key
        public Collection<Entry> entries;
    }

    public static class Entry {
        @Key
        public String title;
    }
}

