/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.test.util.store;

import com.google.api.client.util.Beta;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractDataStoreFactoryTest
extends TestCase {
    private static final String STRING_ID = "String";
    private static final String BOOLEAN_ID = "Boolean";
    DataStoreFactory dataStore;
    DataStore<String> stringTyped;
    DataStore<Boolean> boolTyped;

    protected abstract DataStoreFactory newDataStoreFactory() throws Exception;

    public void setUp() throws Exception {
        this.dataStore = this.newDataStoreFactory();
        this.stringTyped = this.dataStore.getDataStore(STRING_ID);
        this.boolTyped = this.dataStore.getDataStore(BOOLEAN_ID);
    }

    public void tearDown() throws Exception {
        this.stringTyped.clear();
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.values().isEmpty());
        this.boolTyped.clear();
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.boolTyped.values().isEmpty());
    }

    private static void assertContentsAnyOrder(Collection<?> c, Object ... elts) {
        AbstractDataStoreFactoryTest.assertEquals((Object)Sets.newHashSet(c), (Object)Sets.newHashSet(Arrays.asList(elts)));
    }

    public void testId() throws Exception {
        this.subtestIdNoException("1");
        this.subtestIdNoException("123456789012345678901234567890");
        this.subtestIdNoException("abcdefghijklmnopqrstuvwxyz");
        this.subtestIdNoException("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.subtestIdException("");
        this.subtestIdException(".");
        this.subtestIdException(" ");
        this.subtestIdException("1234567890123456789012345678901");
    }

    private void subtestIdException(String id) throws Exception {
        try {
            this.subtestIdNoException(id);
            String string = String.valueOf(String.valueOf(IllegalArgumentException.class));
            AbstractDataStoreFactoryTest.fail((String)new StringBuilder(9 + string.length()).append("expected ").append(string).toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void subtestIdNoException(String id) throws Exception {
        this.newDataStoreFactory().getDataStore(id);
    }

    public void testSet() throws Exception {
        String string;
        AbstractDataStoreFactoryTest.assertNull((Object)this.stringTyped.get(null));
        AbstractDataStoreFactoryTest.assertNull((Object)this.stringTyped.get("k"));
        this.stringTyped.set("k", (Serializable)((Object)"v"));
        AbstractDataStoreFactoryTest.assertEquals((String)"v", (String)((String)((Object)this.stringTyped.get("k"))));
        this.stringTyped = this.dataStore.getDataStore(STRING_ID);
        AbstractDataStoreFactoryTest.assertEquals((String)"v", (String)((String)((Object)this.stringTyped.get("k"))));
        this.stringTyped = this.dataStore.getDataStore(STRING_ID);
        AbstractDataStoreFactoryTest.assertEquals((String)"v", (String)((String)((Object)this.stringTyped.get("k"))));
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        AbstractDataStoreFactoryTest.assertEquals((String)"new", (String)((String)((Object)this.stringTyped.get("k"))));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        AbstractDataStoreFactoryTest.assertEquals((String)"new", (String)((String)((Object)this.stringTyped.get("k"))));
        AbstractDataStoreFactoryTest.assertEquals((String)"other", (String)((String)((Object)this.stringTyped.get("k2"))));
        try {
            this.stringTyped.set("k", null);
            string = String.valueOf(String.valueOf(NullPointerException.class));
            AbstractDataStoreFactoryTest.fail((String)new StringBuilder(9 + string.length()).append("expected ").append(string).toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.stringTyped.set(null, (Serializable)((Object)"v"));
            string = String.valueOf(String.valueOf(NullPointerException.class));
            AbstractDataStoreFactoryTest.fail((String)new StringBuilder(9 + string.length()).append("expected ").append(string).toString());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.stringTyped.set("k", (Serializable)((Object)"v"));
        AbstractDataStoreFactoryTest.assertNull((Object)this.boolTyped.get("k"));
        this.boolTyped.set("k", (Serializable)Boolean.valueOf(true));
        AbstractDataStoreFactoryTest.assertEquals((String)"v", (String)((String)((Object)this.stringTyped.get("k"))));
        AbstractDataStoreFactoryTest.assertTrue((boolean)((Boolean)this.boolTyped.get("k")));
    }

    public void testValues() throws Exception {
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.values().isEmpty());
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.stringTyped.values(), "new", "other");
        this.stringTyped.delete("k");
        AbstractDataStoreFactoryTest.assertNull((Object)this.stringTyped.get("k"));
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.stringTyped.values(), "other");
        this.stringTyped.delete("k2");
        this.stringTyped.set("k", (Serializable)((Object)"v"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.boolTyped.values().isEmpty());
        this.boolTyped.set("k", (Serializable)Boolean.valueOf(true));
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.stringTyped.values(), "v");
        AbstractDataStoreFactoryTest.assertContentsAnyOrder(this.boolTyped.values(), true);
    }

    public void testKeySet() throws Exception {
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.keySet().isEmpty());
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        TreeSet expected = Sets.newTreeSet();
        expected.add("k");
        AbstractDataStoreFactoryTest.assertEquals((Object)expected, (Object)Sets.newTreeSet((Iterable)this.stringTyped.keySet()));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        expected.add("k2");
        AbstractDataStoreFactoryTest.assertEquals((Object)expected, (Object)Sets.newTreeSet((Iterable)this.stringTyped.keySet()));
        this.stringTyped.delete("k2");
        expected.remove("k2");
        AbstractDataStoreFactoryTest.assertEquals((Object)expected, (Object)Sets.newTreeSet((Iterable)this.stringTyped.keySet()));
        this.stringTyped.delete("k");
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.keySet().isEmpty());
    }

    public void testDelete() throws Exception {
        this.stringTyped.set("k", (Serializable)((Object)"v")).set("k2", (Serializable)((Object)"v2"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.isEmpty());
        AbstractDataStoreFactoryTest.assertEquals((int)2, (int)this.stringTyped.size());
        this.stringTyped.delete("k2");
        AbstractDataStoreFactoryTest.assertNull((Object)this.stringTyped.get("k2"));
        this.stringTyped.delete("k2");
        AbstractDataStoreFactoryTest.assertNull((Object)this.stringTyped.get("k2"));
        AbstractDataStoreFactoryTest.assertEquals((String)"v", (String)((String)((Object)this.stringTyped.get("k"))));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.isEmpty());
        AbstractDataStoreFactoryTest.assertEquals((int)1, (int)this.stringTyped.size());
        this.stringTyped.delete("k");
        AbstractDataStoreFactoryTest.assertNull((Object)this.stringTyped.get("k"));
        this.stringTyped.delete(null);
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.isEmpty());
        AbstractDataStoreFactoryTest.assertEquals((int)0, (int)this.stringTyped.size());
    }

    public void testClear() throws Exception {
        this.stringTyped.set("k", (Serializable)((Object)"v")).set("k2", (Serializable)((Object)"v2"));
        this.stringTyped.clear();
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.isEmpty());
        AbstractDataStoreFactoryTest.assertEquals((int)0, (int)this.stringTyped.size());
        this.stringTyped.clear();
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.isEmpty());
        AbstractDataStoreFactoryTest.assertEquals((int)0, (int)this.stringTyped.size());
    }

    public void testLarge() throws Exception {
        int mid;
        int n;
        int size = 100;
        for (int i = 0; i < size; ++i) {
            n = i;
            this.stringTyped.set(String.valueOf(i), (Serializable)((Object)new StringBuilder(16).append("hello").append(n).toString()));
        }
        AbstractDataStoreFactoryTest.assertEquals((int)size, (int)this.stringTyped.size());
        n = mid = size / 2;
        AbstractDataStoreFactoryTest.assertEquals((String)new StringBuilder(16).append("hello").append(n).toString(), (String)((String)((Object)this.stringTyped.get(String.valueOf(mid)))));
    }

    public void testContainsKeyAndValue() throws Exception {
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsKey("k"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsKey("k2"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.set("k", (Serializable)((Object)"new"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsKey("k"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsKey("k2"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.set("k2", (Serializable)((Object)"other"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsKey("k"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsKey("k2"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.delete("k");
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsKey("k"));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsKey("k2"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        AbstractDataStoreFactoryTest.assertTrue((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
        this.stringTyped.clear();
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsKey("k"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsKey("k2"));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"new")));
        AbstractDataStoreFactoryTest.assertFalse((boolean)this.stringTyped.containsValue((Serializable)((Object)"other")));
    }
}

