/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.protobuf;

import com.google.api.client.util.Beta;
import com.google.api.client.util.Throwables;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class ProtocolBuffers {
    public static final String CONTENT_TYPE = "application/x-protobuf";
    public static final String ALT_CONTENT_TYPE = "application/x-protobuffer";

    public static <T extends MessageLite> T parseAndClose(InputStream inputStream, Class<T> messageClass) throws IOException {
        try {
            Method newBuilder = messageClass.getDeclaredMethod("parseFrom", InputStream.class);
            MessageLite messageLite = (MessageLite)messageClass.cast(newBuilder.invoke(null, inputStream));
            return (T)messageLite;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, IOException.class);
            String string = String.valueOf(String.valueOf(messageClass));
            IOException io = new IOException(new StringBuilder(30 + string.length()).append("Error parsing message of type ").append(string).toString());
            io.initCause(e);
            throw io;
        }
        finally {
            inputStream.close();
        }
    }

    private ProtocolBuffers() {
    }
}

