/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v5;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.apache.v5.Apache5ContentEntity;
import com.google.api.client.http.apache.v5.Apache5HttpResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.util.Timeout;

public final class Apache5HttpRequest
extends LowLevelHttpRequest {
    private final HttpUriRequestBase request;
    private final RequestConfig.Builder requestConfig;
    private final HttpClient httpClient;

    Apache5HttpRequest(HttpClient httpClient, HttpUriRequestBase request) {
        this.httpClient = httpClient;
        this.request = request;
        this.requestConfig = RequestConfig.custom().setRedirectsEnabled(false);
    }

    public void addHeader(String name, String value) {
        this.request.addHeader(name, (Object)value);
    }

    public void setTimeout(int connectTimeout, int readTimeout) throws IOException {
        this.requestConfig.setConnectTimeout(Timeout.of((long)connectTimeout, (TimeUnit)TimeUnit.MILLISECONDS)).setConnectionRequestTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).setResponseTimeout(Timeout.of((long)readTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    public LowLevelHttpResponse execute() throws IOException {
        HttpHost target;
        if (this.getStreamingContent() != null) {
            Apache5ContentEntity entity = new Apache5ContentEntity(this.getContentLength(), this.getStreamingContent(), this.getContentType(), this.getContentEncoding());
            this.request.setEntity((HttpEntity)entity);
        }
        this.request.setConfig(this.requestConfig.build());
        try {
            target = RoutingSupport.determineHost((HttpRequest)this.request);
        }
        catch (HttpException e) {
            throw new ClientProtocolException("The request's host is invalid.", (Throwable)e);
        }
        ClassicHttpResponse httpResponse = this.httpClient.executeOpen(target, (ClassicHttpRequest)this.request, null);
        return new Apache5HttpResponse(this.request, httpResponse);
    }
}

