/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "kab" locale.
 */
public class LocalizedNamesImpl_kab extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "IO",
        "AQ",
        "AR",
        "AM",
        "AW",
        "VA",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BM",
        "BT",
        "BY",
        "BZ",
        "BJ",
        "BR",
        "BN",
        "BG",
        "BO",
        "BI",
        "BF",
        "BA",
        "BW",
        "TD",
        "KH",
        "CZ",
        "CL",
        "CY",
        "DK",
        "DG",
        "DM",
        "PS",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GA",
        "GM",
        "DJ",
        "GG",
        "GD",
        "GL",
        "GY",
        "GP",
        "GU",
        "GT",
        "HT",
        "BQ",
        "HN",
        "HU",
        "EC",
        "ID",
        "IR",
        "ER",
        "IS",
        "EE",
        "IL",
        "JM",
        "JP",
        "GI",
        "JE",
        "GE",
        "NC",
        "CM",
        "CA",
        "KZ",
        "HR",
        "KE",
        "KI",
        "KG",
        "CU",
        "CO",
        "KM",
        "CG",
        "CW",
        "KP",
        "KR",
        "CR",
        "XK",
        "CI",
        "KW",
        "CN",
        "GR",
        "JO",
        "AL",
        "DE",
        "LV",
        "LA",
        "LI",
        "DZ",
        "IN",
        "LR",
        "LY",
        "IE",
        "LT",
        "LS",
        "MA",
        "LB",
        "LU",
        "YE",
        "IQ",
        "MG",
        "MW",
        "MV",
        "ML",
        "MY",
        "MT",
        "MQ",
        "MK",
        "EG",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MU",
        "MR",
        "MZ",
        "MM",
        "NA",
        "NE",
        "NG",
        "NI",
        "NP",
        "NU",
        "NR",
        "NO",
        "PK",
        "PW",
        "PA",
        "PY",
        "PE",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "QA",
        "RU",
        "RO",
        "RW",
        "SV",
        "WS",
        "AS",
        "KN",
        "LC",
        "SM",
        "MF",
        "SX",
        "PM",
        "BL",
        "SH",
        "VC",
        "ST",
        "EA",
        "EH",
        "SC",
        "SG",
        "SN",
        "SL",
        "RS",
        "SK",
        "SI",
        "ES",
        "LK",
        "SD",
        "SS",
        "SO",
        "SR",
        "SY",
        "SA",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "ZA",
        "GB",
        "TJ",
        "EZ",
        "HK",
        "MO",
        "TZ",
        "TH",
        "TW",
        "IT",
        "EU",
        "CF",
        "DO",
        "CD",
        "AE",
        "HM",
        "UM",
        "AX",
        "BV",
        "FK",
        "FO",
        "GS",
        "KY",
        "CK",
        "CC",
        "MH",
        "MP",
        "SB",
        "CV",
        "IC",
        "NF",
        "VG",
        "AC",
        "CP",
        "IM",
        "CX",
        "RE",
        "QO",
        "UN",
        "TF",
        "NL",
        "TT",
        "TA",
        "TG",
        "TK",
        "TL",
        "TN",
        "TO",
        "TR",
        "TC",
        "TM",
        "TV",
        "UA",
        "AD",
        "AI",
        "AO",
        "AG",
        "UY",
        "AU",
        "AT",
        "ET",
        "UZ",
        "UG",
        "VU",
        "VE",
        "VN",
        "VI",
        "WF",
        "US",
        "XA",
        "XB",
        "ZM",
        "NZ",
        "ZW",
        "OM",
        "GH",
        "GF",
        "GN",
        "GW",
        "PG",
        "GQ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Amaḍal");
    namesMap.put("002", "Tafriqt");
    namesMap.put("003", "Tamrikt n ugafa");
    namesMap.put("005", "Tamrikt n unẓul");
    namesMap.put("009", "Usyanya");
    namesMap.put("011", "Tafriqt n umalu");
    namesMap.put("013", "Tamrikt Talemmast");
    namesMap.put("014", "Tafriqt n usammar");
    namesMap.put("015", "Tafriqt n ugafa");
    namesMap.put("017", "Tafriqt talemmast");
    namesMap.put("018", "Tafriqt n unẓul");
    namesMap.put("019", "Timrikin");
    namesMap.put("021", "Tamrikt Tagafayent");
    namesMap.put("029", "Kaṛayib");
    namesMap.put("030", "Asya n usammar");
    namesMap.put("034", "Asya n unẓul");
    namesMap.put("035", "Asya n unẓul asammar");
    namesMap.put("039", "Turuft n unẓul");
    namesMap.put("053", "Ustṛasya");
    namesMap.put("054", "Milanizya");
    namesMap.put("057", "Tamnaḍt n Mikṛunizya");
    namesMap.put("061", "Pulinizya");
    namesMap.put("142", "Asya");
    namesMap.put("143", "Asya talemmast");
    namesMap.put("145", "Asya n umalu");
    namesMap.put("150", "Turuft");
    namesMap.put("151", "Turuft n usammar");
    namesMap.put("154", "Turuft n ugafa");
    namesMap.put("155", "Turuft n umalu");
    namesMap.put("419", "Tamrikt talaṭinit");
    namesMap.put("AC", "Tigzirt n Aṣunsyun");
    namesMap.put("AD", "Undura");
    namesMap.put("AE", "Tigeldunin Yedduklen Taɛrabin");
    namesMap.put("AF", "Afɣanistan");
    namesMap.put("AG", "Untiga d Barbuda");
    namesMap.put("AI", "Ungiya");
    namesMap.put("AL", "Lalbani");
    namesMap.put("AM", "Arminya");
    namesMap.put("AO", "Ungula");
    namesMap.put("AQ", "Antaṛktik");
    namesMap.put("AR", "Arjuntin");
    namesMap.put("AS", "Samwa Tamarikanit");
    namesMap.put("AT", "Ustriya");
    namesMap.put("AU", "Ustrali");
    namesMap.put("AX", "Tigzirin n Aland");
    namesMap.put("AZ", "Azrabijan");
    namesMap.put("BA", "Busna d Hersek");
    namesMap.put("BB", "Barbadus");
    namesMap.put("BD", "Bangladac");
    namesMap.put("BE", "Belǧik");
    namesMap.put("BF", "Burkina Fasu");
    namesMap.put("BG", "Bulgari");
    namesMap.put("BH", "Baḥrin");
    namesMap.put("BI", "Burandi");
    namesMap.put("BJ", "Binin");
    namesMap.put("BL", "Sant Baṛtilimi");
    namesMap.put("BN", "Bruney");
    namesMap.put("BO", "Bulivi");
    namesMap.put("BQ", "Huland n Kaṛayib");
    namesMap.put("BR", "Brizil");
    namesMap.put("BV", "Tigzirin n Buvet");
    namesMap.put("BW", "Bustwana");
    namesMap.put("BY", "Bilarus");
    namesMap.put("BZ", "Biliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Tigzirin n Kukus");
    namesMap.put("CD", "Tigduda Tagdudant n Kungu");
    namesMap.put("CF", "Tigduda n Tefriqt Talemmast");
    namesMap.put("CG", "Kungu");
    namesMap.put("CH", "Swis");
    namesMap.put("CI", "Kuṭ Divwar");
    namesMap.put("CK", "Tigzirin n Kuk");
    namesMap.put("CL", "Cili");
    namesMap.put("CM", "Kamirun");
    namesMap.put("CN", "Lacin");
    namesMap.put("CO", "Kulumbi");
    namesMap.put("CP", "Tigzirt n Klipirṭun");
    namesMap.put("CR", "Kusta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Tigzirin n yixef azegzaw");
    namesMap.put("CW", "Kuṛaṣaw");
    namesMap.put("CX", "Tigzrin n Kristmaṣ");
    namesMap.put("CY", "Cipr");
    namesMap.put("CZ", "Čček");
    namesMap.put("DE", "Lalman");
    namesMap.put("DG", "Digu Gaṛsya");
    namesMap.put("DJ", "Ǧibuti");
    namesMap.put("DM", "Duminik");
    namesMap.put("DO", "Tigduda Taduminikit");
    namesMap.put("DZ", "Lezzayer");
    namesMap.put("EA", "Sebta d Melilla");
    namesMap.put("EC", "Ikwaṭur");
    namesMap.put("EE", "Istunya");
    namesMap.put("EG", "Maṣr");
    namesMap.put("EH", "Seḥra n umalu");
    namesMap.put("ER", "Iritiria");
    namesMap.put("ES", "Spanya");
    namesMap.put("ET", "Utyupi");
    namesMap.put("EU", "Tiddukla n Turuft");
    namesMap.put("EZ", "Tamnaḍt n Turuft");
    namesMap.put("FI", "Finlund");
    namesMap.put("FK", "Tigzirin n Falkland");
    namesMap.put("FM", "Mikrunizya");
    namesMap.put("FO", "Tigzirin n Faṛwi");
    namesMap.put("FR", "Fransa");
    namesMap.put("GA", "Gabun");
    namesMap.put("GB", "Tagelda Yedduklen");
    namesMap.put("GD", "Grunad");
    namesMap.put("GE", "Jiyurji");
    namesMap.put("GF", "Ɣana tafransist");
    namesMap.put("GG", "Girnizi");
    namesMap.put("GH", "Ɣana");
    namesMap.put("GI", "Jibraltar");
    namesMap.put("GL", "Grunland");
    namesMap.put("GM", "Gambya");
    namesMap.put("GN", "Ɣinya");
    namesMap.put("GP", "Gwadalupi");
    namesMap.put("GQ", "Ɣinya Tasebgast");
    namesMap.put("GR", "Lagris");
    namesMap.put("GS", "Tigzirin n Jyuṛjya n Unzul akked Sandwič n Unẓul");
    namesMap.put("GT", "Gwatimala");
    namesMap.put("GU", "Gwam");
    namesMap.put("GW", "Ɣinya-Bisaw");
    namesMap.put("GY", "Guwana");
    namesMap.put("HK", "Tamnaṭ Taqbuṛt Tacinwat n Hung Kung");
    namesMap.put("HM", "Tigzirin Heard akked McDonald");
    namesMap.put("HN", "Hunduras");
    namesMap.put("HR", "Kerwasya");
    namesMap.put("HT", "Hayti");
    namesMap.put("HU", "Hungri");
    namesMap.put("IC", "Tigzirin Tikanaṛiyin");
    namesMap.put("ID", "Indunizi");
    namesMap.put("IE", "Lirlund");
    namesMap.put("IL", "Izrayil");
    namesMap.put("IM", "Tigzirt n Man");
    namesMap.put("IN", "Lhend");
    namesMap.put("IO", "Akal Aglizi deg Ugaraw Ahendi");
    namesMap.put("IQ", "Lɛiraq");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Ṭelyan");
    namesMap.put("JE", "Jiṛzi");
    namesMap.put("JM", "Jamyika");
    namesMap.put("JO", "Lajurdani");
    namesMap.put("JP", "Jappu");
    namesMap.put("KE", "Kinya");
    namesMap.put("KG", "Kirigistan");
    namesMap.put("KH", "Cambudya");
    namesMap.put("KM", "Kumur");
    namesMap.put("KN", "San Kits d Nivis");
    namesMap.put("KP", "Kurya, Ufella");
    namesMap.put("KR", "Kurya, Wadda");
    namesMap.put("KW", "Kuwayt");
    namesMap.put("KY", "Tigzirin n Kamyan");
    namesMap.put("KZ", "Kazaxistan");
    namesMap.put("LA", "Laws");
    namesMap.put("LB", "Lubnan");
    namesMap.put("LC", "San Lučya");
    namesMap.put("LI", "Layctenstan");
    namesMap.put("LR", "Libirya");
    namesMap.put("LS", "Lizuṭu");
    namesMap.put("LT", "Liṭwanya");
    namesMap.put("LU", "Luksamburg");
    namesMap.put("MA", "Lmerruk");
    namesMap.put("MC", "Munaku");
    namesMap.put("MD", "Muldabi");
    namesMap.put("ME", "Muntinigru");
    namesMap.put("MF", "San Maṛtan");
    namesMap.put("MG", "Madaɣecqer");
    namesMap.put("MH", "Tigzirin n Marcal");
    namesMap.put("MK", "Masidwan");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mungulya");
    namesMap.put("MO", "Tamnaṭ Tudbilt Tuzzigt tacenwit n Makaw");
    namesMap.put("MP", "Tigzirin n Maryan Ufella");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Muriṭanya");
    namesMap.put("MS", "Munsirat");
    namesMap.put("MT", "Malṭ");
    namesMap.put("MU", "Muris");
    namesMap.put("MV", "Maldib");
    namesMap.put("MX", "Meksik");
    namesMap.put("MY", "Malizya");
    namesMap.put("MZ", "Muzembiq");
    namesMap.put("NA", "Namibya");
    namesMap.put("NC", "Kalidunya Tamaynut");
    namesMap.put("NE", "Nijer");
    namesMap.put("NF", "Tigzirin Tinawfukin");
    namesMap.put("NG", "Nijirya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Timura-Yessakesren");
    namesMap.put("NO", "Nurvij");
    namesMap.put("NP", "Nipal");
    namesMap.put("NR", "Nuru");
    namesMap.put("NU", "Niwi");
    namesMap.put("NZ", "Ziland Tamaynut");
    namesMap.put("OM", "Ɛuman");
    namesMap.put("PA", "Panam");
    namesMap.put("PE", "Piru");
    namesMap.put("PF", "Pulunizi tafransist");
    namesMap.put("PG", "Ɣinya Tamaynut Tapaput");
    namesMap.put("PH", "Filipin");
    namesMap.put("PL", "Pulund");
    namesMap.put("PM", "San Pyar d Miklun");
    namesMap.put("PN", "Pitkarin");
    namesMap.put("PR", "Purtu Riku");
    namesMap.put("PS", "Falisṭin d Ɣezza");
    namesMap.put("PT", "Purtugal");
    namesMap.put("PW", "Palu");
    namesMap.put("PY", "Paragway");
    namesMap.put("QA", "Qaṭar");
    namesMap.put("QO", "Timnaḍin ibeɛden n Tusyanit");
    namesMap.put("RE", "Timlilit");
    namesMap.put("RO", "Rumani");
    namesMap.put("RS", "Ṣirbya");
    namesMap.put("RU", "Rrus");
    namesMap.put("RW", "Ruwanda");
    namesMap.put("SA", "Suɛudiya Taɛrabt");
    namesMap.put("SB", "Tigzirin n Sulumun");
    namesMap.put("SC", "Seycel");
    namesMap.put("SE", "Swid");
    namesMap.put("SG", "Singafur");
    namesMap.put("SH", "Sant Ilina");
    namesMap.put("SI", "Sluvinya");
    namesMap.put("SJ", "Svalvard d Jan Mayen");
    namesMap.put("SK", "Sluvakya");
    namesMap.put("SL", "Sira Lyun");
    namesMap.put("SM", "San Marinu");
    namesMap.put("SN", "Sinigal");
    namesMap.put("SO", "Ṣumal");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Sudan n unẓul");
    namesMap.put("ST", "Saw Tumi d Pransip");
    namesMap.put("SV", "Salvadur");
    namesMap.put("SX", "San Maṛtan(Tamnaḍt tahulandit)");
    namesMap.put("SY", "Surya");
    namesMap.put("SZ", "Swazilund");
    namesMap.put("TA", "Tristan da Kunha");
    namesMap.put("TC", "Ṭurk d Tegzirin n Kaykus");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Timura n umalu tifṛansisiyin");
    namesMap.put("TG", "Ṭugu");
    namesMap.put("TH", "Ṭayland");
    namesMap.put("TK", "Ṭuklu");
    namesMap.put("TL", "Tumur Asamar");
    namesMap.put("TM", "Ṭurkmanistan");
    namesMap.put("TN", "Tunes");
    namesMap.put("TO", "Ṭunga");
    namesMap.put("TR", "Ṭurk");
    namesMap.put("TT", "Ṭrindad d Ṭubagu");
    namesMap.put("TV", "Ṭuvalu");
    namesMap.put("TW", "Ṭaywan");
    namesMap.put("TZ", "Ṭanzanya");
    namesMap.put("UA", "Ukran");
    namesMap.put("UG", "Uɣanda");
    namesMap.put("UM", "Tigzirin ibeɛden n Marikan");
    namesMap.put("UN", "Timura Idduklen");
    namesMap.put("US", "WDM");
    namesMap.put("UY", "Urugway");
    namesMap.put("UZ", "Uzbaxistan");
    namesMap.put("VA", "Awanek n Vatikan");
    namesMap.put("VC", "San Vansu d Grunadin");
    namesMap.put("VE", "Venzwila");
    namesMap.put("VG", "Tigzirin Tiverjiniyin Tigliziyin");
    namesMap.put("VI", "W.D. Tigzirin n Virginya");
    namesMap.put("VN", "Vyeṭnam");
    namesMap.put("VU", "Vanwatu");
    namesMap.put("WF", "Wallis d Futuna");
    namesMap.put("WS", "Samwa");
    namesMap.put("XK", "Kuṣuvu");
    namesMap.put("YE", "Lyamen");
    namesMap.put("YT", "Mayuṭ");
    namesMap.put("ZA", "Tafriqt Wadda");
    namesMap.put("ZM", "Zambya");
    namesMap.put("ZW", "Zimbabwi");
    namesMap.put("ZZ", "Timnaḍin Tirussinin");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Amaḍal",
        "002": "Tafriqt",
        "003": "Tamrikt n ugafa",
        "005": "Tamrikt n unẓul",
        "009": "Usyanya",
        "011": "Tafriqt n umalu",
        "013": "Tamrikt Talemmast",
        "014": "Tafriqt n usammar",
        "015": "Tafriqt n ugafa",
        "017": "Tafriqt talemmast",
        "018": "Tafriqt n unẓul",
        "019": "Timrikin",
        "021": "Tamrikt Tagafayent",
        "029": "Kaṛayib",
        "030": "Asya n usammar",
        "034": "Asya n unẓul",
        "035": "Asya n unẓul asammar",
        "039": "Turuft n unẓul",
        "053": "Ustṛasya",
        "054": "Milanizya",
        "057": "Tamnaḍt n Mikṛunizya",
        "061": "Pulinizya",
        "142": "Asya",
        "143": "Asya talemmast",
        "145": "Asya n umalu",
        "150": "Turuft",
        "151": "Turuft n usammar",
        "154": "Turuft n ugafa",
        "155": "Turuft n umalu",
        "419": "Tamrikt talaṭinit",
        "AC": "Tigzirt n Aṣunsyun",
        "AD": "Undura",
        "AE": "Tigeldunin Yedduklen Taɛrabin",
        "AF": "Afɣanistan",
        "AG": "Untiga d Barbuda",
        "AI": "Ungiya",
        "AL": "Lalbani",
        "AM": "Arminya",
        "AO": "Ungula",
        "AQ": "Antaṛktik",
        "AR": "Arjuntin",
        "AS": "Samwa Tamarikanit",
        "AT": "Ustriya",
        "AU": "Ustrali",
        "AX": "Tigzirin n Aland",
        "AZ": "Azrabijan",
        "BA": "Busna d Hersek",
        "BB": "Barbadus",
        "BD": "Bangladac",
        "BE": "Belǧik",
        "BF": "Burkina Fasu",
        "BG": "Bulgari",
        "BH": "Baḥrin",
        "BI": "Burandi",
        "BJ": "Binin",
        "BL": "Sant Baṛtilimi",
        "BN": "Bruney",
        "BO": "Bulivi",
        "BQ": "Huland n Kaṛayib",
        "BR": "Brizil",
        "BV": "Tigzirin n Buvet",
        "BW": "Bustwana",
        "BY": "Bilarus",
        "BZ": "Biliz",
        "CA": "Kanada",
        "CC": "Tigzirin n Kukus",
        "CD": "Tigduda Tagdudant n Kungu",
        "CF": "Tigduda n Tefriqt Talemmast",
        "CG": "Kungu",
        "CH": "Swis",
        "CI": "Kuṭ Divwar",
        "CK": "Tigzirin n Kuk",
        "CL": "Cili",
        "CM": "Kamirun",
        "CN": "Lacin",
        "CO": "Kulumbi",
        "CP": "Tigzirt n Klipirṭun",
        "CR": "Kusta Rika",
        "CU": "Kuba",
        "CV": "Tigzirin n yixef azegzaw",
        "CW": "Kuṛaṣaw",
        "CX": "Tigzrin n Kristmaṣ",
        "CY": "Cipr",
        "CZ": "Čček",
        "DE": "Lalman",
        "DG": "Digu Gaṛsya",
        "DJ": "Ǧibuti",
        "DM": "Duminik",
        "DO": "Tigduda Taduminikit",
        "DZ": "Lezzayer",
        "EA": "Sebta d Melilla",
        "EC": "Ikwaṭur",
        "EE": "Istunya",
        "EG": "Maṣr",
        "EH": "Seḥra n umalu",
        "ER": "Iritiria",
        "ES": "Spanya",
        "ET": "Utyupi",
        "EU": "Tiddukla n Turuft",
        "EZ": "Tamnaḍt n Turuft",
        "FI": "Finlund",
        "FK": "Tigzirin n Falkland",
        "FM": "Mikrunizya",
        "FO": "Tigzirin n Faṛwi",
        "FR": "Fransa",
        "GA": "Gabun",
        "GB": "Tagelda Yedduklen",
        "GD": "Grunad",
        "GE": "Jiyurji",
        "GF": "Ɣana tafransist",
        "GG": "Girnizi",
        "GH": "Ɣana",
        "GI": "Jibraltar",
        "GL": "Grunland",
        "GM": "Gambya",
        "GN": "Ɣinya",
        "GP": "Gwadalupi",
        "GQ": "Ɣinya Tasebgast",
        "GR": "Lagris",
        "GS": "Tigzirin n Jyuṛjya n Unzul akked Sandwič n Unẓul",
        "GT": "Gwatimala",
        "GU": "Gwam",
        "GW": "Ɣinya-Bisaw",
        "GY": "Guwana",
        "HK": "Tamnaṭ Taqbuṛt Tacinwat n Hung Kung",
        "HM": "Tigzirin Heard akked McDonald",
        "HN": "Hunduras",
        "HR": "Kerwasya",
        "HT": "Hayti",
        "HU": "Hungri",
        "IC": "Tigzirin Tikanaṛiyin",
        "ID": "Indunizi",
        "IE": "Lirlund",
        "IL": "Izrayil",
        "IM": "Tigzirt n Man",
        "IN": "Lhend",
        "IO": "Akal Aglizi deg Ugaraw Ahendi",
        "IQ": "Lɛiraq",
        "IS": "Island",
        "IT": "Ṭelyan",
        "JE": "Jiṛzi",
        "JM": "Jamyika",
        "JO": "Lajurdani",
        "JP": "Jappu",
        "KE": "Kinya",
        "KG": "Kirigistan",
        "KH": "Cambudya",
        "KM": "Kumur",
        "KN": "San Kits d Nivis",
        "KP": "Kurya, Ufella",
        "KR": "Kurya, Wadda",
        "KW": "Kuwayt",
        "KY": "Tigzirin n Kamyan",
        "KZ": "Kazaxistan",
        "LA": "Laws",
        "LB": "Lubnan",
        "LC": "San Lučya",
        "LI": "Layctenstan",
        "LR": "Libirya",
        "LS": "Lizuṭu",
        "LT": "Liṭwanya",
        "LU": "Luksamburg",
        "MA": "Lmerruk",
        "MC": "Munaku",
        "MD": "Muldabi",
        "ME": "Muntinigru",
        "MF": "San Maṛtan",
        "MG": "Madaɣecqer",
        "MH": "Tigzirin n Marcal",
        "MK": "Masidwan",
        "MM": "Myanmar",
        "MN": "Mungulya",
        "MO": "Tamnaṭ Tudbilt Tuzzigt tacenwit n Makaw",
        "MP": "Tigzirin n Maryan Ufella",
        "MQ": "Martinik",
        "MR": "Muriṭanya",
        "MS": "Munsirat",
        "MT": "Malṭ",
        "MU": "Muris",
        "MV": "Maldib",
        "MX": "Meksik",
        "MY": "Malizya",
        "MZ": "Muzembiq",
        "NA": "Namibya",
        "NC": "Kalidunya Tamaynut",
        "NE": "Nijer",
        "NF": "Tigzirin Tinawfukin",
        "NG": "Nijirya",
        "NI": "Nikaragwa",
        "NL": "Timura-Yessakesren",
        "NO": "Nurvij",
        "NP": "Nipal",
        "NR": "Nuru",
        "NU": "Niwi",
        "NZ": "Ziland Tamaynut",
        "OM": "Ɛuman",
        "PA": "Panam",
        "PE": "Piru",
        "PF": "Pulunizi tafransist",
        "PG": "Ɣinya Tamaynut Tapaput",
        "PH": "Filipin",
        "PL": "Pulund",
        "PM": "San Pyar d Miklun",
        "PN": "Pitkarin",
        "PR": "Purtu Riku",
        "PS": "Falisṭin d Ɣezza",
        "PT": "Purtugal",
        "PW": "Palu",
        "PY": "Paragway",
        "QA": "Qaṭar",
        "QO": "Timnaḍin ibeɛden n Tusyanit",
        "RE": "Timlilit",
        "RO": "Rumani",
        "RS": "Ṣirbya",
        "RU": "Rrus",
        "RW": "Ruwanda",
        "SA": "Suɛudiya Taɛrabt",
        "SB": "Tigzirin n Sulumun",
        "SC": "Seycel",
        "SE": "Swid",
        "SG": "Singafur",
        "SH": "Sant Ilina",
        "SI": "Sluvinya",
        "SJ": "Svalvard d Jan Mayen",
        "SK": "Sluvakya",
        "SL": "Sira Lyun",
        "SM": "San Marinu",
        "SN": "Sinigal",
        "SO": "Ṣumal",
        "SR": "Surinam",
        "SS": "Sudan n unẓul",
        "ST": "Saw Tumi d Pransip",
        "SV": "Salvadur",
        "SX": "San Maṛtan(Tamnaḍt tahulandit)",
        "SY": "Surya",
        "SZ": "Swazilund",
        "TA": "Tristan da Kunha",
        "TC": "Ṭurk d Tegzirin n Kaykus",
        "TD": "Čad",
        "TF": "Timura n umalu tifṛansisiyin",
        "TG": "Ṭugu",
        "TH": "Ṭayland",
        "TK": "Ṭuklu",
        "TL": "Tumur Asamar",
        "TM": "Ṭurkmanistan",
        "TN": "Tunes",
        "TO": "Ṭunga",
        "TR": "Ṭurk",
        "TT": "Ṭrindad d Ṭubagu",
        "TV": "Ṭuvalu",
        "TW": "Ṭaywan",
        "TZ": "Ṭanzanya",
        "UA": "Ukran",
        "UG": "Uɣanda",
        "UM": "Tigzirin ibeɛden n Marikan",
        "UN": "Timura Idduklen",
        "US": "WDM",
        "UY": "Urugway",
        "UZ": "Uzbaxistan",
        "VA": "Awanek n Vatikan",
        "VC": "San Vansu d Grunadin",
        "VE": "Venzwila",
        "VG": "Tigzirin Tiverjiniyin Tigliziyin",
        "VI": "W.D. Tigzirin n Virginya",
        "VN": "Vyeṭnam",
        "VU": "Vanwatu",
        "WF": "Wallis d Futuna",
        "WS": "Samwa",
        "XK": "Kuṣuvu",
        "YE": "Lyamen",
        "YT": "Mayuṭ",
        "ZA": "Tafriqt Wadda",
        "ZM": "Zambya",
        "ZW": "Zimbabwi",
        "ZZ": "Timnaḍin Tirussinin"
    };
  }-*/;
}
