/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fo" locale.
 */
public class LocalizedNamesImpl_fo extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AZ",
        "AU",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "BN",
        "BG",
        "BF",
        "MM",
        "BI",
        "BT",
        "KY",
        "EA",
        "CP",
        "CK",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DO",
        "DM",
        "EG",
        "EC",
        "GQ",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "AT",
        "TL",
        "FK",
        "FJ",
        "CI",
        "PH",
        "FI",
        "FR",
        "PF",
        "GF",
        "MF",
        "FO",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "CV",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "BY",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "CX",
        "JO",
        "KH",
        "CM",
        "CA",
        "IC",
        "KZ",
        "QA",
        "CZ",
        "KE",
        "CL",
        "CN",
        "KG",
        "KI",
        "TD",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "HR",
        "CU",
        "KW",
        "CY",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "IM",
        "MA",
        "MH",
        "MQ",
        "YT",
        "MX",
        "CF",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MR",
        "MU",
        "MZ",
        "NA",
        "NR",
        "NP",
        "AN",
        "NL",
        "BQ",
        "SX",
        "NE",
        "NG",
        "NI",
        "NU",
        "KP",
        "MP",
        "SD",
        "NO",
        "NF",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "QO",
        "RE",
        "RW",
        "RO",
        "RU",
        "BL",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "SB",
        "US",
        "VI",
        "ZM",
        "AE",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "ZW",
        "SG",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "GB",
        "VG",
        "ZA",
        "GS",
        "KR",
        "SS",
        "SR",
        "SJ",
        "SZ",
        "CH",
        "SE",
        "SY",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TF",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "DE",
        "UG",
        "UA",
        "UM",
        "HU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "EH",
        "VN",
        "WF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "heimur");
    namesMap.put("003", "Norðuramerika");
    namesMap.put("005", "Suðuramerika");
    namesMap.put("009", "Kyrrahavsoyggjarnar");
    namesMap.put("011", "Vesturafrika");
    namesMap.put("013", "Sentralamerika");
    namesMap.put("014", "Eysturafrika");
    namesMap.put("015", "Norðurafrika");
    namesMap.put("017", "Miðafrika");
    namesMap.put("018", "Suður Afrika");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika norður Meksiko");
    namesMap.put("029", "Karibia");
    namesMap.put("030", "Eysturasia");
    namesMap.put("034", "Suðurasia");
    namesMap.put("035", "Suðureysturasia");
    namesMap.put("039", "Suðurevropa");
    namesMap.put("053", "Avstralia og Nýsæland");
    namesMap.put("057", "Mikronesiske regionen");
    namesMap.put("143", "Sentralasia");
    namesMap.put("145", "Vesturasia");
    namesMap.put("150", "Evropa");
    namesMap.put("151", "Eysturevropa");
    namesMap.put("154", "Norðurevropa");
    namesMap.put("155", "Vesturevropa");
    namesMap.put("419", "Latínamerika");
    namesMap.put("AC", "Ascensionoyggjin");
    namesMap.put("AE", "Sameindu Emirríkini");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua og Barbuda");
    namesMap.put("AN", "Niðurlendsku Antilloyggjarnar");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AS", "Amerikanska Sámoa");
    namesMap.put("AT", "Eysturríki");
    namesMap.put("AU", "Avstralia");
    namesMap.put("AX", "Áland");
    namesMap.put("AZ", "Aserbajdsjan");
    namesMap.put("BA", "Bosnia-Hersegovina");
    namesMap.put("BD", "Bangladesj");
    namesMap.put("BE", "Belgia");
    namesMap.put("BQ", "Niðurlonds Karibia");
    namesMap.put("BR", "Brasilia");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Bouvetoyggjin");
    namesMap.put("BW", "Botsvana");
    namesMap.put("BY", "Hvítarussland");
    namesMap.put("BZ", "Belis");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosoyggjarnar");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Miðafrikalýðveldið");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Sveis");
    namesMap.put("CI", "Fílabeinsstrondin");
    namesMap.put("CK", "Cooksoyggjarnar");
    namesMap.put("CL", "Kili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Clippertonoyggjin");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Grønhøvdaoyggjarnar");
    namesMap.put("CX", "Jólaoyggjin");
    namesMap.put("CY", "Kýpros");
    namesMap.put("CZ", "Kekkia");
    namesMap.put("DE", "Týskland");
    namesMap.put("DK", "Danmørk");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Domingo lýðveldið");
    namesMap.put("EA", "Ceuta og Melilla");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estland");
    namesMap.put("EG", "Egyptaland");
    namesMap.put("EH", "Vestursahara");
    namesMap.put("ES", "Spania");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Evropasamveldið");
    namesMap.put("FI", "Finnland");
    namesMap.put("FK", "Falklandsoyggjarnar");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Føroyar");
    namesMap.put("FR", "Frakland");
    namesMap.put("GB", "Stóra Bretland");
    namesMap.put("GF", "Fransk Gujana");
    namesMap.put("GL", "Grønland");
    namesMap.put("GQ", "Ekvator Guinea");
    namesMap.put("GR", "Grikkaland");
    namesMap.put("GS", "Suðurgeorgia");
    namesMap.put("GW", "Guinea Bissau");
    namesMap.put("GY", "Gujana");
    namesMap.put("HK", "Hongkong");
    namesMap.put("HM", "Heard- og McDonald-oyggjarnar");
    namesMap.put("HR", "Kroatia");
    namesMap.put("HU", "Ungarn");
    namesMap.put("IC", "Kanaríoyggjarnar");
    namesMap.put("IE", "Írland");
    namesMap.put("IL", "Ísrael");
    namesMap.put("IM", "Mann");
    namesMap.put("IO", "Bretsku Indiahavsoyggjarnar");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Ísland");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jameika");
    namesMap.put("JO", "Jordania");
    namesMap.put("KE", "Kenja");
    namesMap.put("KG", "Kirgisia");
    namesMap.put("KH", "Kambodja");
    namesMap.put("KM", "Komorooyggjarnar");
    namesMap.put("KN", "Saint Kitts og Nevis");
    namesMap.put("KP", "Norður-Korea");
    namesMap.put("KR", "Suður-Korea");
    namesMap.put("KW", "Kuvait");
    namesMap.put("KY", "Caymanoyggjarnar");
    namesMap.put("KZ", "Kasakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Saint Lusia");
    namesMap.put("LI", "Liktenstein");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litava");
    namesMap.put("LU", "Luksemborg");
    namesMap.put("LV", "Lettland");
    namesMap.put("MA", "Marokko");
    namesMap.put("MC", "Monako");
    namesMap.put("MF", "Fransk Saint Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marshalloyggjarnar");
    namesMap.put("MK", "Makedónia");
    namesMap.put("MM", "Burma");
    namesMap.put("MO", "Makao");
    namesMap.put("MP", "Norðurmarianoyggjarnar");
    namesMap.put("MR", "Móritania");
    namesMap.put("MU", "Móritius");
    namesMap.put("MV", "Maldivuoyggjarnar");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Maleisia");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Ný-Kaledonia");
    namesMap.put("NF", "Norfolkoyggjin");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Niðurlond");
    namesMap.put("NO", "Noreg");
    namesMap.put("NZ", "Ný Sæland");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Franska Polynesia");
    namesMap.put("PG", "Papua Nýguinea");
    namesMap.put("PH", "Filipsoyggjar");
    namesMap.put("PL", "Pólland");
    namesMap.put("PM", "Saint Pierre og Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinskt territorium");
    namesMap.put("PY", "Paraguei");
    namesMap.put("QA", "Katar");
    namesMap.put("RO", "Rumenia");
    namesMap.put("RU", "Russland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi-Arábia");
    namesMap.put("SB", "Sálomonoyggjarnar");
    namesMap.put("SC", "Seyskelloyggjarnar");
    namesMap.put("SD", "Norðursudan");
    namesMap.put("SE", "Svøríki");
    namesMap.put("SG", "Singapor");
    namesMap.put("SJ", "Svalbard og Jan Mayen");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Suðursudan");
    namesMap.put("ST", "Sao Tome og Prinsipi");
    namesMap.put("SX", "Niðurlonds Saint Martin");
    namesMap.put("SZ", "Svasiland");
    namesMap.put("TC", "Turks- og Caicosoyggjarnar");
    namesMap.put("TD", "Kjad");
    namesMap.put("TH", "Teiland");
    namesMap.put("TJ", "Tadsjikistan");
    namesMap.put("TL", "Eystur-Timor");
    namesMap.put("TN", "Tunesia");
    namesMap.put("TR", "Turkaland");
    namesMap.put("TT", "Trinidad og Tobago");
    namesMap.put("TW", "Teivan");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UA", "Ukreina");
    namesMap.put("US", "Sambandsríki Amerika");
    namesMap.put("UY", "Uruguei");
    namesMap.put("UZ", "Usbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vinsent og Grenadinoyggjar");
    namesMap.put("VE", "Venesuela");
    namesMap.put("VG", "Stóra Bretlands Jómfrúoyggjarnar");
    namesMap.put("VI", "Sambandsríki Amerikas Jómfrúoyggjarnar");
    namesMap.put("WF", "Wallis og Futuna");
    namesMap.put("WS", "Sámoa");
    namesMap.put("YE", "Jemen");
    namesMap.put("ZA", "Suðurafrikalýðveldið");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabvi");
    namesMap.put("ZZ", "(ukendt område)");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "heimur",
        "003": "Norðuramerika",
        "005": "Suðuramerika",
        "009": "Kyrrahavsoyggjarnar",
        "011": "Vesturafrika",
        "013": "Sentralamerika",
        "014": "Eysturafrika",
        "015": "Norðurafrika",
        "017": "Miðafrika",
        "018": "Suður Afrika",
        "019": "Amerika",
        "021": "Amerika norður Meksiko",
        "029": "Karibia",
        "030": "Eysturasia",
        "034": "Suðurasia",
        "035": "Suðureysturasia",
        "039": "Suðurevropa",
        "053": "Avstralia og Nýsæland",
        "057": "Mikronesiske regionen",
        "143": "Sentralasia",
        "145": "Vesturasia",
        "150": "Evropa",
        "151": "Eysturevropa",
        "154": "Norðurevropa",
        "155": "Vesturevropa",
        "419": "Latínamerika",
        "AC": "Ascensionoyggjin",
        "AE": "Sameindu Emirríkini",
        "AF": "Afganistan",
        "AG": "Antigua og Barbuda",
        "AN": "Niðurlendsku Antilloyggjarnar",
        "AQ": "Antarktis",
        "AS": "Amerikanska Sámoa",
        "AT": "Eysturríki",
        "AU": "Avstralia",
        "AX": "Áland",
        "AZ": "Aserbajdsjan",
        "BA": "Bosnia-Hersegovina",
        "BD": "Bangladesj",
        "BE": "Belgia",
        "BQ": "Niðurlonds Karibia",
        "BR": "Brasilia",
        "BT": "Butan",
        "BV": "Bouvetoyggjin",
        "BW": "Botsvana",
        "BY": "Hvítarussland",
        "BZ": "Belis",
        "CA": "Kanada",
        "CC": "Kokosoyggjarnar",
        "CD": "Kongo-Kinshasa",
        "CF": "Miðafrikalýðveldið",
        "CG": "Kongo",
        "CH": "Sveis",
        "CI": "Fílabeinsstrondin",
        "CK": "Cooksoyggjarnar",
        "CL": "Kili",
        "CM": "Kamerun",
        "CN": "Kina",
        "CO": "Kolombia",
        "CP": "Clippertonoyggjin",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Grønhøvdaoyggjarnar",
        "CX": "Jólaoyggjin",
        "CY": "Kýpros",
        "CZ": "Kekkia",
        "DE": "Týskland",
        "DK": "Danmørk",
        "DM": "Dominika",
        "DO": "Domingo lýðveldið",
        "EA": "Ceuta og Melilla",
        "EC": "Ekvador",
        "EE": "Estland",
        "EG": "Egyptaland",
        "EH": "Vestursahara",
        "ES": "Spania",
        "ET": "Etiopia",
        "EU": "Evropasamveldið",
        "FI": "Finnland",
        "FK": "Falklandsoyggjarnar",
        "FM": "Mikronesia",
        "FO": "Føroyar",
        "FR": "Frakland",
        "GB": "Stóra Bretland",
        "GF": "Fransk Gujana",
        "GL": "Grønland",
        "GQ": "Ekvator Guinea",
        "GR": "Grikkaland",
        "GS": "Suðurgeorgia",
        "GW": "Guinea Bissau",
        "GY": "Gujana",
        "HK": "Hongkong",
        "HM": "Heard- og McDonald-oyggjarnar",
        "HR": "Kroatia",
        "HU": "Ungarn",
        "IC": "Kanaríoyggjarnar",
        "IE": "Írland",
        "IL": "Ísrael",
        "IM": "Mann",
        "IO": "Bretsku Indiahavsoyggjarnar",
        "IQ": "Irak",
        "IS": "Ísland",
        "IT": "Italia",
        "JM": "Jameika",
        "JO": "Jordania",
        "KE": "Kenja",
        "KG": "Kirgisia",
        "KH": "Kambodja",
        "KM": "Komorooyggjarnar",
        "KN": "Saint Kitts og Nevis",
        "KP": "Norður-Korea",
        "KR": "Suður-Korea",
        "KW": "Kuvait",
        "KY": "Caymanoyggjarnar",
        "KZ": "Kasakstan",
        "LB": "Libanon",
        "LC": "Saint Lusia",
        "LI": "Liktenstein",
        "LS": "Lesoto",
        "LT": "Litava",
        "LU": "Luksemborg",
        "LV": "Lettland",
        "MA": "Marokko",
        "MC": "Monako",
        "MF": "Fransk Saint Martin",
        "MG": "Madagaskar",
        "MH": "Marshalloyggjarnar",
        "MK": "Makedónia",
        "MM": "Burma",
        "MO": "Makao",
        "MP": "Norðurmarianoyggjarnar",
        "MR": "Móritania",
        "MU": "Móritius",
        "MV": "Maldivuoyggjarnar",
        "MW": "Malavi",
        "MX": "Meksiko",
        "MY": "Maleisia",
        "MZ": "Mosambik",
        "NC": "Ný-Kaledonia",
        "NF": "Norfolkoyggjin",
        "NI": "Nikaragua",
        "NL": "Niðurlond",
        "NO": "Noreg",
        "NZ": "Ný Sæland",
        "PE": "Perú",
        "PF": "Franska Polynesia",
        "PG": "Papua Nýguinea",
        "PH": "Filipsoyggjar",
        "PL": "Pólland",
        "PM": "Saint Pierre og Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestinskt territorium",
        "PY": "Paraguei",
        "QA": "Katar",
        "RO": "Rumenia",
        "RU": "Russland",
        "RW": "Ruanda",
        "SA": "Saudi-Arábia",
        "SB": "Sálomonoyggjarnar",
        "SC": "Seyskelloyggjarnar",
        "SD": "Norðursudan",
        "SE": "Svøríki",
        "SG": "Singapor",
        "SJ": "Svalbard og Jan Mayen",
        "SR": "Surinam",
        "SS": "Suðursudan",
        "ST": "Sao Tome og Prinsipi",
        "SX": "Niðurlonds Saint Martin",
        "SZ": "Svasiland",
        "TC": "Turks- og Caicosoyggjarnar",
        "TD": "Kjad",
        "TH": "Teiland",
        "TJ": "Tadsjikistan",
        "TL": "Eystur-Timor",
        "TN": "Tunesia",
        "TR": "Turkaland",
        "TT": "Trinidad og Tobago",
        "TW": "Teivan",
        "TZ": "Tansania",
        "UA": "Ukreina",
        "US": "Sambandsríki Amerika",
        "UY": "Uruguei",
        "UZ": "Usbekistan",
        "VA": "Vatikan",
        "VC": "Saint Vinsent og Grenadinoyggjar",
        "VE": "Venesuela",
        "VG": "Stóra Bretlands Jómfrúoyggjarnar",
        "VI": "Sambandsríki Amerikas Jómfrúoyggjarnar",
        "WF": "Wallis og Futuna",
        "WS": "Sámoa",
        "YE": "Jemen",
        "ZA": "Suðurafrikalýðveldið",
        "ZM": "Sambia",
        "ZW": "Simbabvi",
        "ZZ": "(ukendt område)"
    };
  }-*/;
}
