/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Int32Array;

public final class Int32ArrayImpl
extends ArrayBufferViewImpl
implements Int32Array {
    public Int32ArrayImpl(ArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length * 4);
    }

    @Override
    public int get(int index) {
        return this.arrayBuf.getInt32(this.checkRange(index, 4), true);
    }

    @Override
    public int length() {
        return this.byteLength() / 4;
    }

    @Override
    public void set(int index, int value) {
        this.arrayBuf.setInt32(this.checkRange(index, 4), value, true);
    }

    @Override
    public void set(int[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(int[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(Int32Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Int32Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array.get(i));
        }
    }

    @Override
    public Int32Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 4;
        return this.subarray(begin, count);
    }

    @Override
    public Int32Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 4;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Int32ArrayImpl(this.arrayBuf, begin * 4, end * 4);
    }
}

