/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.gwt.client.impl;

import com.google.web.bindery.autobean.gwt.client.impl.JsniCreatorMap;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.impl.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAutoBeanFactory
implements AutoBeanFactory,
EnumMap {
    protected Map<Enum<?>, String> enumToStringMap;
    protected Map<String, List<Enum<?>>> stringsToEnumsMap;
    private JsniCreatorMap creatorMap;

    @Override
    public <T> AutoBean<T> create(Class<T> clazz) {
        this.maybeInitializeCreatorMap();
        return this.creatorMap.create(clazz, this);
    }

    @Override
    public <T, U extends T> AutoBean<T> create(Class<T> clazz, U delegate) {
        this.maybeInitializeCreatorMap();
        return this.creatorMap.create(clazz, this, delegate);
    }

    @Override
    public <E extends Enum<?>> E getEnum(Class<E> clazz, String token) {
        this.maybeInitializeEnumMap();
        List<Enum<?>> list = this.stringsToEnumsMap.get(token);
        if (list == null) {
            throw new IllegalArgumentException(token);
        }
        for (Enum<?> e : list) {
            if (!e.getDeclaringClass().equals(clazz)) continue;
            Enum<?> toReturn = e;
            return (E)toReturn;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    @Override
    public String getToken(Enum<?> e) {
        this.maybeInitializeEnumMap();
        String toReturn = this.enumToStringMap.get(e);
        if (toReturn == null) {
            throw new IllegalArgumentException(e.toString());
        }
        return toReturn;
    }

    protected abstract void initializeCreatorMap(JsniCreatorMap var1);

    protected abstract void initializeEnumMap();

    private void maybeInitializeCreatorMap() {
        if (this.creatorMap == null) {
            this.creatorMap = JsniCreatorMap.createMap();
            this.initializeCreatorMap(this.creatorMap);
        }
    }

    private void maybeInitializeEnumMap() {
        if (this.enumToStringMap == null) {
            this.enumToStringMap = new HashMap();
            this.stringsToEnumsMap = new HashMap();
            this.initializeEnumMap();
        }
    }
}

