/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "km" locale.
 */
public class LocalizedNamesImpl_km extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "KH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "KH",
        "CA",
        "QA",
        "CV",
        "CM",
        "KZ",
        "CD",
        "CG",
        "KM",
        "CI",
        "CW",
        "KP",
        "KR",
        "XK",
        "CR",
        "CO",
        "KE",
        "IC",
        "CC",
        "TC",
        "KY",
        "CK",
        "CX",
        "CP",
        "NF",
        "BV",
        "PN",
        "MP",
        "MH",
        "VG",
        "VI",
        "SB",
        "HM",
        "FK",
        "FO",
        "GS",
        "AC",
        "AX",
        "UM",
        "GR",
        "HR",
        "KI",
        "CU",
        "KW",
        "KG",
        "GB",
        "CN",
        "TD",
        "JP",
        "EA",
        "JE",
        "NC",
        "DK",
        "DM",
        "TF",
        "PS",
        "IO",
        "DG",
        "NA",
        "NR",
        "NU",
        "TZ",
        "TJ",
        "TO",
        "TK",
        "TG",
        "TW",
        "TH",
        "VA",
        "TL",
        "TN",
        "TV",
        "TM",
        "TR",
        "TT",
        "TA",
        "NI",
        "NE",
        "NG",
        "NZ",
        "NP",
        "NO",
        "BD",
        "BB",
        "FR",
        "BH",
        "BS",
        "BW",
        "BO",
        "BA",
        "BJ",
        "BZ",
        "BY",
        "BE",
        "PK",
        "PA",
        "PG",
        "PY",
        "PL",
        "PE",
        "BM",
        "BG",
        "BT",
        "BF",
        "BI",
        "BR",
        "PW",
        "PR",
        "PT",
        "BN",
        "FM",
        "MM",
        "MO",
        "MG",
        "MQ",
        "YT",
        "MA",
        "ML",
        "MV",
        "MT",
        "MK",
        "MW",
        "MY",
        "MX",
        "ME",
        "MS",
        "MN",
        "MC",
        "MR",
        "MU",
        "MZ",
        "YE",
        "RW",
        "RU",
        "RO",
        "RE",
        "LI",
        "LT",
        "LB",
        "LR",
        "LY",
        "LU",
        "LS",
        "VN",
        "VE",
        "VU",
        "WF",
        "KN",
        "BL",
        "PM",
        "MF",
        "LC",
        "SH",
        "EU",
        "US",
        "CZ",
        "DO",
        "MD",
        "CF",
        "SM",
        "WS",
        "EH",
        "VC",
        "SG",
        "SX",
        "SC",
        "SO",
        "SR",
        "SZ",
        "RS",
        "SN",
        "SL",
        "ST",
        "AS",
        "CY",
        "SY",
        "CL",
        "SE",
        "SD",
        "SS",
        "LK",
        "SI",
        "SK",
        "SJ",
        "CH",
        "HK",
        "HU",
        "HN",
        "NL",
        "BQ",
        "HT",
        "JO",
        "GH",
        "GT",
        "GA",
        "GU",
        "GM",
        "GN",
        "GW",
        "GQ",
        "GI",
        "GY",
        "GG",
        "GP",
        "GD",
        "GL",
        "FI",
        "FJ",
        "PH",
        "PF",
        "GF",
        "GE",
        "JM",
        "ZM",
        "DJ",
        "ZW",
        "LV",
        "LA",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AO",
        "ZA",
        "AM",
        "AW",
        "SA",
        "AL",
        "DZ",
        "DE",
        "AZ",
        "AF",
        "AR",
        "AT",
        "OM",
        "AU",
        "IE",
        "EC",
        "ET",
        "AE",
        "ER",
        "EE",
        "ES",
        "EG",
        "SV",
        "IM",
        "QO",
        "IT",
        "IR",
        "IQ",
        "IL",
        "IS",
        "UA",
        "UY",
        "UG",
        "UZ",
        "IN",
        "ID",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ពិភពលោក");
    namesMap.put("002", "អាហ្វ្រិក");
    namesMap.put("003", "អាមេរិក​ខាង​ជើង");
    namesMap.put("005", "អាមេរិក​ខាង​ត្បូង");
    namesMap.put("009", "មហា​សមុទ្រ");
    namesMap.put("011", "អាព្រិក​ខាង​លិច");
    namesMap.put("013", "អាមេរិក​កណ្ដាល");
    namesMap.put("014", "អាព្រិក​ខាង​កើត");
    namesMap.put("015", "អាព្រិក​ខាង​ជើង");
    namesMap.put("017", "អាព្រិក​កណ្ដាល");
    namesMap.put("018", "អាព្រិក​ខាង​ត្បូង");
    namesMap.put("019", "អាមេរិក");
    namesMap.put("021", "អាមេរិក​ភាគ​ខាង​ជើង");
    namesMap.put("029", "ការ៉ាប៊ីន");
    namesMap.put("030", "អាស៊ី​ខាង​កើត");
    namesMap.put("034", "អាស៊ី​ខាង​ត្បូង");
    namesMap.put("035", "អាស៊ី អាគ្នេយ៍");
    namesMap.put("039", "អឺរ៉ុប​ខាង​ត្បូង");
    namesMap.put("053", "អូស្ត្រាឡាស៊ី");
    namesMap.put("054", "មេឡែណេស៊ី");
    namesMap.put("057", "តំបន់​មីក្រូណេស៊ី");
    namesMap.put("061", "ប៉ូលីណេស៊ី");
    namesMap.put("142", "អាស៊ី");
    namesMap.put("143", "អាស៊ី​កណ្ដាល");
    namesMap.put("145", "អាស៊ី​ខាង​លិច");
    namesMap.put("150", "អឺរ៉ុប");
    namesMap.put("151", "អឺរ៉ុប​ខាង​កើត");
    namesMap.put("154", "អឺរ៉ុប​ខាង​ជើង");
    namesMap.put("155", "អឺរ៉ុប​ខាង​លិច");
    namesMap.put("419", "អាមេរិក​ឡាទីន");
    namesMap.put("AC", "កោះ​អាសេនសិន");
    namesMap.put("AD", "អង់ដូរ៉ា");
    namesMap.put("AE", "អេមីរ៉ែទអារ៉ាប់រួម");
    namesMap.put("AF", "អាហ្វហ្គានីស្ថាន");
    namesMap.put("AG", "អង់ទីគ័រ និង​បាបុយដា");
    namesMap.put("AI", "អង់កូឡា");
    namesMap.put("AL", "អាល់បានី");
    namesMap.put("AM", "អារមេនី");
    namesMap.put("AO", "អង់ហ្គោឡា");
    namesMap.put("AQ", "អង់តាទីកា");
    namesMap.put("AR", "អាហ្សង់ទីន");
    namesMap.put("AS", "សៅម៉ៅ អាមេរិក");
    namesMap.put("AT", "អូទ្រីស");
    namesMap.put("AU", "អូស្ត្រាលី");
    namesMap.put("AW", "អារូបា");
    namesMap.put("AX", "កោះ​អាឡាំង");
    namesMap.put("AZ", "អាហ៊្សែរបែហ្សង់");
    namesMap.put("BA", "បូស្ន៉ី");
    namesMap.put("BB", "បារបាដូស");
    namesMap.put("BD", "បង់ក្លាដេស្ហ");
    namesMap.put("BE", "បែលហ្ស៉ិក");
    namesMap.put("BF", "ប៊ូរគីណាហ្វាសូ");
    namesMap.put("BG", "ប៊ុលហ្គារី");
    namesMap.put("BH", "បារ៉ែន");
    namesMap.put("BI", "ប៊ូរុនឌី");
    namesMap.put("BJ", "បេណាំង");
    namesMap.put("BL", "សង់ បាតេឡេម៉ី");
    namesMap.put("BM", "ប៊ឺមុយដា");
    namesMap.put("BN", "ព្រុយណេ");
    namesMap.put("BO", "បូលីវី");
    namesMap.put("BQ", "ហុល្លង់ ការ៉ាប៊ីន");
    namesMap.put("BR", "ប្រេស៊ីល");
    namesMap.put("BS", "បាហាម៉ា");
    namesMap.put("BT", "ប៊ូតាន");
    namesMap.put("BV", "កោះ​ប៊ូវ៉េត");
    namesMap.put("BW", "បុតស្វាណា");
    namesMap.put("BY", "បេឡារុស្ស");
    namesMap.put("BZ", "បេលីហ្ស");
    namesMap.put("CA", "កាណាដា");
    namesMap.put("CC", "កោះ​កូកូស");
    namesMap.put("CD", "កុងហ្គោ- គីនស្ហាសា");
    namesMap.put("CF", "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល");
    namesMap.put("CG", "កុងហ្គោ - ប្រាហ្សាវីល");
    namesMap.put("CH", "ស្វីស");
    namesMap.put("CI", "កូដឌីវ័រ");
    namesMap.put("CK", "កោះ​ខូក");
    namesMap.put("CL", "ស៊ីលី");
    namesMap.put("CM", "កាមេរូន");
    namesMap.put("CN", "ចិន");
    namesMap.put("CO", "កូឡុំប៊ី");
    namesMap.put("CP", "កោះ​ឃ្លីភឺតុន");
    namesMap.put("CR", "កូស្តារីកា");
    namesMap.put("CU", "គុយបា");
    namesMap.put("CV", "កាបវែរ");
    namesMap.put("CW", "កូរ៉ាកៅ");
    namesMap.put("CX", "កោះ​គ្រីស្មាស");
    namesMap.put("CY", "ស៉ីពរ៍");
    namesMap.put("CZ", "សាធារណរដ្ឋឆេក");
    namesMap.put("DE", "អាល្លឺម៉ង់");
    namesMap.put("DG", "ឌៀហ្គោហ្គាស៊ី");
    namesMap.put("DJ", "ហ្ស៉ីបូទី");
    namesMap.put("DK", "ដាណឺម៉ាក");
    namesMap.put("DM", "ដូមីនីកា");
    namesMap.put("DO", "សាធារណរដ្ឋដូមីនីកែន");
    namesMap.put("DZ", "អាល់ហ្សេរី");
    namesMap.put("EA", "ជឺតា និង​ម៉េលីឡា");
    namesMap.put("EC", "អេក្វាឌ័រ");
    namesMap.put("EE", "អេស្តូនី");
    namesMap.put("EG", "អេហ្ស៉ីប");
    namesMap.put("EH", "សាហារ៉ាខាងលិច");
    namesMap.put("ER", "អេរីទ្រា");
    namesMap.put("ES", "អេស្ប៉ាញ");
    namesMap.put("ET", "អេត្យូពី");
    namesMap.put("EU", "សហភាព​អឺរ៉ុប");
    namesMap.put("FI", "ហ្វាំងឡង់");
    namesMap.put("FJ", "ហ្វីជី");
    namesMap.put("FK", "កោះ​ហ្វក់ឡែន");
    namesMap.put("FM", "មិក្រូនេស៊ី");
    namesMap.put("FO", "កោះ​ហ្វារ៉ូ");
    namesMap.put("FR", "បារាំង");
    namesMap.put("GA", "ហ្គាបុង");
    namesMap.put("GB", "ចក្រភព​អង់គ្លេស");
    namesMap.put("GD", "ហ្គ្រើណាដ");
    namesMap.put("GE", "ហ្សកហ្ស៉ី");
    namesMap.put("GF", "ហ្វ្វេន​ហ្គៀណា");
    namesMap.put("GG", "ហ្គេនស៊ី");
    namesMap.put("GH", "ហ្គាណា");
    namesMap.put("GI", "ហ្គីប្រាលតា");
    namesMap.put("GL", "ហ្គ្រោអង់ឡង់");
    namesMap.put("GM", "ហ្គាំប៊ី");
    namesMap.put("GN", "ហ្គីណេ");
    namesMap.put("GP", "ហ្គោដឺឡុប");
    namesMap.put("GQ", "ហ្គីណេអេក្វាទ័រ");
    namesMap.put("GR", "ក្រិច");
    namesMap.put("GS", "កោះ​ហ្សកហ្ស៊ី​ខាង​ត្បូង និង​សាន់វិច​ខាង​ត្បូង");
    namesMap.put("GT", "ហ្គាតេម៉ាឡា");
    namesMap.put("GU", "ហ្គាំ");
    namesMap.put("GW", "ហ្គីណេប៊ីសូ");
    namesMap.put("GY", "ហ្គីយ៉ាណា");
    namesMap.put("HK", "ហុងកុង");
    namesMap.put("HM", "កោះ​ហឺដ និង​ម៉ាក់ដូណាល់");
    namesMap.put("HN", "ហុងឌួរ៉ាស់");
    namesMap.put("HR", "ក្រូអាត");
    namesMap.put("HT", "ហៃទី");
    namesMap.put("HU", "ហុងគ្រី");
    namesMap.put("IC", "កោះ​កាណារី");
    namesMap.put("ID", "ឥណ្ឌូណេស៊ី");
    namesMap.put("IE", "អៀរឡង់");
    namesMap.put("IL", "អ៊ីស្រាអែល");
    namesMap.put("IM", "អែលអុហ្វមែន");
    namesMap.put("IN", "ឥណ្ឌា");
    namesMap.put("IO", "ដែន​មហា​សមុទ្រ​ឥណ្ឌា ចក្រភព​អង់គ្លេស");
    namesMap.put("IQ", "អ៊ីរ៉ាក់");
    namesMap.put("IR", "អ៊ីរ៉ង់");
    namesMap.put("IS", "អ៊ីស្លង់");
    namesMap.put("IT", "អ៊ីតាលី");
    namesMap.put("JE", "ជឺស៊ី");
    namesMap.put("JM", "ហ្សាម៉ាអ៉ិគ");
    namesMap.put("JO", "ហ៊្សកដានី");
    namesMap.put("JP", "ជប៉ុន");
    namesMap.put("KE", "កេនយ៉ា");
    namesMap.put("KG", "គៀរហ្គីស្តង់");
    namesMap.put("KH", "កម្ពុជា");
    namesMap.put("KI", "គិរិបាទី");
    namesMap.put("KM", "កុំម៉ូរ៉ូស");
    namesMap.put("KN", "សង់ឃីត និង​ណេវីស");
    namesMap.put("KP", "កូរ៉េ​ខាង​ជើង");
    namesMap.put("KR", "កូរ៉េ​ខាង​ត្បូង");
    namesMap.put("KW", "គុយវ៉ែត");
    namesMap.put("KY", "កោះ​កៃម៉ង់");
    namesMap.put("KZ", "កាហ្សាក់ស្តាង់់");
    namesMap.put("LA", "ឡាវ");
    namesMap.put("LB", "លីបង់");
    namesMap.put("LC", "សង់​លូសៀ");
    namesMap.put("LI", "លិចទេនស្តែន");
    namesMap.put("LK", "ស្រីលង្កា");
    namesMap.put("LR", "លីបេរីយ៉ា");
    namesMap.put("LS", "លើសូតូ");
    namesMap.put("LT", "លីទុយអានី");
    namesMap.put("LU", "លុចហ្សំបួរ");
    namesMap.put("LV", "ឡាតវីយ៉ា");
    namesMap.put("LY", "លីប៊ី");
    namesMap.put("MA", "ម៉ារ៉ុក");
    namesMap.put("MC", "ម៉ូណាកូ");
    namesMap.put("MD", "សាធារណរដ្ឋម៉ុលដាវី");
    namesMap.put("ME", "ម៉ុងតេណេហ្គ្រោ");
    namesMap.put("MF", "សង់​ម៉ាទីន");
    namesMap.put("MG", "ម៉ាដាហ្កាស្ការ");
    namesMap.put("MH", "កោះ​ម៉ាស់សល");
    namesMap.put("MK", "ម៉ាសេដន");
    namesMap.put("ML", "ម៉ាលី");
    namesMap.put("MM", "មីយ៉ាន់ម៉ា");
    namesMap.put("MN", "ម៉ុងហ្គោលី");
    namesMap.put("MO", "ម៉ាកាវ");
    namesMap.put("MP", "កោះ​ម៉ារីណា​ខាង​ជើង");
    namesMap.put("MQ", "ម៉ាទីនីក");
    namesMap.put("MR", "ម៉ូរីតានី");
    namesMap.put("MS", "ម៉ុង​សេរ៉ង់");
    namesMap.put("MT", "ម៉ាល់តា");
    namesMap.put("MU", "ម៉ូរីទុស");
    namesMap.put("MV", "ម៉ាល់ឌីវ");
    namesMap.put("MW", "ម៉ាឡាវី");
    namesMap.put("MX", "ម៉ិចសិក");
    namesMap.put("MY", "ម៉ាឡេស៊ី");
    namesMap.put("MZ", "ម៉ូហ្សាំប៊ិក");
    namesMap.put("NA", "ណាមីប៊ី");
    namesMap.put("NC", "ញូកាឡេដូនៀ");
    namesMap.put("NE", "នីហ្សេរ");
    namesMap.put("NF", "កោះ​ណ័រហ្វក់");
    namesMap.put("NG", "នីហ្សេរីយ៉ា");
    namesMap.put("NI", "នីការ៉ាហ្គ័រ");
    namesMap.put("NL", "ហុល្លង់");
    namesMap.put("NO", "ន័រវែស");
    namesMap.put("NP", "នេប៉ាល់");
    namesMap.put("NR", "ណូរូ");
    namesMap.put("NU", "ណៀ");
    namesMap.put("NZ", "នូវែលហ្សេឡង់");
    namesMap.put("OM", "អូម៉ង់");
    namesMap.put("PA", "ប៉ាណាម៉ា");
    namesMap.put("PE", "ប៉េរូ");
    namesMap.put("PF", "ហ្វ្រេន​ប៉ូលី​ណេស៊ី");
    namesMap.put("PG", "ប៉ាពូអានូវែលហ្គីណេ");
    namesMap.put("PH", "ហ្វីលីពីន");
    namesMap.put("PK", "ប៉ាគីស្ថាន");
    namesMap.put("PL", "ប៉ូលូញ");
    namesMap.put("PM", "សង់ព្យែរ និង​មីគីឡុង");
    namesMap.put("PN", "កោះ​ភីតខារិន");
    namesMap.put("PR", "ព័រតូរីកូ");
    namesMap.put("PS", "ដែន​ប៉ាលេស្ទីន");
    namesMap.put("PT", "ព័រទុយហ្កាល់");
    namesMap.put("PW", "ផៅឡូ");
    namesMap.put("PY", "ប៉ារ៉ាហ្គាយ");
    namesMap.put("QA", "កាតារ");
    namesMap.put("QO", "អៅលីយីង អុកស៊ីន");
    namesMap.put("RE", "រ៉េអ៊ុយ៉ុង");
    namesMap.put("RO", "រូម៉ានី");
    namesMap.put("RS", "សើប");
    namesMap.put("RU", "រុស្ស៊ី");
    namesMap.put("RW", "រវ៉ាន់ដា");
    namesMap.put("SA", "អារ៉ាប៊ីសាអ៊ូឌីត");
    namesMap.put("SB", "កោះ​ស៊ូឡូម៉ុង");
    namesMap.put("SC", "សីសែល");
    namesMap.put("SD", "ស៊ូដង់");
    namesMap.put("SE", "ស៊ុយអែដ");
    namesMap.put("SG", "សិង្ហបុរី");
    namesMap.put("SH", "សង់​ហេឡេណា");
    namesMap.put("SI", "ស្លូវេនី");
    namesMap.put("SJ", "ស្វាប៊ឺត និង​ហ្យង់ម៉ាយេន");
    namesMap.put("SK", "ស្លូវ៉ាគី");
    namesMap.put("SL", "សេរ៉ាឡេអូន");
    namesMap.put("SM", "សាន​ម៉ារីណូ");
    namesMap.put("SN", "សេនេហ្កាល់");
    namesMap.put("SO", "សូម៉ាលី");
    namesMap.put("SR", "សូរីណាម");
    namesMap.put("SS", "ស៊ូដង់​ខាង​ត្បូង");
    namesMap.put("ST", "សៅ​តុំ និង​ព្រីនស៊ីប៉េ");
    namesMap.put("SV", "អែលសាល់វ៉ាឌ័រ");
    namesMap.put("SX", "សីង​ម៉ាធីន");
    namesMap.put("SY", "ស៊ីរី");
    namesMap.put("SZ", "សូហ្ស៉ីឡង់");
    namesMap.put("TA", "ទ្រីស្តង់​ដា​ចូនហា");
    namesMap.put("TC", "កោះ​កៃកូស និងទូក");
    namesMap.put("TD", "ឆាដ");
    namesMap.put("TF", "ដែន​បារាំង​ខាង​ត្បូង");
    namesMap.put("TG", "តូហ្គូ");
    namesMap.put("TH", "ថៃ");
    namesMap.put("TJ", "តាដហ្ស៉ីគីស្តង់");
    namesMap.put("TK", "តូខេឡៅ");
    namesMap.put("TL", "ទីម័រ");
    namesMap.put("TM", "ទួគមេនីស្តង់");
    namesMap.put("TN", "ទុយនេស៊ី");
    namesMap.put("TO", "តុងហ្គា");
    namesMap.put("TR", "ទួរគី");
    namesMap.put("TT", "ទ្រីនីដាត និង​តូបាហ្គោ");
    namesMap.put("TV", "ទូវ៉ាលូ");
    namesMap.put("TW", "តៃវ៉ាន់");
    namesMap.put("TZ", "តង់ហ្សានី");
    namesMap.put("UA", "អ៊ុយក្រែន");
    namesMap.put("UG", "អ៊ូហ្កង់ដា");
    namesMap.put("UM", "កោះ​អៅឡាយីង​អាមេរិក");
    namesMap.put("US", "សហរដ្ឋអាមេរិក");
    namesMap.put("UY", "អ៊ុយរុយហ្គាយ");
    namesMap.put("UZ", "អ៊ូហ្សបេគីស្តង់");
    namesMap.put("VA", "ទីក្រុងវ៉ាទីកង់");
    namesMap.put("VC", "សាំង​វីនសេន និង​ឌឹ​ហ្គ្រីណាឌីនីស");
    namesMap.put("VE", "វេនេហ្ស៊ុយឡា");
    namesMap.put("VG", "កោះ​វឺជិន​ចក្រភព​អង់គ្លេស");
    namesMap.put("VI", "កោះ​វឺជីន​អាមេរិក");
    namesMap.put("VN", "វៀតណាម");
    namesMap.put("VU", "វ៉ាន់ណៅទូ");
    namesMap.put("WF", "វ៉ាលីស និង​ហ្វូទូណា");
    namesMap.put("WS", "សាមូអា");
    namesMap.put("XK", "កូសូវ៉ូ");
    namesMap.put("YE", "យេមែន");
    namesMap.put("YT", "ម៉ាយុត");
    namesMap.put("ZA", "អាព្រិក​ភាគ​ខាង​ត្បូង");
    namesMap.put("ZM", "ហ្សាំប៊ី");
    namesMap.put("ZW", "ហ្ស៊ីមបាបវ៉េ");
    namesMap.put("ZZ", "មិន​ស្គាល់​តំបន់");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ពិភពលោក",
        "002": "អាហ្វ្រិក",
        "003": "អាមេរិក​ខាង​ជើង",
        "005": "អាមេរិក​ខាង​ត្បូង",
        "009": "មហា​សមុទ្រ",
        "011": "អាព្រិក​ខាង​លិច",
        "013": "អាមេរិក​កណ្ដាល",
        "014": "អាព្រិក​ខាង​កើត",
        "015": "អាព្រិក​ខាង​ជើង",
        "017": "អាព្រិក​កណ្ដាល",
        "018": "អាព្រិក​ខាង​ត្បូង",
        "019": "អាមេរិក",
        "021": "អាមេរិក​ភាគ​ខាង​ជើង",
        "029": "ការ៉ាប៊ីន",
        "030": "អាស៊ី​ខាង​កើត",
        "034": "អាស៊ី​ខាង​ត្បូង",
        "035": "អាស៊ី អាគ្នេយ៍",
        "039": "អឺរ៉ុប​ខាង​ត្បូង",
        "053": "អូស្ត្រាឡាស៊ី",
        "054": "មេឡែណេស៊ី",
        "057": "តំបន់​មីក្រូណេស៊ី",
        "061": "ប៉ូលីណេស៊ី",
        "142": "អាស៊ី",
        "143": "អាស៊ី​កណ្ដាល",
        "145": "អាស៊ី​ខាង​លិច",
        "150": "អឺរ៉ុប",
        "151": "អឺរ៉ុប​ខាង​កើត",
        "154": "អឺរ៉ុប​ខាង​ជើង",
        "155": "អឺរ៉ុប​ខាង​លិច",
        "419": "អាមេរិក​ឡាទីន",
        "AC": "កោះ​អាសេនសិន",
        "AD": "អង់ដូរ៉ា",
        "AE": "អេមីរ៉ែទអារ៉ាប់រួម",
        "AF": "អាហ្វហ្គានីស្ថាន",
        "AG": "អង់ទីគ័រ និង​បាបុយដា",
        "AI": "អង់កូឡា",
        "AL": "អាល់បានី",
        "AM": "អារមេនី",
        "AO": "អង់ហ្គោឡា",
        "AQ": "អង់តាទីកា",
        "AR": "អាហ្សង់ទីន",
        "AS": "សៅម៉ៅ អាមេរិក",
        "AT": "អូទ្រីស",
        "AU": "អូស្ត្រាលី",
        "AW": "អារូបា",
        "AX": "កោះ​អាឡាំង",
        "AZ": "អាហ៊្សែរបែហ្សង់",
        "BA": "បូស្ន៉ី",
        "BB": "បារបាដូស",
        "BD": "បង់ក្លាដេស្ហ",
        "BE": "បែលហ្ស៉ិក",
        "BF": "ប៊ូរគីណាហ្វាសូ",
        "BG": "ប៊ុលហ្គារី",
        "BH": "បារ៉ែន",
        "BI": "ប៊ូរុនឌី",
        "BJ": "បេណាំង",
        "BL": "សង់ បាតេឡេម៉ី",
        "BM": "ប៊ឺមុយដា",
        "BN": "ព្រុយណេ",
        "BO": "បូលីវី",
        "BQ": "ហុល្លង់ ការ៉ាប៊ីន",
        "BR": "ប្រេស៊ីល",
        "BS": "បាហាម៉ា",
        "BT": "ប៊ូតាន",
        "BV": "កោះ​ប៊ូវ៉េត",
        "BW": "បុតស្វាណា",
        "BY": "បេឡារុស្ស",
        "BZ": "បេលីហ្ស",
        "CA": "កាណាដា",
        "CC": "កោះ​កូកូស",
        "CD": "កុងហ្គោ- គីនស្ហាសា",
        "CF": "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល",
        "CG": "កុងហ្គោ - ប្រាហ្សាវីល",
        "CH": "ស្វីស",
        "CI": "កូដឌីវ័រ",
        "CK": "កោះ​ខូក",
        "CL": "ស៊ីលី",
        "CM": "កាមេរូន",
        "CN": "ចិន",
        "CO": "កូឡុំប៊ី",
        "CP": "កោះ​ឃ្លីភឺតុន",
        "CR": "កូស្តារីកា",
        "CU": "គុយបា",
        "CV": "កាបវែរ",
        "CW": "កូរ៉ាកៅ",
        "CX": "កោះ​គ្រីស្មាស",
        "CY": "ស៉ីពរ៍",
        "CZ": "សាធារណរដ្ឋឆេក",
        "DE": "អាល្លឺម៉ង់",
        "DG": "ឌៀហ្គោហ្គាស៊ី",
        "DJ": "ហ្ស៉ីបូទី",
        "DK": "ដាណឺម៉ាក",
        "DM": "ដូមីនីកា",
        "DO": "សាធារណរដ្ឋដូមីនីកែន",
        "DZ": "អាល់ហ្សេរី",
        "EA": "ជឺតា និង​ម៉េលីឡា",
        "EC": "អេក្វាឌ័រ",
        "EE": "អេស្តូនី",
        "EG": "អេហ្ស៉ីប",
        "EH": "សាហារ៉ាខាងលិច",
        "ER": "អេរីទ្រា",
        "ES": "អេស្ប៉ាញ",
        "ET": "អេត្យូពី",
        "EU": "សហភាព​អឺរ៉ុប",
        "FI": "ហ្វាំងឡង់",
        "FJ": "ហ្វីជី",
        "FK": "កោះ​ហ្វក់ឡែន",
        "FM": "មិក្រូនេស៊ី",
        "FO": "កោះ​ហ្វារ៉ូ",
        "FR": "បារាំង",
        "GA": "ហ្គាបុង",
        "GB": "ចក្រភព​អង់គ្លេស",
        "GD": "ហ្គ្រើណាដ",
        "GE": "ហ្សកហ្ស៉ី",
        "GF": "ហ្វ្វេន​ហ្គៀណា",
        "GG": "ហ្គេនស៊ី",
        "GH": "ហ្គាណា",
        "GI": "ហ្គីប្រាលតា",
        "GL": "ហ្គ្រោអង់ឡង់",
        "GM": "ហ្គាំប៊ី",
        "GN": "ហ្គីណេ",
        "GP": "ហ្គោដឺឡុប",
        "GQ": "ហ្គីណេអេក្វាទ័រ",
        "GR": "ក្រិច",
        "GS": "កោះ​ហ្សកហ្ស៊ី​ខាង​ត្បូង និង​សាន់វិច​ខាង​ត្បូង",
        "GT": "ហ្គាតេម៉ាឡា",
        "GU": "ហ្គាំ",
        "GW": "ហ្គីណេប៊ីសូ",
        "GY": "ហ្គីយ៉ាណា",
        "HK": "ហុងកុង",
        "HM": "កោះ​ហឺដ និង​ម៉ាក់ដូណាល់",
        "HN": "ហុងឌួរ៉ាស់",
        "HR": "ក្រូអាត",
        "HT": "ហៃទី",
        "HU": "ហុងគ្រី",
        "IC": "កោះ​កាណារី",
        "ID": "ឥណ្ឌូណេស៊ី",
        "IE": "អៀរឡង់",
        "IL": "អ៊ីស្រាអែល",
        "IM": "អែលអុហ្វមែន",
        "IN": "ឥណ្ឌា",
        "IO": "ដែន​មហា​សមុទ្រ​ឥណ្ឌា ចក្រភព​អង់គ្លេស",
        "IQ": "អ៊ីរ៉ាក់",
        "IR": "អ៊ីរ៉ង់",
        "IS": "អ៊ីស្លង់",
        "IT": "អ៊ីតាលី",
        "JE": "ជឺស៊ី",
        "JM": "ហ្សាម៉ាអ៉ិគ",
        "JO": "ហ៊្សកដានី",
        "JP": "ជប៉ុន",
        "KE": "កេនយ៉ា",
        "KG": "គៀរហ្គីស្តង់",
        "KH": "កម្ពុជា",
        "KI": "គិរិបាទី",
        "KM": "កុំម៉ូរ៉ូស",
        "KN": "សង់ឃីត និង​ណេវីស",
        "KP": "កូរ៉េ​ខាង​ជើង",
        "KR": "កូរ៉េ​ខាង​ត្បូង",
        "KW": "គុយវ៉ែត",
        "KY": "កោះ​កៃម៉ង់",
        "KZ": "កាហ្សាក់ស្តាង់់",
        "LA": "ឡាវ",
        "LB": "លីបង់",
        "LC": "សង់​លូសៀ",
        "LI": "លិចទេនស្តែន",
        "LK": "ស្រីលង្កា",
        "LR": "លីបេរីយ៉ា",
        "LS": "លើសូតូ",
        "LT": "លីទុយអានី",
        "LU": "លុចហ្សំបួរ",
        "LV": "ឡាតវីយ៉ា",
        "LY": "លីប៊ី",
        "MA": "ម៉ារ៉ុក",
        "MC": "ម៉ូណាកូ",
        "MD": "សាធារណរដ្ឋម៉ុលដាវី",
        "ME": "ម៉ុងតេណេហ្គ្រោ",
        "MF": "សង់​ម៉ាទីន",
        "MG": "ម៉ាដាហ្កាស្ការ",
        "MH": "កោះ​ម៉ាស់សល",
        "MK": "ម៉ាសេដន",
        "ML": "ម៉ាលី",
        "MM": "មីយ៉ាន់ម៉ា",
        "MN": "ម៉ុងហ្គោលី",
        "MO": "ម៉ាកាវ",
        "MP": "កោះ​ម៉ារីណា​ខាង​ជើង",
        "MQ": "ម៉ាទីនីក",
        "MR": "ម៉ូរីតានី",
        "MS": "ម៉ុង​សេរ៉ង់",
        "MT": "ម៉ាល់តា",
        "MU": "ម៉ូរីទុស",
        "MV": "ម៉ាល់ឌីវ",
        "MW": "ម៉ាឡាវី",
        "MX": "ម៉ិចសិក",
        "MY": "ម៉ាឡេស៊ី",
        "MZ": "ម៉ូហ្សាំប៊ិក",
        "NA": "ណាមីប៊ី",
        "NC": "ញូកាឡេដូនៀ",
        "NE": "នីហ្សេរ",
        "NF": "កោះ​ណ័រហ្វក់",
        "NG": "នីហ្សេរីយ៉ា",
        "NI": "នីការ៉ាហ្គ័រ",
        "NL": "ហុល្លង់",
        "NO": "ន័រវែស",
        "NP": "នេប៉ាល់",
        "NR": "ណូរូ",
        "NU": "ណៀ",
        "NZ": "នូវែលហ្សេឡង់",
        "OM": "អូម៉ង់",
        "PA": "ប៉ាណាម៉ា",
        "PE": "ប៉េរូ",
        "PF": "ហ្វ្រេន​ប៉ូលី​ណេស៊ី",
        "PG": "ប៉ាពូអានូវែលហ្គីណេ",
        "PH": "ហ្វីលីពីន",
        "PK": "ប៉ាគីស្ថាន",
        "PL": "ប៉ូលូញ",
        "PM": "សង់ព្យែរ និង​មីគីឡុង",
        "PN": "កោះ​ភីតខារិន",
        "PR": "ព័រតូរីកូ",
        "PS": "ដែន​ប៉ាលេស្ទីន",
        "PT": "ព័រទុយហ្កាល់",
        "PW": "ផៅឡូ",
        "PY": "ប៉ារ៉ាហ្គាយ",
        "QA": "កាតារ",
        "QO": "អៅលីយីង អុកស៊ីន",
        "RE": "រ៉េអ៊ុយ៉ុង",
        "RO": "រូម៉ានី",
        "RS": "សើប",
        "RU": "រុស្ស៊ី",
        "RW": "រវ៉ាន់ដា",
        "SA": "អារ៉ាប៊ីសាអ៊ូឌីត",
        "SB": "កោះ​ស៊ូឡូម៉ុង",
        "SC": "សីសែល",
        "SD": "ស៊ូដង់",
        "SE": "ស៊ុយអែដ",
        "SG": "សិង្ហបុរី",
        "SH": "សង់​ហេឡេណា",
        "SI": "ស្លូវេនី",
        "SJ": "ស្វាប៊ឺត និង​ហ្យង់ម៉ាយេន",
        "SK": "ស្លូវ៉ាគី",
        "SL": "សេរ៉ាឡេអូន",
        "SM": "សាន​ម៉ារីណូ",
        "SN": "សេនេហ្កាល់",
        "SO": "សូម៉ាលី",
        "SR": "សូរីណាម",
        "SS": "ស៊ូដង់​ខាង​ត្បូង",
        "ST": "សៅ​តុំ និង​ព្រីនស៊ីប៉េ",
        "SV": "អែលសាល់វ៉ាឌ័រ",
        "SX": "សីង​ម៉ាធីន",
        "SY": "ស៊ីរី",
        "SZ": "សូហ្ស៉ីឡង់",
        "TA": "ទ្រីស្តង់​ដា​ចូនហា",
        "TC": "កោះ​កៃកូស និងទូក",
        "TD": "ឆាដ",
        "TF": "ដែន​បារាំង​ខាង​ត្បូង",
        "TG": "តូហ្គូ",
        "TH": "ថៃ",
        "TJ": "តាដហ្ស៉ីគីស្តង់",
        "TK": "តូខេឡៅ",
        "TL": "ទីម័រ",
        "TM": "ទួគមេនីស្តង់",
        "TN": "ទុយនេស៊ី",
        "TO": "តុងហ្គា",
        "TR": "ទួរគី",
        "TT": "ទ្រីនីដាត និង​តូបាហ្គោ",
        "TV": "ទូវ៉ាលូ",
        "TW": "តៃវ៉ាន់",
        "TZ": "តង់ហ្សានី",
        "UA": "អ៊ុយក្រែន",
        "UG": "អ៊ូហ្កង់ដា",
        "UM": "កោះ​អៅឡាយីង​អាមេរិក",
        "US": "សហរដ្ឋអាមេរិក",
        "UY": "អ៊ុយរុយហ្គាយ",
        "UZ": "អ៊ូហ្សបេគីស្តង់",
        "VA": "ទីក្រុងវ៉ាទីកង់",
        "VC": "សាំង​វីនសេន និង​ឌឹ​ហ្គ្រីណាឌីនីស",
        "VE": "វេនេហ្ស៊ុយឡា",
        "VG": "កោះ​វឺជិន​ចក្រភព​អង់គ្លេស",
        "VI": "កោះ​វឺជីន​អាមេរិក",
        "VN": "វៀតណាម",
        "VU": "វ៉ាន់ណៅទូ",
        "WF": "វ៉ាលីស និង​ហ្វូទូណា",
        "WS": "សាមូអា",
        "XK": "កូសូវ៉ូ",
        "YE": "យេមែន",
        "YT": "ម៉ាយុត",
        "ZA": "អាព្រិក​ភាគ​ខាង​ត្បូង",
        "ZM": "ហ្សាំប៊ី",
        "ZW": "ហ្ស៊ីមបាបវ៉េ",
        "ZZ": "មិន​ស្គាល់​តំបន់"
    };
  }-*/;
}
