/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental.svg;

import elemental.events.*;
import elemental.util.*;
import elemental.dom.*;
import elemental.html.*;
import elemental.css.*;
import elemental.stylesheets.*;

import java.util.Date;

/**
  * This filter is used to erode or dilate the input image. It's usefulness lies especially in fattening or thinning effects.
  */
@Deprecated
public interface SVGFEMorphologyElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {

    static final int SVG_MORPHOLOGY_OPERATOR_DILATE = 2;

    static final int SVG_MORPHOLOGY_OPERATOR_ERODE = 1;

    static final int SVG_MORPHOLOGY_OPERATOR_UNKNOWN = 0;

  SVGAnimatedString getIn1();

  SVGAnimatedEnumeration getOperator();

  SVGAnimatedNumber getRadiusX();

  SVGAnimatedNumber getRadiusY();

  void setRadius(float radiusX, float radiusY);
}
