/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.testing.IgnoreJRERequirement;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import junit.framework.Assert;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
@IgnoreJRERequirement
public final class CollectorTester<T, A, R> {
    private final Collector<T, A, R> collector;
    private final BiPredicate<? super R, ? super R> equivalence;

    public static <T, A, R> CollectorTester<T, A, R> of(Collector<T, A, R> collector) {
        return CollectorTester.of(collector, Objects::equals);
    }

    public static <T, A, R> CollectorTester<T, A, R> of(Collector<T, A, R> collector, BiPredicate<? super R, ? super R> equivalence) {
        return new CollectorTester<T, A, R>(collector, equivalence);
    }

    private CollectorTester(Collector<T, A, R> collector, BiPredicate<? super R, ? super R> equivalence) {
        this.collector = (Collector)Preconditions.checkNotNull(collector);
        this.equivalence = (BiPredicate)Preconditions.checkNotNull(equivalence);
    }

    @SafeVarargs
    @CanIgnoreReturnValue
    public final CollectorTester<T, A, R> expectCollects(R expectedResult, T ... inputs) {
        List<T> list = Arrays.asList(inputs);
        this.doExpectCollects(expectedResult, list);
        if (this.collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            Collections.reverse(list);
            this.doExpectCollects(expectedResult, list);
        }
        return this;
    }

    private void doExpectCollects(R expectedResult, List<T> inputs) {
        for (CollectStrategy scheme : CollectStrategy.values()) {
            A finalAccum = scheme.result(this.collector, inputs);
            if (this.collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
                A result = finalAccum;
                this.assertEquivalent(expectedResult, result);
            }
            this.assertEquivalent(expectedResult, this.collector.finisher().apply(finalAccum));
        }
    }

    private void assertEquivalent(R expected, R actual) {
        Assert.assertTrue((String)("Expected " + expected + " got " + actual + " modulo equivalence " + this.equivalence), (boolean)this.equivalence.test(expected, actual));
    }

    @IgnoreJRERequirement
    static enum CollectStrategy {
        SEQUENTIAL{

            @Override
            final <T, A, R> A result(Collector<T, A, R> collector, Iterable<T> inputs) {
                A accum = collector.supplier().get();
                for (T input : inputs) {
                    collector.accumulator().accept(accum, input);
                }
                return accum;
            }
        }
        ,
        MERGE_LEFT_ASSOCIATIVE{

            @Override
            final <T, A, R> A result(Collector<T, A, R> collector, Iterable<T> inputs) {
                Object accum = collector.supplier().get();
                for (T input : inputs) {
                    A newAccum = collector.supplier().get();
                    collector.accumulator().accept(newAccum, input);
                    accum = collector.combiner().apply(accum, newAccum);
                }
                return accum;
            }
        }
        ,
        MERGE_RIGHT_ASSOCIATIVE{

            @Override
            final <T, A, R> A result(Collector<T, A, R> collector, Iterable<T> inputs) {
                ArrayList stack = new ArrayList();
                for (T input : inputs) {
                    A newAccum = collector.supplier().get();
                    collector.accumulator().accept(newAccum, input);
                    this.push(stack, newAccum);
                }
                this.push(stack, collector.supplier().get());
                while (stack.size() > 1) {
                    Object right = this.pop(stack);
                    Object left = this.pop(stack);
                    this.push(stack, collector.combiner().apply(left, right));
                }
                return (A)this.pop(stack);
            }

            <E> void push(List<E> stack, E value) {
                stack.add(value);
            }

            <E> E pop(List<E> stack) {
                return stack.remove(stack.size() - 1);
            }
        };


        abstract <T, A, R> A result(Collector<T, A, R> var1, Iterable<T> var2);
    }
}

