/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class MapGetOrDefaultTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetOrDefault_present() {
        MapGetOrDefaultTester.assertEquals((String)"getOrDefault(present, def) should return the associated value", this.v0(), this.getMap().getOrDefault(this.k0(), this.v3()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetOrDefault_presentNullDefault() {
        MapGetOrDefaultTester.assertEquals((String)"getOrDefault(present, null) should return the associated value", this.v0(), this.getMap().getOrDefault(this.k0(), null));
    }

    public void testGetOrDefault_absent() {
        MapGetOrDefaultTester.assertEquals((String)"getOrDefault(absent, def) should return the default value", this.v3(), this.getMap().getOrDefault(this.k3(), this.v3()));
    }

    public void testGetOrDefault_absentNullDefault() {
        MapGetOrDefaultTester.assertNull("getOrDefault(absent, null) should return null", this.getMap().getOrDefault(this.k3(), null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testGetOrDefault_absentNull() {
        MapGetOrDefaultTester.assertEquals((String)"getOrDefault(null, def) should return the default value", this.v3(), this.getMap().getOrDefault(null, this.v3()));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testGetOrDefault_nullAbsentAndUnsupported() {
        try {
            MapGetOrDefaultTester.assertEquals((String)"getOrDefault(null, def) should return default or throw", this.v3(), this.getMap().getOrDefault(null, this.v3()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetOrDefault_nonNullWhenNullContained() {
        this.initMapWithNullKey();
        MapGetOrDefaultTester.assertEquals((String)"getOrDefault(absent, default) should return default", this.v3(), this.getMap().getOrDefault(this.k3(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetOrDefault_presentNull() {
        this.initMapWithNullKey();
        MapGetOrDefaultTester.assertEquals((String)"getOrDefault(null, default) should return the associated value", this.getValueForNullKey(), this.getMap().getOrDefault(null, this.v3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetOrDefault_presentMappedToNull() {
        this.initMapWithNullValue();
        MapGetOrDefaultTester.assertNull("getOrDefault(mappedToNull, default) should return null", this.getMap().getOrDefault(this.getKeyForNullValue(), this.v3()));
    }

    public void testGet_wrongType() {
        try {
            MapGetOrDefaultTester.assertEquals((String)"getOrDefault(wrongType, default) should return default or throw", this.v3(), this.getMap().getOrDefault((Object)WrongType.VALUE, this.v3()));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

