/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import com.google.common.collect.testing.testers.TestExceptions;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class MapComputeTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testCompute_absentToPresent() {
        MapComputeTester.assertEquals((String)"Map.compute(absent, functionReturningValue) should return value", this.v3(), (Object)this.getMap().compute(this.k3(), (k, v) -> {
            MapComputeTester.assertEquals(this.k3(), (Object)k);
            MapComputeTester.assertNull((Object)v);
            return this.v3();
        }));
        this.expectAdded((Map.Entry)this.e3());
        MapComputeTester.assertEquals((int)(this.getNumElements() + 1), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testCompute_absentToAbsent() {
        MapComputeTester.assertNull("Map.compute(absent, functionReturningNull) should return null", this.getMap().compute(this.k3(), (k, v) -> {
            MapComputeTester.assertEquals(this.k3(), (Object)k);
            MapComputeTester.assertNull((Object)v);
            return null;
        }));
        this.expectUnchanged();
        MapComputeTester.assertEquals((int)this.getNumElements(), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentToPresent() {
        MapComputeTester.assertEquals((String)"Map.compute(present, functionReturningValue) should return new value", this.v3(), (Object)this.getMap().compute(this.k0(), (k, v) -> {
            MapComputeTester.assertEquals(this.k0(), (Object)k);
            MapComputeTester.assertEquals(this.v0(), (Object)v);
            return this.v3();
        }));
        this.expectReplacement(this.entry(this.k0(), this.v3()));
        MapComputeTester.assertEquals((int)this.getNumElements(), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentToAbsent() {
        MapComputeTester.assertNull("Map.compute(present, functionReturningNull) should return null", this.getMap().compute(this.k0(), (k, v) -> {
            MapComputeTester.assertEquals(this.k0(), (Object)k);
            MapComputeTester.assertEquals(this.v0(), (Object)v);
            return null;
        }));
        this.expectMissing((Map.Entry)this.e0());
        this.expectMissingKeys(this.k0());
        MapComputeTester.assertEquals((int)(this.getNumElements() - 1), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentNullToPresentNonnull() {
        this.initMapWithNullValue();
        Object value = this.getValueForNullKey();
        MapComputeTester.assertEquals((String)"Map.compute(presentMappedToNull, functionReturningValue) should return new value", value, (Object)this.getMap().compute(this.getKeyForNullValue(), (k, v) -> {
            MapComputeTester.assertEquals(this.getKeyForNullValue(), (Object)k);
            MapComputeTester.assertNull((Object)v);
            return value;
        }));
        this.expectReplacement(this.entry(this.getKeyForNullValue(), value));
        MapComputeTester.assertEquals((int)this.getNumElements(), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentNullToNull() {
        this.initMapWithNullValue();
        MapComputeTester.assertNull("Map.compute(presentMappedToNull, functionReturningNull) should return null", this.getMap().compute(this.getKeyForNullValue(), (k, v) -> {
            MapComputeTester.assertEquals(this.getKeyForNullValue(), (Object)k);
            MapComputeTester.assertNull((Object)v);
            return null;
        }));
        this.expectMissingKeys(this.getKeyForNullValue());
        MapComputeTester.assertEquals((int)(this.getNumElements() - 1), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_nullKeyPresentToPresent() {
        this.initMapWithNullKey();
        MapComputeTester.assertEquals((String)"Map.compute(present, functionReturningValue) should return new value", this.v3(), (Object)this.getMap().compute(null, (k, v) -> {
            MapComputeTester.assertNull((Object)k);
            MapComputeTester.assertEquals(this.getValueForNullKey(), (Object)v);
            return this.v3();
        }));
        MapComputeTester.assertEquals((int)this.getNumElements(), (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentFunctionThrows() {
        ReflectionFreeAssertThrows.assertThrows(TestExceptions.SomeUncheckedException.class, () -> this.getMap().compute(this.k0(), (k, v) -> {
            MapComputeTester.assertEquals(this.k0(), (Object)k);
            MapComputeTester.assertEquals(this.v0(), (Object)v);
            throw new TestExceptions.SomeUncheckedException();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testCompute_absentFunctionThrows() {
        ReflectionFreeAssertThrows.assertThrows(TestExceptions.SomeUncheckedException.class, () -> this.getMap().compute(this.k3(), (k, v) -> {
            MapComputeTester.assertEquals(this.k3(), (Object)k);
            MapComputeTester.assertNull((Object)v);
            throw new TestExceptions.SomeUncheckedException();
        }));
        this.expectUnchanged();
    }
}

