/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SpliteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import java.lang.reflect.Method;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class CollectionSpliteratorTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER})
    public void testSpliteratorUnknownOrder() {
        SpliteratorTester.of(this.collection::spliterator).expect(this.getSampleElements());
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testSpliteratorKnownOrder() {
        SpliteratorTester.of(this.collection::spliterator).expect(this.getOrderedElements()).inOrder();
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSpliteratorNullable() {
        this.initCollectionWithNullElement();
        CollectionSpliteratorTester.assertFalse((boolean)this.collection.spliterator().hasCharacteristics(256));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSpliteratorNotImmutable_collectionAllowsAdd() {
        CollectionSpliteratorTester.assertFalse((boolean)this.collection.spliterator().hasCharacteristics(1024));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSpliteratorNotImmutable_collectionAllowsRemove() {
        CollectionSpliteratorTester.assertFalse((boolean)this.collection.spliterator().hasCharacteristics(1024));
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSpliteratorNotImmutableCollectionAllowsAddMethod() {
        return Helpers.getMethod(CollectionSpliteratorTester.class, "testSpliteratorNotImmutable_collectionAllowsAdd");
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getSpliteratorNotImmutableCollectionAllowsRemoveMethod() {
        return Helpers.getMethod(CollectionSpliteratorTester.class, "testSpliteratorNotImmutable_collectionAllowsRemove");
    }
}

