/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MultimapValuesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testValues() {
        ArrayList expected = new ArrayList();
        for (Map.Entry entry : this.getSampleElements()) {
            expected.add(entry.getValue());
        }
        Helpers.assertEqualIgnoringOrder(expected, this.multimap().values());
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testValuesInOrder() {
        ArrayList expected = new ArrayList();
        for (Map.Entry entry : this.getOrderedElements()) {
            expected.add(entry.getValue());
        }
        Helpers.assertEqualInOrder(expected, this.multimap().values());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testValuesIteratorRemove() {
        Iterator valuesItr = this.multimap().values().iterator();
        valuesItr.next();
        valuesItr.remove();
        MultimapValuesTester.assertTrue((boolean)this.multimap().isEmpty());
    }
}

