/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import com.google.common.collect.testing.testers.TestExceptions;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class MapComputeIfPresentTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testComputeIfPresent_supportedAbsent() {
        MapComputeIfPresentTester.assertNull("computeIfPresent(notPresent, function) should return null", this.getMap().computeIfPresent(this.k3(), (k, v) -> {
            throw new AssertionFailedError();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfPresent_supportedPresent() {
        MapComputeIfPresentTester.assertEquals((String)"computeIfPresent(present, function) should return new value", this.v3(), (Object)this.getMap().computeIfPresent(this.k0(), (k, v) -> {
            MapComputeIfPresentTester.assertEquals(this.k0(), (Object)k);
            MapComputeIfPresentTester.assertEquals(this.v0(), (Object)v);
            return this.v3();
        }));
        this.expectReplacement(this.entry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfPresent_functionReturnsNull() {
        MapComputeIfPresentTester.assertNull("computeIfPresent(present, returnsNull) should return null", this.getMap().computeIfPresent(this.k0(), (k, v) -> {
            MapComputeIfPresentTester.assertEquals(this.k0(), (Object)k);
            MapComputeIfPresentTester.assertEquals(this.v0(), (Object)v);
            return null;
        }));
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfPresent_nullTreatedAsAbsent() {
        this.initMapWithNullValue();
        MapComputeIfPresentTester.assertNull("computeIfPresent(presentAssignedToNull, function) should return null", this.getMap().computeIfPresent(this.getKeyForNullValue(), (k, v) -> {
            throw new AssertionFailedError();
        }));
        this.expectReplacement(this.entry(this.getKeyForNullValue(), null));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfPresent_functionThrows() {
        ReflectionFreeAssertThrows.assertThrows(TestExceptions.SomeUncheckedException.class, () -> this.getMap().computeIfPresent(this.k0(), (k, v) -> {
            MapComputeIfPresentTester.assertEquals(this.k0(), (Object)k);
            MapComputeIfPresentTester.assertEquals(this.v0(), (Object)v);
            throw new TestExceptions.SomeUncheckedException();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfPresent_nullKeySupportedPresent() {
        this.initMapWithNullKey();
        MapComputeIfPresentTester.assertEquals((String)"computeIfPresent(null, function) should return new value", this.v3(), (Object)this.getMap().computeIfPresent(null, (k, v) -> {
            MapComputeIfPresentTester.assertNull((Object)k);
            MapComputeIfPresentTester.assertEquals(this.getValueForNullKey(), (Object)v);
            return this.v3();
        }));
        Map.Entry<K, V>[] expected = this.createArrayWithNullKey();
        expected[this.getNullLocation()] = this.entry(null, this.v3());
        this.expectContents(expected);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testComputeIfPresent_nullKeySupportedAbsent() {
        MapComputeIfPresentTester.assertNull("computeIfPresent(null, function) should return null", this.getMap().computeIfPresent(null, (k, v) -> {
            throw new AssertionFailedError();
        }));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testComputeIfPresent_unsupportedAbsent() {
        try {
            this.getMap().computeIfPresent(this.k3(), (k, v) -> {
                throw new AssertionFailedError();
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testComputeIfPresent_unsupportedPresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().computeIfPresent(this.k0(), (k, v) -> this.v3()));
        this.expectUnchanged();
    }
}

