/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.IgnoreJRERequirement;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
@IgnoreJRERequirement
public class CollectionRemoveIfTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testRemoveIf_alwaysFalse() {
        CollectionRemoveIfTester.assertFalse((String)"removeIf(x -> false) should return false", (boolean)this.collection.removeIf(x -> false));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveIf_sometimesTrue() {
        CollectionRemoveIfTester.assertTrue((String)"removeIf(isEqual(present)) should return true", (boolean)this.collection.removeIf(Predicate.isEqual(this.samples.e0())));
        this.expectMissing(this.samples.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveIf_allPresent() {
        CollectionRemoveIfTester.assertTrue((String)"removeIf(x -> true) should return true", (boolean)this.collection.removeIf(x -> true));
        this.expectContents(new Object[0]);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveIfSomeMatchesConcurrentWithIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.collection.iterator();
            CollectionRemoveIfTester.assertTrue((boolean)this.collection.removeIf(Predicate.isEqual(this.samples.e0())));
            iterator.next();
        });
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testRemoveIf_unsupportedEmptyCollection() {
        try {
            CollectionRemoveIfTester.assertFalse((String)"removeIf(Predicate) should return false or throw UnsupportedOperationException", (boolean)this.collection.removeIf(x -> {
                throw new AssertionError((Object)"predicate should never be called");
            }));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemoveIf_alwaysTrueUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.collection.removeIf(x -> true));
        this.expectUnchanged();
        CollectionRemoveIfTester.assertTrue((boolean)this.collection.contains(this.samples.e0()));
    }
}

