/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestSetGenerator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GwtCompatible
public abstract class TestMapEntrySetGenerator<K, V>
implements TestSetGenerator<Map.Entry<K, V>> {
    private final SampleElements<K> keys;
    private final SampleElements<V> values;

    protected TestMapEntrySetGenerator(SampleElements<K> keys, SampleElements<V> values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public SampleElements<Map.Entry<K, V>> samples() {
        return SampleElements.mapEntries(this.keys, this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> create(Object ... elements) {
        Map.Entry<K, V>[] entries = this.createArray(elements.length);
        System.arraycopy(elements, 0, entries, 0, elements.length);
        return this.createFromEntries(entries);
    }

    public abstract Set<Map.Entry<K, V>> createFromEntries(Map.Entry<K, V>[] var1);

    public Map.Entry<K, V>[] createArray(int length) {
        return new Map.Entry[length];
    }

    @Override
    public List<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
        return insertionOrder;
    }
}

