/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible(emulated=true)
public class SetHashCodeTester<E>
extends AbstractSetTester<E> {
    public void testHashCode() {
        int expectedHashCode = 0;
        for (Object element : this.getSampleElements()) {
            expectedHashCode += element == null ? 0 : element.hashCode();
        }
        SetHashCodeTester.assertEquals((String)"A Set's hashCode() should be the sum of those of its elements.", (int)expectedHashCode, (int)this.getSet().hashCode());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testHashCode_containingNull() {
        Collection elements = this.getSampleElements(this.getNumElements() - 1);
        int expectedHashCode = 0;
        for (Object element : elements) {
            expectedHashCode += element == null ? 0 : element.hashCode();
        }
        elements.add(null);
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(elements.toArray());
        SetHashCodeTester.assertEquals((String)"A Set's hashCode() should be the sum of those of its elements (with a null element counting as having a hash of zero).", (int)expectedHashCode, (int)this.getSet().hashCode());
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method[] getHashCodeMethods() {
        return new Method[]{Helpers.getMethod(SetHashCodeTester.class, "testHashCode"), Helpers.getMethod(SetHashCodeTester.class, "testHashCode_containingNull")};
    }
}

