/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MapReplaceTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_supportedPresent() {
        try {
            MapReplaceTester.assertEquals(this.v0(), this.getMap().replace(this.k0(), this.v3()));
            this.expectReplacement(this.entry(this.k0(), this.v3()));
        }
        catch (ClassCastException tolerated) {
            this.expectUnchanged();
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_supportedPresentNoChange() {
        MapReplaceTester.assertEquals(this.v0(), this.getMap().replace(this.k0(), this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testReplace_supportedAbsent() {
        MapReplaceTester.assertNull(this.getMap().replace(this.k3(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_presentNullValueUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getMap().replace(this.k0(), null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testReplace_absentNullValueUnsupported() {
        try {
            this.getMap().replace(this.k3(), null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testReplace_absentNullKeyUnsupported() {
        try {
            this.getMap().replace(null, this.v3());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_unsupportedPresent() {
        try {
            this.getMap().replace(this.k0(), this.v3());
            MapReplaceTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

