/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public class MapPutAllTester<K, V>
extends AbstractMapTester<K, V> {
    private List<Map.Entry<K, V>> containsNullKey;
    private List<Map.Entry<K, V>> containsNullValue;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.containsNullKey = Collections.singletonList(this.entry(null, this.v3()));
        this.containsNullValue = Collections.singletonList(this.entry(this.k3(), null));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll_supportedNothing() {
        this.getMap().putAll(Collections.emptyMap());
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutAll_unsupportedNothing() {
        try {
            this.getMap().putAll(Collections.emptyMap());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll_supportedNonePresent() {
        this.putAll(this.createDisjointCollection());
        this.expectAdded((Map.Entry)this.e3(), (Map.Entry)this.e4());
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutAll_unsupportedNonePresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.putAll(this.createDisjointCollection()));
        this.expectUnchanged();
        this.expectMissing((Map.Entry)this.e3(), (Map.Entry)this.e4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAll_supportedSomePresent() {
        this.putAll(MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e0()));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAllSomePresentConcurrentWithEntrySetIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.getMap().entrySet().iterator();
            this.putAll(MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e0()));
            iterator.next();
        });
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAll_unsupportedSomePresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.putAll(MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e0())));
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAll_unsupportedAllPresent() {
        try {
            this.putAll(MinimalCollection.of((Map.Entry)this.e0()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAll_nullKeySupported() {
        this.putAll(this.containsNullKey);
        this.expectAdded(this.containsNullKey.get(0));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAll_nullKeyUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.putAll(this.containsNullKey));
        this.expectUnchanged();
        this.expectNullKeyMissingWhenNullKeysUnsupported("Should not contain null key after unsupported putAll(containsNullKey)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAll_nullValueSupported() {
        this.putAll(this.containsNullValue);
        this.expectAdded(this.containsNullValue.get(0));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAll_nullValueUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.putAll(this.containsNullValue));
        this.expectUnchanged();
        this.expectNullValueMissingWhenNullValuesUnsupported("Should not contain null value after unsupported putAll(containsNullValue)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll_nullCollectionReference() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getMap().putAll(null));
    }

    private void putAll(Iterable<Map.Entry<K, V>> entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        this.getMap().putAll(map);
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static Method getPutAllNullKeyUnsupportedMethod() {
        return Helpers.getMethod(MapPutAllTester.class, "testPutAll_nullKeyUnsupported");
    }
}

