/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MultimapContainsValueTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsValueYes() {
        MultimapContainsValueTester.assertTrue((boolean)this.multimap().containsValue(this.v0()));
    }

    public void testContainsValueNo() {
        MultimapContainsValueTester.assertFalse((boolean)this.multimap().containsValue(this.v3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsNullValueYes() {
        this.initMultimapWithNullValue();
        MultimapContainsValueTester.assertTrue((boolean)this.multimap().containsValue(null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsNullValueNo() {
        MultimapContainsValueTester.assertFalse((boolean)this.multimap().containsValue(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsNullValueFails() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().containsValue(null));
    }
}

