/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.ListListIteratorTester;
import com.google.common.collect.testing.testers.ListSubListTester;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtIncompatible
public class TestsForListsInJavaUtil {
    public static Test suite() {
        return new TestsForListsInJavaUtil().allTests();
    }

    public Test allTests() {
        TestSuite suite = new TestSuite("java.util Lists");
        suite.addTest(this.testsForEmptyList());
        suite.addTest(this.testsForSingletonList());
        suite.addTest(this.testsForArraysAsList());
        suite.addTest(this.testsForArrayList());
        suite.addTest(this.testsForLinkedList());
        suite.addTest(this.testsForCopyOnWriteArrayList());
        suite.addTest(this.testsForUnmodifiableList());
        suite.addTest(this.testsForCheckedList());
        suite.addTest(this.testsForAbstractList());
        suite.addTest(this.testsForAbstractSequentialList());
        suite.addTest(this.testsForVector());
        return suite;
    }

    protected Collection<Method> suppressForEmptyList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForSingletonList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForArraysAsList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForArrayList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForLinkedList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForCopyOnWriteArrayList() {
        return Arrays.asList(ListSubListTester.getSubListOriginalListSetAffectsSubListMethod(), ListSubListTester.getSubListOriginalListSetAffectsSubListLargeListMethod(), ListSubListTester.getSubListSubListRemoveAffectsOriginalLargeListMethod(), ListListIteratorTester.getListIteratorFullyModifiableMethod());
    }

    protected Collection<Method> suppressForUnmodifiableList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForCheckedList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForAbstractList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForAbstractSequentialList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForVector() {
        return Collections.emptySet();
    }

    public Test testsForEmptyList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                return Collections.emptyList();
            }
        }).named("emptyList")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionSize.ZERO)).suppressing(this.suppressForEmptyList())).createTestSuite();
    }

    public Test testsForSingletonList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                return Collections.singletonList(elements[0]);
            }
        }).named("singletonList")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ONE)).suppressing(this.suppressForSingletonList())).createTestSuite();
    }

    public Test testsForArraysAsList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                return Arrays.asList((Object[])elements.clone());
            }
        }).named("Arrays.asList")).withFeatures(ListFeature.SUPPORTS_SET, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForArraysAsList())).createTestSuite();
    }

    public Test testsForArrayList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                return new ArrayList<String>(MinimalCollection.of(elements));
            }
        }).named("ArrayList")).withFeatures(ListFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionSize.ANY)).suppressing(this.suppressForArrayList())).createTestSuite();
    }

    public Test testsForLinkedList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                return new LinkedList<String>(MinimalCollection.of(elements));
            }
        }).named("LinkedList")).withFeatures(ListFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionSize.ANY)).suppressing(this.suppressForLinkedList())).createTestSuite();
    }

    public Test testsForCopyOnWriteArrayList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                return new CopyOnWriteArrayList<String>(MinimalCollection.of(elements));
            }
        }).named("CopyOnWriteArrayList")).withFeatures(ListFeature.SUPPORTS_ADD_WITH_INDEX, ListFeature.SUPPORTS_REMOVE_WITH_INDEX, ListFeature.SUPPORTS_SET, CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForCopyOnWriteArrayList())).createTestSuite();
    }

    public Test testsForUnmodifiableList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                ArrayList innerList = new ArrayList();
                Collections.addAll(innerList, elements);
                return Collections.unmodifiableList(innerList);
            }
        }).named("unmodifiableList/ArrayList")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForUnmodifiableList())).createTestSuite();
    }

    public Test testsForCheckedList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            public List<String> create(String[] elements) {
                ArrayList innerList = new ArrayList();
                Collections.addAll(innerList, elements);
                return Collections.checkedList(innerList, String.class);
            }
        }).named("checkedList/ArrayList")).withFeatures(ListFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE, CollectionFeature.RESTRICTS_ELEMENTS, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForCheckedList())).createTestSuite();
    }

    public Test testsForAbstractList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            protected List<String> create(final String[] elements) {
                return new AbstractList<String>(this){

                    @Override
                    public int size() {
                        return elements.length;
                    }

                    @Override
                    public String get(int index) {
                        return elements[index];
                    }
                };
            }
        }).named("AbstractList")).withFeatures(CollectionFeature.NONE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForAbstractList())).createTestSuite();
    }

    public Test testsForAbstractSequentialList() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            protected List<String> create(String[] elements) {
                final ArrayList list = new ArrayList();
                Collections.addAll(list, elements);
                return new AbstractSequentialList<String>(this){

                    @Override
                    public int size() {
                        return list.size();
                    }

                    @Override
                    public ListIterator<String> listIterator(int index) {
                        return list.listIterator(index);
                    }
                };
            }
        }).named("AbstractSequentialList")).withFeatures(ListFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY)).suppressing(this.suppressForAbstractSequentialList())).createTestSuite();
    }

    private Test testsForVector() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new TestStringListGenerator(this){

            @Override
            protected List<String> create(String[] elements) {
                return new Vector<String>(MinimalCollection.of(elements));
            }
        }).named("Vector")).withFeatures(ListFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).createTestSuite();
    }
}

