/*
 * Decompiled with CFR 0.152.
 */
package com.google.gradle.osdetector;

import java.util.Properties;
import kr.motd.maven.os.Detector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsDetector {
    private static final Logger logger = LoggerFactory.getLogger((String)OsDetector.class.getName());
    private static final Impl impl = new Impl();

    static String os() {
        return (String)OsDetector.impl.detectedProperties.get("os.detected.name");
    }

    static String arch() {
        return (String)OsDetector.impl.detectedProperties.get("os.detected.arch");
    }

    static String classifier() {
        return (String)OsDetector.impl.detectedProperties.get("os.detected.classifier");
    }

    private static class Impl
    extends Detector {
        final Properties detectedProperties = System.getProperties();

        protected void log(String message) {
            logger.info(message);
        }

        protected void logProperty(String name, String value) {
            String string = String.valueOf(String.valueOf(name));
            String string2 = String.valueOf(String.valueOf(value));
            logger.info(new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString());
        }

        Impl() {
            this.detect(this.detectedProperties);
        }
    }
}

