/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.jspecify.annotations.Nullable;

class Trees {
    private static final @Nullable Class<?> END_POS_TABLE_CLASS = Trees.getEndPosTableClass();
    private static final MethodHandle NEW_PARSER_HANDLE = Trees.getNewParserHandle();
    private static final MethodHandle GET_END_POS_HANDLE = Trees.getEndPosMethodHandle();

    Trees() {
    }

    static int getLength(Tree tree, TreePath path) {
        return Trees.getEndPosition(tree, path) - Trees.getStartPosition(tree);
    }

    static int getStartPosition(Tree expression) {
        return ((JCTree)expression).getStartPosition();
    }

    static int getEndPosition(Tree expression, TreePath path) {
        return Trees.getEndPosition(expression, path.getCompilationUnit());
    }

    public static int getEndPosition(Tree tree, CompilationUnitTree unit) {
        try {
            return GET_END_POS_HANDLE.invokeExact((JCTree)tree, (JCTree.JCCompilationUnit)unit);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    static String getSourceForNode(Tree node, TreePath path) {
        CharSequence source;
        try {
            source = path.getCompilationUnit().getSourceFile().getCharContent(false);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return source.subSequence(Trees.getStartPosition(node), Trees.getEndPosition(node, path)).toString();
    }

    static Name getMethodName(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        return select instanceof MemberSelectTree ? ((MemberSelectTree)select).getIdentifier() : ((IdentifierTree)select).getName();
    }

    static ExpressionTree getMethodReceiver(MethodInvocationTree methodInvocation) {
        ExpressionTree select = methodInvocation.getMethodSelect();
        return select instanceof MemberSelectTree ? ((MemberSelectTree)select).getExpression() : null;
    }

    static String operatorName(ExpressionTree expression) {
        JCTree.Tag tag = ((JCTree)((Object)expression)).getTag();
        if (tag == JCTree.Tag.ASSIGN) {
            return "=";
        }
        boolean assignOp = expression instanceof CompoundAssignmentTree;
        if (assignOp) {
            tag = tag.noAssignOp();
        }
        String name = new Pretty(null, true).operatorName(tag);
        return assignOp ? name + "=" : name;
    }

    static int precedence(ExpressionTree expression) {
        return TreeInfo.opPrec(((JCTree)((Object)expression)).getTag());
    }

    static ClassTree getEnclosingTypeDeclaration(TreePath path) {
        while (path != null) {
            switch (path.getLeaf().getKind()) {
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATED_TYPE: {
                    return (ClassTree)path.getLeaf();
                }
            }
            path = path.getParentPath();
        }
        throw new AssertionError();
    }

    static ExpressionTree skipParen(ExpressionTree node) {
        return ((ParenthesizedTree)node).getExpression();
    }

    static JCTree.JCCompilationUnit parse(Context context, List<Diagnostic<? extends JavaFileObject>> errorDiagnostics, boolean allowStringFolding, final String javaInput) {
        JavacParser parser;
        DiagnosticListener diagnostics = diagnostic -> {
            if (Trees.errorDiagnostic(diagnostic)) {
                errorDiagnostics.add(diagnostic);
            }
        };
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("--enable-preview", "true");
        Options.instance(context).put("allowStringFolding", Boolean.toString(allowStringFolding));
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, (Iterable<? extends File>)ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public String getCharContent(boolean ignoreEncodingErrors) {
                return javaInput;
            }
        };
        Log.instance(context).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context);
        try {
            parser = NEW_PARSER_HANDLE.invokeExact(parserFactory, javaInput, true, true, true);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new AssertionError((Object)e);
        }
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        return unit;
    }

    private static boolean errorDiagnostic(Diagnostic<?> input) {
        if (input.getKind() != Diagnostic.Kind.ERROR) {
            return false;
        }
        return !input.getCode().equals("compiler.err.invalid.meth.decl.ret.type.req");
    }

    private static @Nullable Class<?> getEndPosTableClass() {
        try {
            return Class.forName("com.sun.tools.javac.tree.EndPosTable");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static MethodHandle getNewParserHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (END_POS_TABLE_CLASS == null) {
            try {
                return MethodHandles.dropArguments(lookup.findVirtual(ParserFactory.class, "newParser", MethodType.methodType(JavacParser.class, CharSequence.class, Boolean.TYPE, Boolean.TYPE)), 3, new Class[]{Boolean.TYPE});
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
        try {
            return lookup.findVirtual(ParserFactory.class, "newParser", MethodType.methodType(JavacParser.class, CharSequence.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static MethodHandle getEndPosMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (END_POS_TABLE_CLASS == null) {
            try {
                return MethodHandles.dropArguments(lookup.findVirtual(JCTree.class, "getEndPosition", MethodType.methodType(Integer.TYPE)), 1, new Class[]{JCTree.JCCompilationUnit.class});
            }
            catch (ReflectiveOperationException e1) {
                throw new LinkageError(e1.getMessage(), e1);
            }
        }
        try {
            return MethodHandles.filterArguments(lookup.findVirtual(JCTree.class, "getEndPosition", MethodType.methodType(Integer.TYPE, END_POS_TABLE_CLASS)), 1, lookup.findVarHandle(JCTree.JCCompilationUnit.class, "endPositions", END_POS_TABLE_CLASS).toMethodHandle(VarHandle.AccessMode.GET));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

