/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.ModifierOrderer;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.Replacement;
import com.google.googlejavaformat.java.StringWrapper;
import com.google.googlejavaformat.java.Trees;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@Immutable
public final class Formatter {
    public static final int MAX_LINE_LENGTH = 100;
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    private final JavaFormatterOptions options;

    public Formatter() {
        this(JavaFormatterOptions.defaultOptions());
    }

    public Formatter(JavaFormatterOptions options) {
        this.options = options;
    }

    static void format(JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options) throws FormatterException {
        Context context = new Context();
        ArrayList<Diagnostic<? extends JavaFileObject>> errorDiagnostics = new ArrayList<Diagnostic<? extends JavaFileObject>>();
        JCTree.JCCompilationUnit unit = Trees.parse(context, errorDiagnostics, false, javaInput.getText());
        javaInput.setCompilationUnit(unit);
        if (!errorDiagnostics.isEmpty()) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput);
        JavaInputAstVisitor visitor = new JavaInputAstVisitor(builder, options.indentationMultiplier());
        visitor.scan((Tree)unit, null);
        builder.sync(javaInput.getText().length());
        builder.drain();
        Doc doc = new DocBuilder().withOps((List<Op>)builder.build()).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), 100, new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
    }

    static boolean errorDiagnostic(Diagnostic<?> input) {
        if (input.getKind() != Diagnostic.Kind.ERROR) {
            return false;
        }
        return !input.getCode().equals("compiler.err.invalid.meth.decl.ret.type.req");
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write((CharSequence)this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        return this.formatSource(input, (Collection<Range<Integer>>)ImmutableList.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(input.length()))));
    }

    public String formatSourceAndFixImports(String input) throws FormatterException {
        input = ImportOrderer.reorderImports(input, this.options.style());
        input = RemoveUnusedImports.removeUnusedImports(input);
        String formatted = this.formatSource(input);
        formatted = StringWrapper.wrap(formatted, this);
        return formatted;
    }

    public String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        return JavaOutput.applyReplacements(input, this.getFormatReplacements(input, characterRanges));
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput(input);
        if (this.options.reorderModifiers()) {
            javaInput = ModifierOrderer.reorderModifiers(javaInput, characterRanges);
        }
        String lineSeparator = Newlines.guessLineSeparator(input);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, javaInput, new JavaCommentsHelper(lineSeparator, this.options));
        try {
            Formatter.format(javaInput, javaOutput, this.options);
        }
        catch (FormattingError e) {
            throw new FormatterException((Iterable<FormatterDiagnostic>)e.diagnostics());
        }
        RangeSet<Integer> tokenRangeSet = javaInput.characterRangesToTokenRanges(characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }

    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, Newlines.lineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet characterRanges = TreeRangeSet.create();
        for (Range lineRange : lineRanges.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lines.size() - 1))).asRanges()) {
            int lineStart = (Integer)lines.get((Integer)lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get((Integer)lineRange.upperEndpoint()) - 1;
            Range range = Range.closedOpen((Comparable)Integer.valueOf(lineStart), (Comparable)Integer.valueOf(lineEnd));
            characterRanges.add(range);
        }
        return characterRanges;
    }
}

