/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.annotations.GwtCompatible;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2Point;

@GwtCompatible
public strictfp enum S2Projections {
    S2_LINEAR_PROJECTION(4.0 / (3.0 * Math.sqrt(3.0)), 4.0, 1.0, 2.0, Math.sqrt(0.6666666666666666), 1.4114593458444569, 2.0 * Math.sqrt(2.0) / 3.0, 1.4400341929556038, 2.0 * Math.sqrt(2.0) / 3.0, 2.0 * Math.sqrt(2.0), 2.0318178664188125, Math.sqrt(2.0)){

        @Override
        public double stToUV(double s) {
            return 2.0 * s - 1.0;
        }

        @Override
        public double uvToST(double u) {
            return 0.5 * (u + 1.0);
        }
    }
    ,
    S2_TAN_PROJECTION(Math.PI * Math.PI / (4.0 * Math.sqrt(2.0)), 2.4674011002723395, 1.5707963267948966, 1.5707963267948966, Math.PI / (2.0 * Math.sqrt(2.0)), 1.4373186389251609, Math.PI / (2.0 * Math.sqrt(2.0)), 1.4616670325467394, Math.PI * Math.sqrt(2.0) / 3.0, Math.PI * Math.sqrt(0.6666666666666666), 2.0636231971956356, Math.sqrt(2.0)){

        @Override
        public double stToUV(double s) {
            s = Math.tan(1.5707963267948966 * s - 0.7853981633974483);
            return s + (double)1.110223E-16f * s;
        }

        @Override
        public double uvToST(double u) {
            return 0.6366197723675814 * (Math.atan(u) + 0.7853981633974483);
        }
    }
    ,
    S2_QUADRATIC_PROJECTION(8.0 * Math.sqrt(2.0) / 9.0, 2.6357992569631614, 1.3333333333333333, 1.7048971791992185, 2.0 * Math.sqrt(2.0) / 3.0, 1.4345236728860995, 2.0 * Math.sqrt(2.0) / 3.0, 1.4592137463861061, 8.0 * Math.sqrt(2.0) / 9.0, 2.438654594434021, 2.0604227389984717, 1.442615274452683){

        @Override
        public double stToUV(double s) {
            if (s >= 0.5) {
                return 0.3333333333333333 * (4.0 * s * s - 1.0);
            }
            return 0.3333333333333333 * (1.0 - 4.0 * (1.0 - s) * (1.0 - s));
        }

        @Override
        public double uvToST(double u) {
            if (u >= 0.0) {
                return 0.5 * Math.sqrt(1.0 + 3.0 * u);
            }
            return 1.0 - 0.5 * Math.sqrt(1.0 - 3.0 * u);
        }
    };

    public static final long MAX_SITI = 0x80000000L;
    private static final S2Point[][] FACE_UVW_AXES;
    private static final int[][][] FACE_UVW_FACES;
    private static final UvTransform[] UV_TRANSFORMS;
    private static final XyzTransform[] XYZ_TRANSFORMS;
    public final S2.Metric minArea;
    public final S2.Metric maxArea;
    public final S2.Metric avgArea;
    public final S2.Metric minAngleSpan;
    public final S2.Metric maxAngleSpan;
    public final S2.Metric avgAngleSpan;
    public final S2.Metric minWidth;
    public final S2.Metric maxWidth;
    public final S2.Metric avgWidth;
    public final S2.Metric minEdge;
    public final S2.Metric maxEdge;
    public final S2.Metric avgEdge;
    public final S2.Metric minDiag;
    public final S2.Metric maxDiag;
    public final S2.Metric avgDiag;
    public final double maxEdgeAspect;
    public final double maxDiagAspect = Math.sqrt(3.0);
    public static final S2Projections PROJ;

    private S2Projections(double minAreaDeriv, double maxAreaDeriv, double minAngleSpanDeriv, double maxAngleSpanDeriv, double minWidthDeriv, double avgWidthDeriv, double minEdgeDeriv, double avgEdgeDeriv, double minDiagDeriv, double maxDiagDeriv, double avgDiagDeriv, double maxEdgeAspect) {
        this.minArea = new S2.Metric(2, minAreaDeriv);
        this.maxArea = new S2.Metric(2, maxAreaDeriv);
        this.avgArea = new S2.Metric(2, 2.0943951023931953);
        this.minAngleSpan = new S2.Metric(1, minAngleSpanDeriv);
        this.maxAngleSpan = new S2.Metric(1, maxAngleSpanDeriv);
        this.avgAngleSpan = new S2.Metric(1, 1.5707963267948966);
        this.minWidth = new S2.Metric(1, minWidthDeriv);
        this.maxWidth = new S2.Metric(1, maxAngleSpanDeriv);
        this.avgWidth = new S2.Metric(1, avgWidthDeriv);
        this.minEdge = new S2.Metric(1, minEdgeDeriv);
        this.maxEdge = new S2.Metric(1, maxAngleSpanDeriv);
        this.avgEdge = new S2.Metric(1, avgEdgeDeriv);
        this.minDiag = new S2.Metric(1, minDiagDeriv);
        this.maxDiag = new S2.Metric(1, maxDiagDeriv);
        this.avgDiag = new S2.Metric(1, avgDiagDeriv);
        this.maxEdgeAspect = maxEdgeAspect;
    }

    public abstract double stToUV(double var1);

    public static int stToIj(double s) {
        return Math.max(0, Math.min(0x3FFFFFFF, (int)Math.round(1.073741824E9 * s - 0.5)));
    }

    public static double ijToStMin(int i) {
        return 9.313225746154785E-10 * (double)i;
    }

    public double ijToUV(int ij, int cellSize) {
        return this.stToUV(S2Projections.ijToStMin(ij & -cellSize));
    }

    public static double siTiToSt(long si) {
        return 4.656612873077393E-10 * (double)si;
    }

    public static long stToSiTi(double s) {
        return Math.round(s * 2.147483648E9);
    }

    public abstract double uvToST(double var1);

    public static S2Point faceUvToXyz(int face, double u, double v) {
        XyzTransform t = S2Projections.faceToXyzTransform(face);
        return new S2Point(t.uvToX(u, v), t.uvToY(u, v), t.uvToZ(u, v));
    }

    public static S2Point faceUvToXyz(int face, R2Vector uv) {
        return S2Projections.faceUvToXyz(face, uv.x(), uv.y());
    }

    static XyzTransform faceToXyzTransform(int face) {
        return XYZ_TRANSFORMS[Math.min(5, face)];
    }

    public static R2Vector faceXyzToUv(int face, S2Point p) {
        if (face < 3 ? p.get(face) <= 0.0 : p.get(face - 3) >= 0.0) {
            return null;
        }
        return S2Projections.validFaceXyzToUv(face, p);
    }

    public static R2Vector validFaceXyzToUv(int face, S2Point p) {
        R2Vector result = new R2Vector();
        S2Projections.validFaceXyzToUv(face, p, result);
        return result;
    }

    static void validFaceXyzToUv(int face, S2Point p, R2Vector result) {
        UvTransform t = S2Projections.faceToUvTransform(face);
        result.set(t.xyzToU(p.x, p.y, p.z), t.xyzToV(p.x, p.y, p.z));
    }

    public static UvTransform faceToUvTransform(int face) {
        return UV_TRANSFORMS[face];
    }

    public static S2Point faceXyzToUvw(int face, S2Point p) {
        switch (face) {
            case 0: {
                return new S2Point(p.y, p.z, p.x);
            }
            case 1: {
                return new S2Point(-p.x, p.z, p.y);
            }
            case 2: {
                return new S2Point(-p.x, -p.y, p.z);
            }
            case 3: {
                return new S2Point(-p.z, -p.y, -p.x);
            }
            case 4: {
                return new S2Point(-p.z, p.x, -p.y);
            }
        }
        return new S2Point(p.y, p.x, -p.z);
    }

    private static final int siTiToLevel(long siTi) {
        return 30 - Long.numberOfTrailingZeros(siTi | 0x80000000L);
    }

    public S2Point faceSiTiToXyz(int face, long si, long ti) {
        double u = this.stToUV(S2Projections.siTiToSt(si));
        double v = this.stToUV(S2Projections.siTiToSt(ti));
        return S2Projections.faceUvToXyz(face, u, v);
    }

    FaceSiTi xyzToFaceSiTi(S2Point p) {
        int face = S2Projections.xyzToFace(p);
        R2Vector uv = S2Projections.validFaceXyzToUv(face, p);
        long si = S2Projections.stToSiTi(this.uvToST(uv.x()));
        long ti = S2Projections.stToSiTi(this.uvToST(uv.y()));
        return new FaceSiTi(face, si, ti);
    }

    int levelIfCenter(FaceSiTi fst, S2Point p) {
        int level = S2Projections.siTiToLevel(fst.si);
        if (level < 0 || level != S2Projections.siTiToLevel(fst.ti)) {
            return -1;
        }
        S2Point center = S2Point.normalize(this.faceSiTiToXyz(fst.face, fst.si, fst.ti));
        if (p.equals(center)) {
            return level;
        }
        return -1;
    }

    public static int xyzToFace(S2Point p) {
        return S2Projections.xyzToFace(p.x, p.y, p.z);
    }

    static int xyzToFace(double x, double y, double z) {
        switch (S2Point.largestAbsComponent(x, y, z)) {
            case 0: {
                return x < 0.0 ? 3 : 0;
            }
            case 1: {
                return y < 0.0 ? 4 : 1;
            }
        }
        return z < 0.0 ? 5 : 2;
    }

    public static S2Point getUNorm(int face, double u) {
        switch (face) {
            case 0: {
                return new S2Point(u, -1.0, 0.0);
            }
            case 1: {
                return new S2Point(1.0, u, 0.0);
            }
            case 2: {
                return new S2Point(1.0, 0.0, u);
            }
            case 3: {
                return new S2Point(-u, 0.0, 1.0);
            }
            case 4: {
                return new S2Point(0.0, -u, 1.0);
            }
        }
        return new S2Point(0.0, -1.0, -u);
    }

    public static S2Point getVNorm(int face, double v) {
        switch (face) {
            case 0: {
                return new S2Point(-v, 0.0, 1.0);
            }
            case 1: {
                return new S2Point(0.0, -v, 1.0);
            }
            case 2: {
                return new S2Point(0.0, -1.0, -v);
            }
            case 3: {
                return new S2Point(v, -1.0, 0.0);
            }
            case 4: {
                return new S2Point(1.0, v, 0.0);
            }
        }
        return new S2Point(1.0, 0.0, v);
    }

    public static S2Point getUAxis(int face) {
        return S2Projections.getUVWAxis(face, 0);
    }

    public static S2Point getVAxis(int face) {
        return S2Projections.getUVWAxis(face, 1);
    }

    public static S2Point getNorm(int face) {
        return S2Projections.getUVWAxis(face, 2);
    }

    static S2Point getUVWAxis(int face, int axis) {
        return FACE_UVW_AXES[face][axis];
    }

    static int getUVWFace(int face, int axis, int direction) {
        return FACE_UVW_FACES[face][axis][direction];
    }

    static {
        FACE_UVW_AXES = new S2Point[][]{{S2Point.Y_POS, S2Point.Z_POS, S2Point.X_POS}, {S2Point.X_NEG, S2Point.Z_POS, S2Point.Y_POS}, {S2Point.X_NEG, S2Point.Y_NEG, S2Point.Z_POS}, {S2Point.Z_NEG, S2Point.Y_NEG, S2Point.X_NEG}, {S2Point.Z_NEG, S2Point.X_POS, S2Point.Y_NEG}, {S2Point.Y_POS, S2Point.X_POS, S2Point.Z_NEG}};
        FACE_UVW_FACES = new int[][][]{new int[][]{{4, 1}, {5, 2}, {3, 0}}, new int[][]{{0, 3}, {5, 2}, {4, 1}}, new int[][]{{0, 3}, {1, 4}, {5, 2}}, new int[][]{{2, 5}, {1, 4}, {0, 3}}, new int[][]{{2, 5}, {3, 0}, {1, 4}}, new int[][]{{4, 1}, {3, 0}, {2, 5}}};
        UV_TRANSFORMS = new UvTransform[]{new UvTransform(){

            @Override
            public double xyzToU(double x, double y, double z) {
                return y / x;
            }

            @Override
            public double xyzToV(double x, double y, double z) {
                return z / x;
            }
        }, new UvTransform(){

            @Override
            public double xyzToU(double x, double y, double z) {
                return -x / y;
            }

            @Override
            public double xyzToV(double x, double y, double z) {
                return z / y;
            }
        }, new UvTransform(){

            @Override
            public double xyzToU(double x, double y, double z) {
                return -x / z;
            }

            @Override
            public double xyzToV(double x, double y, double z) {
                return -y / z;
            }
        }, new UvTransform(){

            @Override
            public double xyzToU(double x, double y, double z) {
                return z / x;
            }

            @Override
            public double xyzToV(double x, double y, double z) {
                return y / x;
            }
        }, new UvTransform(){

            @Override
            public double xyzToU(double x, double y, double z) {
                return z / y;
            }

            @Override
            public double xyzToV(double x, double y, double z) {
                return -x / y;
            }
        }, new UvTransform(){

            @Override
            public double xyzToU(double x, double y, double z) {
                return -y / z;
            }

            @Override
            public double xyzToV(double x, double y, double z) {
                return -x / z;
            }
        }};
        XYZ_TRANSFORMS = new XyzTransform[]{new XyzTransform(){

            @Override
            public double uvToX(double u, double v) {
                return 1.0;
            }

            @Override
            public double uvToY(double u, double v) {
                return u;
            }

            @Override
            public double uvToZ(double u, double v) {
                return v;
            }
        }, new XyzTransform(){

            @Override
            public double uvToX(double u, double v) {
                return -u;
            }

            @Override
            public double uvToY(double u, double v) {
                return 1.0;
            }

            @Override
            public double uvToZ(double u, double v) {
                return v;
            }
        }, new XyzTransform(){

            @Override
            public double uvToX(double u, double v) {
                return -u;
            }

            @Override
            public double uvToY(double u, double v) {
                return -v;
            }

            @Override
            public double uvToZ(double u, double v) {
                return 1.0;
            }
        }, new XyzTransform(){

            @Override
            public double uvToX(double u, double v) {
                return -1.0;
            }

            @Override
            public double uvToY(double u, double v) {
                return -v;
            }

            @Override
            public double uvToZ(double u, double v) {
                return -u;
            }
        }, new XyzTransform(){

            @Override
            public double uvToX(double u, double v) {
                return v;
            }

            @Override
            public double uvToY(double u, double v) {
                return -1.0;
            }

            @Override
            public double uvToZ(double u, double v) {
                return -u;
            }
        }, new XyzTransform(){

            @Override
            public double uvToX(double u, double v) {
                return v;
            }

            @Override
            public double uvToY(double u, double v) {
                return u;
            }

            @Override
            public double uvToZ(double u, double v) {
                return -1.0;
            }
        }};
        PROJ = S2_QUADRATIC_PROJECTION;
    }

    strictfp static final class FaceSiTi {
        public final int face;
        public final long si;
        public final long ti;

        FaceSiTi(int face, long si, long ti) {
            this.face = face;
            this.si = si;
            this.ti = ti;
        }
    }

    static interface XyzTransform {
        public double uvToX(double var1, double var3);

        public double uvToY(double var1, double var3);

        public double uvToZ(double var1, double var3);
    }

    public strictfp static abstract class UvTransform {
        private UvTransform() {
        }

        public abstract double xyzToU(double var1, double var3, double var5);

        public final double xyzToU(S2Point p) {
            return this.xyzToU(p.x, p.y, p.z);
        }

        public abstract double xyzToV(double var1, double var3, double var5);

        public final double xyzToV(S2Point p) {
            return this.xyzToV(p.x, p.y, p.z);
        }
    }
}

