/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.errors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.api.core.InternalApi;
import com.google.common.base.Strings;
import com.google.genai.errors.BaseException;
import com.google.genai.errors.ClientException;
import com.google.genai.errors.ServerException;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class ApiException
extends BaseException {
    private final int code;
    private final String status;
    private final String message;

    public ApiException(int code, String status, String message) {
        super(String.format("%d %s. %s", code, status, message));
        this.code = code;
        this.status = status;
        this.message = message;
    }

    @Deprecated
    public static void throwFromResponse(CloseableHttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        int code = statusLine.getStatusCode();
        if (code == 200) {
            return;
        }
        String status = statusLine.getReasonPhrase();
        String message = ApiException.getErrorMessageFromResponse(response);
        if (code >= 400 && code < 500) {
            throw new ClientException(code, status, message);
        }
        if (code >= 500 && code < 600) {
            throw new ServerException(code, status, message);
        }
        throw new ApiException(code, status, message);
    }

    @InternalApi
    public static void throwFromResponse(Response response) {
        int code = response.code();
        if (code >= 200 && code < 300) {
            return;
        }
        String status = response.message();
        String message = ApiException.getErrorMessageFromResponse(response);
        if (code >= 400 && code < 500) {
            throw new ClientException(code, status, message);
        }
        if (code >= 500 && code < 600) {
            throw new ServerException(code, status, message);
        }
        throw new ApiException(code, status, message);
    }

    static String getErrorMessageFromResponse(CloseableHttpResponse response) {
        HttpEntity entity = response.getEntity();
        try {
            JsonNode messageNode;
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            if (responseBody == null || responseBody.isEmpty()) {
                return "";
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode errorNode = mapper.readTree(responseBody).get("error");
            if (errorNode != null && errorNode.isObject() && (messageNode = errorNode.get("message")) != null && messageNode.isTextual()) {
                return messageNode.asText();
            }
            return "";
        }
        catch (IOException ignored) {
            return "";
        }
    }

    static String getErrorMessageFromResponse(Response response) {
        ResponseBody responseBody = response.body();
        try {
            JsonNode messageNode;
            if (responseBody == null) {
                return "";
            }
            String responseBodyString = responseBody.string();
            if (Strings.isNullOrEmpty((String)responseBodyString)) {
                return "";
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode errorNode = mapper.readTree(responseBodyString).get("error");
            if (errorNode != null && errorNode.isObject() && (messageNode = errorNode.get("message")) != null && messageNode.isTextual()) {
                return messageNode.asText();
            }
            return "";
        }
        catch (IOException ignored) {
            return "";
        }
    }

    @InternalApi
    public static void throwFromErrorNode(ArrayNode errorNode, int code) {
        if (code == 200) {
            return;
        }
        if (errorNode == null || errorNode.size() == 0) {
            return;
        }
        String message = "";
        JsonNode messageNode = errorNode.get(0).get("message");
        if (messageNode != null && messageNode.isTextual()) {
            message = messageNode.asText();
        }
        String status = "UNKNOWN";
        JsonNode statusNode = errorNode.get("status");
        if (statusNode != null && statusNode.isTextual()) {
            status = statusNode.asText();
        }
        if (code >= 400 && code < 500) {
            throw new ClientException(code, status, message);
        }
        if (code >= 500 && code < 600) {
            throw new ServerException(code, status, message);
        }
        throw new ApiException(code, status, message);
    }

    public int code() {
        return this.code;
    }

    public String status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }
}

