/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="statistics")
public class YtUserProfileStatistics
extends AbstractExtension {
    private long viewCount;
    private long videoWatchCount;
    private long subscriberCount;
    private DateTime lastWebAccess;

    public long getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(long viewCount) {
        this.viewCount = viewCount;
    }

    public long getVideoWatchCount() {
        return this.videoWatchCount;
    }

    public void setVideoWatchCount(long vwc) {
        this.videoWatchCount = vwc;
    }

    public long getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(long sc) {
        this.subscriberCount = sc;
    }

    public DateTime getLastWebAccess() {
        return this.lastWebAccess;
    }

    public void setLastWebAccess(DateTime lastWebAccess) {
        this.lastWebAccess = lastWebAccess;
    }

    protected void putAttributes(AttributeGenerator generator) {
        this.putAttributeIfGreaterZero(generator, "viewCount", this.viewCount);
        this.putAttributeIfGreaterZero(generator, "videoWatchCount", this.videoWatchCount);
        this.putAttributeIfGreaterZero(generator, "subscriberCount", this.subscriberCount);
        if (this.lastWebAccess != null) {
            generator.put("lastWebAccess", this.lastWebAccess);
        }
    }

    private void putAttributeIfGreaterZero(AttributeGenerator generator, String key, long value) {
        if (value > 0L) {
            generator.put(key, value);
        }
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.viewCount = helper.consumeLong("viewCount", false, 0L);
        this.videoWatchCount = helper.consumeLong("videoWatchCount", false, 0L);
        this.subscriberCount = helper.consumeLong("subscriberCount", false, 0L);
        this.lastWebAccess = helper.consumeDateTime("lastWebAccess", false);
    }
}

