/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Content;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.PubControl;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.YtPublicationState;
import com.google.gdata.util.ParseException;
import java.io.IOException;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#captionTrack")
public class CaptionTrackEntry
extends BaseEntry<CaptionTrackEntry> {
    public CaptionTrackEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#captionTrack");
    }

    public CaptionTrackEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#captionTrack");
    }

    public String getLanguageCode() {
        Content content = this.getContent();
        return content == null ? null : content.getLang();
    }

    public void setPublicationState(YtPublicationState state) {
        PubControl control = this.getPubControl();
        if (state == null) {
            if (control == null) {
                return;
            }
            control.removeExtension(YtPublicationState.class);
            if (!control.isDraft() && control.getExtensions().isEmpty()) {
                this.setPubControl(null);
            }
        } else {
            if (control == null) {
                control = new PubControl();
                this.setPubControl(control);
            }
            control.setExtension(state);
        }
    }

    public YtPublicationState getPublicationState() {
        return this.getPubControl() == null ? null : this.getPubControl().getExtension(YtPublicationState.class);
    }

    @Override
    protected Content.ChildHandlerInfo getContentHandlerInfo(ExtensionProfile extProfile, Attributes attrs) throws ParseException, IOException {
        return MediaContent.getChildHandler(extProfile, attrs);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(PubControl.class, YtPublicationState.class);
        extProfile.declareArbitraryXmlExtension(CaptionTrackEntry.class);
    }
}

