/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.calendar;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.data.calendar.CalendarEventEntry;
import com.google.gdata.data.calendar.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContent
implements Extension {
    public static final String REL = "http://schemas.google.com/gCal/2005/webContent";
    private static final String TYPE = "webContent";
    private static final String GADGET_TYPE = "webContentGadgetPref";
    private static final ExtensionDescription EXTENSION_DESCRIPTION;
    private String width = null;
    private String height = null;
    private String url = null;
    private Map<String, String> gadgetPrefs;
    private Link webContentLink;

    public WebContent() {
        this.setLink(new Link(REL, null, null));
    }

    public static ExtensionDescription getDefaultDescription() {
        return EXTENSION_DESCRIPTION;
    }

    public static void updateWebContent(CalendarEventEntry entry) throws ParseException {
        Link wcLink = entry.getWebContentLink();
        if (wcLink == null) {
            entry.setWebContent(null);
        } else {
            WebContent wc = entry.getWebContent();
            wc.setLink(wcLink);
            entry.setWebContent(wc);
        }
    }

    @Override
    public void generate(XmlWriter writer, ExtensionProfile profile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.getWidth() != null) {
            attrs.add(new XmlWriter.Attribute("width", this.getWidth()));
        }
        if (this.getHeight() != null) {
            attrs.add(new XmlWriter.Attribute("height", this.getHeight()));
        }
        if (this.getUrl() != null) {
            attrs.add(new XmlWriter.Attribute("url", this.getUrl()));
        }
        Map<String, String> preferences = this.getGadgetPrefs();
        if (attrs.size() != 0) {
            if (preferences == null || preferences.isEmpty()) {
                writer.simpleElement(Namespaces.gCalNs, TYPE, attrs, null);
            } else {
                writer.startElement(Namespaces.gCalNs, TYPE, attrs, null);
                writer.startRepeatingElement();
                for (Map.Entry<String, String> pref : preferences.entrySet()) {
                    ArrayList<XmlWriter.Attribute> prefAttrs = new ArrayList<XmlWriter.Attribute>();
                    prefAttrs.add(new XmlWriter.Attribute("name", pref.getKey()));
                    prefAttrs.add(new XmlWriter.Attribute("value", pref.getValue()));
                    writer.simpleElement(Namespaces.gCalNs, GADGET_TYPE, prefAttrs, null);
                }
                writer.endRepeatingElement();
                writer.endElement(Namespaces.gCalNs, TYPE);
            }
        }
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile profile, String namespace, String localName, Attributes attrs) throws ParseException, IOException {
        return new Handler();
    }

    Link getLink() {
        return this.webContentLink;
    }

    void setLink(Link link) {
        if (this.webContentLink != null) {
            this.webContentLink.removeExtension(WebContent.class);
        }
        this.webContentLink = link;
        this.webContentLink.setExtension(this);
    }

    public String getIcon() {
        return this.webContentLink.getHref();
    }

    public void setIcon(String icon) {
        this.webContentLink.setHref(icon);
    }

    public String getTitle() {
        return this.webContentLink.getTitle();
    }

    public void setTitle(String title) {
        this.webContentLink.setTitle(title);
    }

    public String getType() {
        return this.webContentLink.getType();
    }

    public void setType(String type) {
        this.webContentLink.setType(type);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public Map<String, String> getGadgetPrefs() {
        return this.gadgetPrefs;
    }

    public void setGadgetPrefs(Map<String, String> gadgetPrefs) {
        this.gadgetPrefs = gadgetPrefs;
    }

    public String toString() {
        return "icon=" + this.getIcon() + ",title=" + this.getTitle() + ",type=" + this.getType() + ",width=" + this.getWidth() + ",height=" + this.getHeight() + ",url=" + this.getUrl();
    }

    static {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(WebContent.class);
        desc.setNamespace(Namespaces.gCalNs);
        desc.setLocalName(TYPE);
        desc.setRepeatable(false);
        EXTENSION_DESCRIPTION = desc;
    }

    class GadgetPrefHandler
    extends XmlParser.ElementHandler {
        private Handler parentHandler;
        private String name;
        private String value;

        GadgetPrefHandler(Handler parentHandler) {
            this.parentHandler = parentHandler;
            this.name = null;
            this.value = null;
        }

        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (!namespace.equals("")) {
                return;
            }
            if (localName.equals("name")) {
                this.name = value;
            } else if (localName.equals("value")) {
                this.value = value;
            }
        }

        public void processEndElement() throws ParseException {
            if (this.name != null && this.value != null) {
                this.parentHandler.addGadgetPref(this.name, this.value);
            } else {
                if (this.name != null) {
                    throw new ParseException("name attribute defined but not value");
                }
                if (this.value != null) {
                    throw new ParseException("value attribute defined but not name");
                }
            }
        }
    }

    class Handler
    extends XmlParser.ElementHandler {
        public Handler() {
            WebContent.this.width = null;
            WebContent.this.height = null;
            WebContent.this.url = null;
            WebContent.this.gadgetPrefs = null;
        }

        public void processAttribute(String namespace, String localName, String value) {
            if (!namespace.equals("")) {
                return;
            }
            if (localName.equals("width")) {
                WebContent.this.setWidth(value);
            } else if (localName.equals("height")) {
                WebContent.this.setHeight(value);
            } else if (localName.equals("url")) {
                WebContent.this.setUrl(value);
            }
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) {
            if ("http://schemas.google.com/gCal/2005".equals(namespace) && WebContent.GADGET_TYPE.equals(localName)) {
                return new GadgetPrefHandler(this);
            }
            return null;
        }

        void addGadgetPref(String name, String value) {
            if (WebContent.this.gadgetPrefs == null) {
                WebContent.this.gadgetPrefs = new HashMap();
            }
            WebContent.this.gadgetPrefs.put(name, value);
        }
    }
}

