/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.books;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.books.Embeddability;
import com.google.gdata.data.books.OpenAccess;
import com.google.gdata.data.books.Review;
import com.google.gdata.data.books.Viewability;
import com.google.gdata.data.dublincore.Creator;
import com.google.gdata.data.dublincore.Date;
import com.google.gdata.data.dublincore.Description;
import com.google.gdata.data.dublincore.Format;
import com.google.gdata.data.dublincore.Identifier;
import com.google.gdata.data.dublincore.Language;
import com.google.gdata.data.dublincore.Publisher;
import com.google.gdata.data.dublincore.Subject;
import com.google.gdata.data.dublincore.Title;
import com.google.gdata.data.extensions.Comments;
import com.google.gdata.data.extensions.Rating;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/books/2008#volume")
public class VolumeEntry
extends BaseEntry<VolumeEntry> {
    public static final String KIND = "http://schemas.google.com/books/2008#volume";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/books/2008#volume");

    public VolumeEntry() {
        this.getCategories().add(CATEGORY);
    }

    public VolumeEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(VolumeEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(VolumeEntry.class, new ExtensionDescription(Comments.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "comments", false, false, false));
        new Comments().declareExtensions(extProfile);
        extProfile.declare(VolumeEntry.class, Creator.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Date.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Description.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Embeddability.class);
        extProfile.declare(VolumeEntry.class, Format.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Identifier.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Language.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, OpenAccess.class);
        extProfile.declare(VolumeEntry.class, Publisher.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, new ExtensionDescription(Rating.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "rating", false, false, false));
        extProfile.declare(VolumeEntry.class, Review.class);
        extProfile.declare(VolumeEntry.class, Subject.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Title.getDefaultDescription(false, true));
        extProfile.declare(VolumeEntry.class, Viewability.class);
    }

    public Comments getComments() {
        return this.getExtension(Comments.class);
    }

    public void setComments(Comments comments) {
        if (comments == null) {
            this.removeExtension(Comments.class);
        } else {
            this.setExtension(comments);
        }
    }

    public boolean hasComments() {
        return this.hasExtension(Comments.class);
    }

    public List<Creator> getCreators() {
        return this.getRepeatingExtension(Creator.class);
    }

    public void addCreator(Creator creator) {
        this.getCreators().add(creator);
    }

    public boolean hasCreators() {
        return this.hasRepeatingExtension(Creator.class);
    }

    public List<Date> getDates() {
        return this.getRepeatingExtension(Date.class);
    }

    public void addDate(Date date) {
        this.getDates().add(date);
    }

    public boolean hasDates() {
        return this.hasRepeatingExtension(Date.class);
    }

    public List<Description> getDescriptions() {
        return this.getRepeatingExtension(Description.class);
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public boolean hasDescriptions() {
        return this.hasRepeatingExtension(Description.class);
    }

    public Embeddability getEmbeddability() {
        return this.getExtension(Embeddability.class);
    }

    public void setEmbeddability(Embeddability embeddability) {
        if (embeddability == null) {
            this.removeExtension(Embeddability.class);
        } else {
            this.setExtension(embeddability);
        }
    }

    public boolean hasEmbeddability() {
        return this.hasExtension(Embeddability.class);
    }

    public List<Format> getFormats() {
        return this.getRepeatingExtension(Format.class);
    }

    public void addFormat(Format format) {
        this.getFormats().add(format);
    }

    public boolean hasFormats() {
        return this.hasRepeatingExtension(Format.class);
    }

    public List<Identifier> getIdentifiers() {
        return this.getRepeatingExtension(Identifier.class);
    }

    public void addIdentifier(Identifier identifier) {
        this.getIdentifiers().add(identifier);
    }

    public boolean hasIdentifiers() {
        return this.hasRepeatingExtension(Identifier.class);
    }

    public List<Language> getLanguages() {
        return this.getRepeatingExtension(Language.class);
    }

    public void addLanguage(Language language) {
        this.getLanguages().add(language);
    }

    public boolean hasLanguages() {
        return this.hasRepeatingExtension(Language.class);
    }

    public OpenAccess getOpenAccess() {
        return this.getExtension(OpenAccess.class);
    }

    public void setOpenAccess(OpenAccess openAccess) {
        if (openAccess == null) {
            this.removeExtension(OpenAccess.class);
        } else {
            this.setExtension(openAccess);
        }
    }

    public boolean hasOpenAccess() {
        return this.hasExtension(OpenAccess.class);
    }

    public List<Publisher> getPublishers() {
        return this.getRepeatingExtension(Publisher.class);
    }

    public void addPublisher(Publisher publisher) {
        this.getPublishers().add(publisher);
    }

    public boolean hasPublishers() {
        return this.hasRepeatingExtension(Publisher.class);
    }

    public Rating getRating() {
        return this.getExtension(Rating.class);
    }

    public void setRating(Rating rating) {
        if (rating == null) {
            this.removeExtension(Rating.class);
        } else {
            this.setExtension(rating);
        }
    }

    public boolean hasRating() {
        return this.hasExtension(Rating.class);
    }

    public Review getReview() {
        return this.getExtension(Review.class);
    }

    public void setReview(Review review) {
        if (review == null) {
            this.removeExtension(Review.class);
        } else {
            this.setExtension(review);
        }
    }

    public boolean hasReview() {
        return this.hasExtension(Review.class);
    }

    public List<Subject> getSubjects() {
        return this.getRepeatingExtension(Subject.class);
    }

    public void addSubject(Subject subject) {
        this.getSubjects().add(subject);
    }

    public boolean hasSubjects() {
        return this.hasRepeatingExtension(Subject.class);
    }

    public List<Title> getTitles() {
        return this.getRepeatingExtension(Title.class);
    }

    public void addTitle(Title title) {
        this.getTitles().add(title);
    }

    public boolean hasTitles() {
        return this.hasRepeatingExtension(Title.class);
    }

    public Viewability getViewability() {
        return this.getExtension(Viewability.class);
    }

    public void setViewability(Viewability viewability) {
        if (viewability == null) {
            this.removeExtension(Viewability.class);
        } else {
            this.setExtension(viewability);
        }
    }

    public boolean hasViewability() {
        return this.hasExtension(Viewability.class);
    }

    public Link getAnnotationLink() {
        return this.getLink("http://schemas.google.com/books/2008/annotation", ILink.Type.ATOM);
    }

    public Link getAtomAlternateLink() {
        return this.getLink("alternate", ILink.Type.ATOM);
    }

    public Link getEpubDownloadLink() {
        return this.getLink("http://schemas.google.com/books/2008/epubdownload", "application/epub");
    }

    public Link getInfoLink() {
        return this.getLink("http://schemas.google.com/books/2008/info", ILink.Type.HTML);
    }

    public Link getPreviewLink() {
        return this.getLink("http://schemas.google.com/books/2008/preview", ILink.Type.HTML);
    }

    public Link getThumbnailLink() {
        return this.getLink("http://schemas.google.com/books/2008/thumbnail", null);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{VolumeEntry " + super.toString() + "}";
    }
}

