/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.youtube;

import com.google.gdata.client.Service;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.youtube.ChannelFeed;
import com.google.gdata.data.youtube.CommentFeed;
import com.google.gdata.data.youtube.ComplaintFeed;
import com.google.gdata.data.youtube.FormUploadToken;
import com.google.gdata.data.youtube.FriendFeed;
import com.google.gdata.data.youtube.PlaylistFeed;
import com.google.gdata.data.youtube.PlaylistLinkFeed;
import com.google.gdata.data.youtube.RatingFeed;
import com.google.gdata.data.youtube.SubscriptionFeed;
import com.google.gdata.data.youtube.UserEventFeed;
import com.google.gdata.data.youtube.UserProfileFeed;
import com.google.gdata.data.youtube.VideoFeed;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YouTubeService
extends MediaService {
    private static final String SERVICE_NAME = "youtube";
    private static final String SERVICE_VERSION = "YouTube-Java/1.0";
    private static final URL DEFAULT_AUTH_URL;
    public static final Version DEFAULT_VERSION;

    public YouTubeService(String applicationName) {
        this(applicationName, null, DEFAULT_AUTH_URL);
    }

    public YouTubeService(String applicationName, String developerId) {
        this(applicationName, developerId, DEFAULT_AUTH_URL);
    }

    protected YouTubeService(String applicationName, String developerId, URL authBaseUrl) {
        super(SERVICE_NAME, applicationName, authBaseUrl.getProtocol(), authBaseUrl.getHost() + (authBaseUrl.getPort() == -1 ? "" : ":" + authBaseUrl.getPort()) + authBaseUrl.getPath());
        this.getRequestFactory().setHeader("X-GData-Key", developerId != null ? "key=" + developerId : null);
        this.getRequestFactory().setHeader("X-GData-Client", applicationName);
        ExtensionProfile profile = this.getExtensionProfile();
        profile.addDeclarations(new ChannelFeed());
        profile.addDeclarations(new ComplaintFeed());
        profile.addDeclarations(new CommentFeed());
        profile.addDeclarations(new FriendFeed());
        profile.addDeclarations(new UserEventFeed());
        profile.addDeclarations(new PlaylistFeed());
        profile.addDeclarations(new PlaylistLinkFeed());
        profile.addDeclarations(new RatingFeed());
        profile.addDeclarations(new SubscriptionFeed());
        profile.addDeclarations(new UserProfileFeed());
        profile.addDeclarations(new VideoFeed());
    }

    @Override
    public String getServiceVersion() {
        return SERVICE_VERSION + ' ' + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(YouTubeService.class);
    }

    public static boolean isCompatible(Version version) {
        if (version == null) {
            throw new NullPointerException("Version cannot be null.");
        }
        return YouTubeService.getVersion().isCompatible(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> FormUploadToken getFormUploadToken(URL url, E entry) throws ServiceException, IOException {
        if (entry == null) {
            throw new NullPointerException("Must supply entry");
        }
        Service.GDataRequest request = this.createInsertRequest(url);
        this.writeRequestData(request, entry);
        request.execute();
        ParseSource resultEntrySource = request.getParseSource();
        try {
            FormUploadToken formUploadToken = FormUploadToken.parse(resultEntrySource.getInputStream());
            return formUploadToken;
        }
        finally {
            request.end();
        }
    }

    static {
        try {
            DEFAULT_AUTH_URL = new URL("https://www.google.com/youtube");
        }
        catch (MalformedURLException abnormal) {
            throw new IllegalStateException(abnormal);
        }
        DEFAULT_VERSION = Service.initServiceVersion(YouTubeService.class, Versions.V2);
    }

    public static class Versions {
        public static final Version V1 = new Version(YouTubeService.class, "1.0", Service.Versions.V1);
        public static final Version V2;
        public static final Version LATEST;
        public static final Version[] ALL;

        static {
            LATEST = V2 = new Version(YouTubeService.class, "2.0", Service.Versions.V2);
            ALL = new Version[]{V1, V2};
        }
    }
}

