/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.media;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.media.IMediaContent;
import com.google.gdata.data.media.IMediaEntry;
import com.google.gdata.data.media.MediaMultipart;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.MediaStreamSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.RedirectRequiredException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.PercentEscaper;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.AltRegistry;
import com.google.gdata.wireformats.input.media.MediaMultipartParser;
import com.google.gdata.wireformats.input.media.MediaParser;
import com.google.gdata.wireformats.output.media.MediaGenerator;
import com.google.gdata.wireformats.output.media.MediaMultipartGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaService
extends GoogleService {
    public static final int DEFAULT_CHUNKED_BUFFER_SIZE = 0;
    public static final int NO_CHUNKED_MEDIA_REQUEST = -1;
    private int chunkedBufferSize = 0;
    private static final AltRegistry MEDIA_REGISTRY = new AltRegistry(Service.getDefaultAltRegistry());
    private static final PercentEscaper SLUG_ESCAPER;

    public static AltRegistry getDefaultAltRegistry() {
        return MEDIA_REGISTRY;
    }

    public MediaService(String serviceName, String applicationName) {
        super(serviceName, applicationName);
        this.setAltRegistry(MEDIA_REGISTRY);
    }

    public MediaService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.setAltRegistry(MEDIA_REGISTRY);
    }

    public MediaService(String serviceName, String applicationName, String protocol, String domainName) {
        super(serviceName, applicationName, protocol, domainName);
        this.setAltRegistry(MEDIA_REGISTRY);
    }

    public void setChunkedMediaUpload(int chunkSizeInBytes) {
        this.chunkedBufferSize = chunkSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaSource getMediaResource(URL mediaUrl, ContentType contentType, DateTime ifModifiedSince) throws IOException, ServiceException {
        MediaStreamSource mediaSource;
        try {
            String etag;
            this.startVersionScope();
            Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.QUERY, mediaUrl, contentType);
            request.setIfModifiedSince(ifModifiedSince);
            request.execute();
            InputStream resultStream = request.getResponseStream();
            mediaSource = new MediaStreamSource(resultStream, request.getResponseContentType().toString());
            DateTime lastModified = request.getResponseDateHeader("Last-Modified");
            if (lastModified != null) {
                mediaSource.setLastModified(lastModified);
            }
            if ((etag = request.getResponseHeader("ETag")) != null) {
                mediaSource.setEtag(etag);
            }
        }
        finally {
            this.endVersionScope();
        }
        return mediaSource;
    }

    public MediaSource getMedia(IMediaContent mediaContent, DateTime ifModifiedSince) throws IOException, ServiceException {
        URL mediaUrl = null;
        try {
            mediaUrl = new URL(mediaContent.getUri());
            return this.getMediaResource(mediaUrl, mediaContent.getMimeType(), ifModifiedSince);
        }
        catch (MalformedURLException mue) {
            throw new ServiceException(CoreErrorDomain.ERR.invalidMediaSourceUri, (Throwable)mue);
        }
        catch (RedirectRequiredException e) {
            mediaUrl = this.handleRedirectException(e);
        }
        catch (GoogleService.SessionExpiredException e) {
            this.handleSessionExpiredException(e);
        }
        return this.getMediaResource(mediaUrl, mediaContent.getMimeType(), ifModifiedSince);
    }

    public MediaSource getMedia(IMediaContent mediaContent) throws IOException, ServiceException {
        return this.getMedia(mediaContent, null);
    }

    private void initMediaRequest(MediaSource media, Service.GDataRequest request) {
        String name = media.getName();
        if (name != null) {
            request.setHeader("Slug", MediaService.escapeSlug(name));
        }
        if (this.chunkedBufferSize != -1 && request instanceof HttpGDataRequest) {
            HttpGDataRequest httpRequest = (HttpGDataRequest)request;
            httpRequest.getConnection().setChunkedStreamingMode(this.chunkedBufferSize);
        }
    }

    static String escapeSlug(String slug) {
        return SLUG_ESCAPER.escape(slug);
    }

    @Override
    public <E extends IEntry> E insert(URL feedUrl, E entry) throws IOException, ServiceException {
        MediaSource media;
        Preconditions.checkNotNull(entry, "entry");
        MediaSource mediaSource = media = entry instanceof IMediaEntry ? ((IMediaEntry)entry).getMediaSource() : null;
        if (media == null) {
            return super.insert(feedUrl, entry);
        }
        Service.GDataRequest request = null;
        try {
            this.startVersionScope();
            MediaMultipart mediaMultipart = new MediaMultipart(entry, media);
            request = this.createRequest(Service.GDataRequest.RequestType.INSERT, feedUrl, new ContentType(mediaMultipart.getContentType()));
            this.initMediaRequest(media, request);
            this.writeRequestData(request, new Service.ClientOutputProperties(request, entry), (Object)mediaMultipart);
            request.execute();
            E e = this.parseResponseData(request, this.classOf(entry));
            return e;
        }
        catch (MessagingException e) {
            throw new ServiceException(CoreErrorDomain.ERR.cantWriteMimeMultipart, (Throwable)e);
        }
        finally {
            this.endVersionScope();
            if (request != null) {
                request.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E insert(URL feedUrl, Class<E> entryClass, MediaSource media) throws IOException, ServiceException {
        Preconditions.checkNotNull(media, "media");
        Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.INSERT, feedUrl, new ContentType(media.getContentType()));
        try {
            this.startVersionScope();
            this.initMediaRequest(media, request);
            this.writeRequestData(request, media);
            request.execute();
            IEntry iEntry = (IEntry)this.parseResponseData(request, entryClass);
            return (E)iEntry;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    @Override
    public <E extends IEntry> E update(URL url, E entry) throws IOException, ServiceException {
        return super.update(url, entry);
    }

    public <E extends IEntry> E updateMedia(URL mediaUrl, E entry) throws IOException, ServiceException {
        MediaSource media;
        Preconditions.checkNotNull(entry, "entry");
        MediaSource mediaSource = media = entry instanceof IMediaEntry ? ((IMediaEntry)entry).getMediaSource() : null;
        if (media == null) {
            throw new IllegalArgumentException("Must supply media entry with a media source");
        }
        Service.GDataRequest request = null;
        try {
            this.startVersionScope();
            MediaMultipart mediaMultipart = new MediaMultipart(entry, media);
            request = this.createRequest(Service.GDataRequest.RequestType.UPDATE, mediaUrl, new ContentType(mediaMultipart.getContentType()));
            this.writeRequestData(request, new Service.ClientOutputProperties(request, entry), (Object)mediaMultipart);
            request.execute();
            E e = this.parseResponseData(request, this.classOf(entry));
            return e;
        }
        catch (MessagingException e) {
            throw new ServiceException(CoreErrorDomain.ERR.cantWriteMimeMultipart, (Throwable)e);
        }
        finally {
            this.endVersionScope();
            if (request != null) {
                request.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E updateMedia(URL mediaUrl, Class<E> entryClass, MediaSource media) throws IOException, ServiceException {
        Preconditions.checkNotNull(media, "media");
        ContentType mediaContentType = new ContentType(media.getContentType());
        Service.GDataRequest request = this.createRequest(Service.GDataRequest.RequestType.UPDATE, mediaUrl, mediaContentType);
        try {
            this.startVersionScope();
            this.writeRequestData(request, media);
            request.execute();
            IEntry iEntry = (IEntry)this.parseResponseData(request, entryClass);
            return (E)iEntry;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    static {
        MEDIA_REGISTRY.register(AltFormat.MEDIA, new MediaParser(), new MediaGenerator());
        MEDIA_REGISTRY.register(AltFormat.MEDIA_MULTIPART, new MediaMultipartParser(), new MediaMultipartGenerator());
        MEDIA_REGISTRY.lock();
        SLUG_ESCAPER = new PercentEscaper(" !\"#$&'()*+,-./:;<=>?@[\\]^_`{|}~", false);
    }
}

