/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.Keep;
import androidx.annotation.RestrictTo;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.inject.Provider;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.storage.FirebaseStorageComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

@Keep
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class StorageRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-gcs";
    Qualified<Executor> blockingExecutor = Qualified.qualified(Blocking.class, Executor.class);
    Qualified<Executor> uiExecutor = Qualified.qualified(UiThread.class, Executor.class);

    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseStorageComponent.class).name(LIBRARY_NAME).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(this.blockingExecutor)).add(Dependency.required(this.uiExecutor)).add(Dependency.optionalProvider(InternalAuthProvider.class)).add(Dependency.optionalProvider(InteropAppCheckTokenProvider.class)).factory(c -> new FirebaseStorageComponent((FirebaseApp)c.get(FirebaseApp.class), (Provider<InternalAuthProvider>)c.getProvider(InternalAuthProvider.class), (Provider<InteropAppCheckTokenProvider>)c.getProvider(InteropAppCheckTokenProvider.class), (Executor)c.get(this.blockingExecutor), (Executor)c.get(this.uiExecutor))).build(), LibraryVersionComponent.create((String)LIBRARY_NAME, (String)"21.0.1"));
    }
}

