/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.storage.StorageTaskScheduler;
import java.util.concurrent.Executor;

public class SmartHandler {
    private final Handler handler;
    private final Executor executor;
    static boolean testMode = false;

    public SmartHandler(@Nullable Executor executor) {
        this.executor = executor;
        this.handler = this.executor == null ? (!testMode ? new Handler(Looper.getMainLooper()) : null) : null;
    }

    public void callBack(@NonNull Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.handler == null) {
            if (this.executor != null) {
                this.executor.execute(runnable);
            } else {
                StorageTaskScheduler.getInstance().scheduleCallback(runnable);
            }
        } else {
            this.handler.post(runnable);
        }
    }
}

