/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.storage.internal.SlashUtil;
import com.google.firebase.storage.network.NetworkRequest;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Util {
    public static final int NETWORK_UNAVAILABLE = -2;
    public static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String TAG = "StorageUtil";
    private static final int MAXIMUM_TOKEN_WAIT_TIME_MS = 30000;

    public static long parseDateTime(@Nullable String dateString) {
        if (dateString == null) {
            return 0L;
        }
        dateString = dateString.replaceAll("Z$", "-0000");
        SimpleDateFormat iso8601Format = new SimpleDateFormat(ISO_8601_FORMAT, Locale.getDefault());
        try {
            return iso8601Format.parse(dateString).getTime();
        }
        catch (ParseException e) {
            Log.w((String)TAG, (String)("unable to parse datetime:" + dateString), (Throwable)e);
            return 0L;
        }
    }

    public static boolean equals(@Nullable Object a, @Nullable Object b) {
        return Objects.equal((Object)a, (Object)b);
    }

    private static String getAuthority() throws RemoteException {
        return NetworkRequest.getAuthority();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Uri normalize(@NonNull FirebaseApp app, @Nullable String s) throws UnsupportedEncodingException {
        String bucket;
        String encodedPath;
        block10: {
            if (TextUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            String invalidUrlMessage = "Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().";
            String trimmedInput = s.toLowerCase();
            if (trimmedInput.startsWith("gs://")) {
                String fullUri = SlashUtil.preserveSlashEncode(SlashUtil.normalizeSlashes(s.substring(5)));
                return Uri.parse((String)("gs://" + fullUri));
            }
            Uri uri = Uri.parse((String)s);
            String scheme = uri.getScheme();
            if (scheme != null && (Util.equals(scheme.toLowerCase(), "http") || Util.equals(scheme.toLowerCase(), "https"))) {
                int indexOfAuth;
                String lowerAuthority = uri.getAuthority().toLowerCase();
                try {
                    indexOfAuth = lowerAuthority.indexOf(Util.getAuthority());
                }
                catch (RemoteException e) {
                    throw new UnsupportedEncodingException("Could not parse Url because the Storage network layer did not load");
                }
                encodedPath = SlashUtil.slashize(uri.getEncodedPath());
                if (indexOfAuth == 0 && encodedPath.startsWith("/")) {
                    int firstBSlash = encodedPath.indexOf("/b/", 0);
                    int endBSlash = encodedPath.indexOf("/", firstBSlash + 3);
                    int firstOSlash = encodedPath.indexOf("/o/", 0);
                    if (firstBSlash != -1 && endBSlash != -1) {
                        bucket = encodedPath.substring(firstBSlash + 3, endBSlash);
                        encodedPath = firstOSlash != -1 ? encodedPath.substring(firstOSlash + 3) : "";
                        break block10;
                    } else {
                        Log.w((String)TAG, (String)"Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
                        throw new IllegalArgumentException("Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
                    }
                }
                if (indexOfAuth <= 1) {
                    Log.w((String)TAG, (String)"Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
                    throw new IllegalArgumentException("Firebase Storage URLs must point to an object in your Storage Bucket. Please obtain a URL using the Firebase Console or getDownloadUrl().");
                }
                bucket = uri.getAuthority().substring(0, indexOfAuth - 1);
            } else {
                Log.w((String)TAG, (String)("FirebaseStorage is unable to support the scheme:" + scheme));
                throw new IllegalArgumentException("Uri scheme");
            }
        }
        Preconditions.checkNotEmpty((String)bucket, (Object)"No bucket specified");
        return new Uri.Builder().scheme("gs").authority(bucket).encodedPath(encodedPath).build();
    }

    @Nullable
    public static String getCurrentAuthToken(FirebaseApp app) {
        Task pendingResult = app.getToken(false);
        try {
            GetTokenResult result = (GetTokenResult)Tasks.await((Task)pendingResult, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
            String token = result.getToken();
            if (!TextUtils.isEmpty((CharSequence)token)) {
                return token;
            }
            Log.w((String)TAG, (String)"no auth token for request");
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Log.e((String)TAG, (String)("error getting token " + e));
        }
        return null;
    }
}

