/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import java.io.UnsupportedEncodingException;

public class SlashUtil {
    @NonNull
    public static String preserveSlashEncode(@Nullable String s) throws UnsupportedEncodingException {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        return SlashUtil.slashize(Uri.encode((String)s));
    }

    @NonNull
    public static String slashize(@NonNull String s) {
        Preconditions.checkNotNull((Object)s);
        return s.replace("%2F", "/");
    }

    @NonNull
    public static String unSlashize(@NonNull String s) {
        Preconditions.checkNotNull((Object)s);
        return s.replace("/", "%2F");
    }

    @NonNull
    public static String normalizeSlashes(@NonNull String uriSegment) {
        if (TextUtils.isEmpty((CharSequence)uriSegment)) {
            return "";
        }
        if (uriSegment.startsWith("/") || uriSegment.endsWith("/") || uriSegment.contains("//")) {
            StringBuilder result = new StringBuilder();
            for (String stringSegment : uriSegment.split("/", -1)) {
                if (TextUtils.isEmpty((CharSequence)stringSegment)) continue;
                if (result.length() > 0) {
                    result.append("/").append(stringSegment);
                    continue;
                }
                result.append(stringSegment);
            }
            return result.toString();
        }
        return uriSegment;
    }
}

