/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.app.Activity;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActivityLifecycleListener {
    private static final ActivityLifecycleListener instance = new ActivityLifecycleListener();
    private final Map<Object, LifecycleEntry> cookieMap = new HashMap<Object, LifecycleEntry>();
    private final Object sync = new Object();

    private ActivityLifecycleListener() {
    }

    @NonNull
    public static ActivityLifecycleListener getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnActivityStopped(@NonNull Activity activityToListenOn, @NonNull Object cookie, @NonNull Runnable runnable) {
        Object object = this.sync;
        synchronized (object) {
            LifecycleEntry entry = new LifecycleEntry(activityToListenOn, runnable, cookie);
            OnStopCallback.getInstance(activityToListenOn).addEntry(entry);
            this.cookieMap.put(cookie, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCookie(@NonNull Object cookie) {
        Object object = this.sync;
        synchronized (object) {
            LifecycleEntry entry = this.cookieMap.get(cookie);
            if (entry != null) {
                OnStopCallback.getInstance(entry.getActivity()).removeEntry(entry);
            }
        }
    }

    private static class OnStopCallback
    extends LifecycleCallback {
        private static final String TAG = "StorageOnStopCallback";
        private final List<LifecycleEntry> listeners = new ArrayList<LifecycleEntry>();

        private OnStopCallback(LifecycleFragment fragment) {
            super(fragment);
            this.mLifecycleFragment.addCallback(TAG, (LifecycleCallback)this);
        }

        public static OnStopCallback getInstance(Activity activity) {
            LifecycleFragment fragment = OnStopCallback.getFragment((LifecycleActivity)new LifecycleActivity(activity));
            OnStopCallback callback = (OnStopCallback)fragment.getCallbackOrNull(TAG, OnStopCallback.class);
            if (callback == null) {
                callback = new OnStopCallback(fragment);
            }
            return callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntry(LifecycleEntry entry) {
            List<LifecycleEntry> list = this.listeners;
            synchronized (list) {
                this.listeners.add(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEntry(LifecycleEntry listener) {
            List<LifecycleEntry> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onStop() {
            ArrayList<LifecycleEntry> copy;
            List<LifecycleEntry> list = this.listeners;
            synchronized (list) {
                copy = new ArrayList<LifecycleEntry>(this.listeners);
                this.listeners.clear();
            }
            for (LifecycleEntry entry : copy) {
                if (entry == null) continue;
                Log.d((String)TAG, (String)"removing subscription from activity.");
                entry.getRunnable().run();
                ActivityLifecycleListener.getInstance().removeCookie(entry.getCookie());
            }
        }
    }

    private static class LifecycleEntry {
        @NonNull
        private final Activity activity;
        @NonNull
        private final Runnable runnable;
        @NonNull
        private final Object cookie;

        public LifecycleEntry(@NonNull Activity activity, @NonNull Runnable runnable, @NonNull Object cookie) {
            this.activity = activity;
            this.runnable = runnable;
            this.cookie = cookie;
        }

        public int hashCode() {
            return this.cookie.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LifecycleEntry)) {
                return false;
            }
            LifecycleEntry other = (LifecycleEntry)obj;
            return other.cookie.equals(this.cookie) && other.runnable == this.runnable && other.activity == this.activity;
        }

        @NonNull
        public Activity getActivity() {
            return this.activity;
        }

        @NonNull
        public Runnable getRunnable() {
            return this.runnable;
        }

        @NonNull
        public Object getCookie() {
            return this.cookie;
        }
    }
}

