/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.GetMetadataNetworkRequest;
import com.google.firebase.storage.network.NetworkRequest;
import org.json.JSONObject;

@PublicApi
class GetDownloadUrlTask
implements Runnable {
    private static final String TAG = "GetMetadataTask";
    @NonNull
    private static final String DOWNLOAD_TOKENS_KEY = "downloadTokens";
    private StorageReference storageRef;
    private TaskCompletionSource<Uri> pendingResult;
    private ExponentialBackoffSender sender;

    GetDownloadUrlTask(@NonNull StorageReference storageRef, @NonNull TaskCompletionSource<Uri> pendingResult) {
        Preconditions.checkNotNull((Object)storageRef);
        Preconditions.checkNotNull(pendingResult);
        this.storageRef = storageRef;
        this.pendingResult = pendingResult;
        this.sender = new ExponentialBackoffSender(this.storageRef.getApp(), this.storageRef.getStorage().getMaxOperationRetryTimeMillis());
    }

    private Uri extractDownloadUrl(JSONObject response) {
        String downloadTokens = response.optString(DOWNLOAD_TOKENS_KEY);
        if (!TextUtils.isEmpty((CharSequence)downloadTokens)) {
            String downloadToken = downloadTokens.split(",", -1)[0];
            String baseURL = NetworkRequest.getdefaultURL(this.storageRef.getStorageUri());
            return Uri.parse((String)(baseURL + "?alt=media&token=" + downloadToken));
        }
        return null;
    }

    @Override
    @PublicApi
    public void run() {
        GetMetadataNetworkRequest request = new GetMetadataNetworkRequest(this.storageRef.getStorageUri(), this.storageRef.getApp());
        this.sender.sendWithExponentialBackoff(request);
        Uri downloadUrl = null;
        if (request.isResultSuccess()) {
            downloadUrl = this.extractDownloadUrl(request.getResultBody());
        }
        if (this.pendingResult != null) {
            request.completeTask(this.pendingResult, downloadUrl);
        }
    }
}

