/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.network.DeleteNetworkRequest;

class DeleteStorageTask
implements Runnable {
    private static final String TAG = "DeleteStorageTask";
    private StorageReference mStorageRef;
    private TaskCompletionSource<Void> mPendingResult;
    private ExponentialBackoffSender mSender;

    public DeleteStorageTask(@NonNull StorageReference storageRef, @NonNull TaskCompletionSource<Void> pendingResult) {
        Preconditions.checkNotNull((Object)storageRef);
        Preconditions.checkNotNull(pendingResult);
        this.mStorageRef = storageRef;
        this.mPendingResult = pendingResult;
        this.mSender = new ExponentialBackoffSender(this.mStorageRef.getStorage().getApp(), this.mStorageRef.getStorage().getMaxOperationRetryTimeMillis());
    }

    @Override
    public void run() {
        DeleteNetworkRequest request = new DeleteNetworkRequest(this.mStorageRef.getStorageUri(), this.mStorageRef.getApp());
        this.mSender.sendWithExponentialBackoff(request);
        request.completeTask(this.mPendingResult, null);
    }
}

