/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzfbc;
import com.google.android.gms.internal.zzfbm;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.zzu;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileDownloadTask
extends StorageTask<TaskSnapshot> {
    private final Uri zzotp;
    private long zzotq;
    private StorageReference zzotm;
    private zzfbc zzoto;
    private long zzgsn = -1L;
    private String zzotr = null;
    private volatile Exception zzleq = null;
    private long zzots = 0L;
    private int mResultCode;

    FileDownloadTask(@NonNull StorageReference storageReference, @NonNull Uri uri) {
        this.zzotm = storageReference;
        this.zzotp = uri;
        this.zzoto = new zzfbc(this.zzotm.getStorage().getApp(), this.zzotm.getStorage().getMaxDownloadRetryTimeMillis());
    }

    final long getTotalBytes() {
        return this.zzgsn;
    }

    @Override
    @NonNull
    final StorageReference getStorage() {
        return this.zzotm;
    }

    @Override
    @Hide
    protected void schedule() {
        zzu.zzv(this.zzbmh());
    }

    private final int zza(InputStream inputStream, byte[] byArray) {
        int n;
        boolean bl = false;
        try {
            int n2;
            for (n = 0; n != byArray.length && (n2 = inputStream.read(byArray, n, byArray.length - n)) != -1; n += n2) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.zzleq = iOException;
        }
        if (bl) {
            return n;
        }
        return -1;
    }

    private final boolean zza(zzfbn zzfbn2) throws IOException {
        boolean bl = true;
        InputStream inputStream = zzfbn2.getStream();
        if (inputStream != null) {
            FileOutputStream fileOutputStream;
            Object object;
            File file = new File(this.zzotp.getPath());
            if (!file.exists()) {
                if (this.zzots > 0L) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.e((String)"FileDownloadTask", (String)(string.length() != 0 ? "The file downloading to has been deleted:".concat(string) : new String("The file downloading to has been deleted:")));
                    throw new IllegalStateException("expected a file to resume from.");
                }
                if (!file.createNewFile()) {
                    String string = String.valueOf(file.getAbsolutePath());
                    Log.w((String)"FileDownloadTask", (String)(string.length() != 0 ? "unable to create file:".concat(string) : new String("unable to create file:")));
                }
            }
            if (this.zzots > 0L) {
                object = file.getAbsolutePath();
                long l = this.zzots;
                Log.d((String)"FileDownloadTask", (String)new StringBuilder(47 + String.valueOf(object).length()).append("Resuming download file ").append((String)object).append(" at ").append(l).toString());
                fileOutputStream = new FileOutputStream(file, true);
            } else {
                fileOutputStream = new FileOutputStream(file);
            }
            try {
                int n;
                object = new byte[262144];
                while (bl && (n = this.zza(inputStream, (byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                    this.zzotq += (long)n;
                    if (this.zzleq != null) {
                        Log.d((String)"FileDownloadTask", (String)"Exception occurred during file download. Retrying.", (Throwable)this.zzleq);
                        this.zzleq = null;
                        bl = false;
                    }
                    if (this.zzk(4, false)) continue;
                    bl = false;
                }
            }
            finally {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        } else {
            this.zzleq = new IllegalStateException("Unable to open Firebase Storage stream.");
            bl = false;
        }
        return bl;
    }

    @Override
    @Hide
    final void run() {
        if (this.zzleq != null) {
            this.zzk(64, false);
            return;
        }
        if (!this.zzk(4, false)) {
            return;
        }
        do {
            Object object;
            zzfbn zzfbn2;
            this.zzotq = 0L;
            this.zzleq = null;
            this.zzoto.reset();
            try {
                zzfbn2 = zzfbm.zzi(this.zzotm.getStorage().getApp()).zza(this.zzotm.zzcnx(), this.zzots);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"FileDownloadTask", (String)"Unable to create firebase storage network request.", (Throwable)remoteException);
                this.zzleq = remoteException;
                this.zzk(64, false);
                return;
            }
            this.zzoto.zza(zzfbn2, false);
            this.mResultCode = zzfbn2.getResultCode();
            this.zzleq = zzfbn2.getException() != null ? zzfbn2.getException() : this.zzleq;
            int n = this.mResultCode;
            boolean bl = (n == 308 || n >= 200 && n < 300) && this.zzleq == null && this.zzcnz() == 4;
            if (bl) {
                this.zzgsn = zzfbn2.zzcot();
                object = zzfbn2.zzst("ETag");
                if (!TextUtils.isEmpty((CharSequence)object) && this.zzotr != null && !this.zzotr.equals(object)) {
                    Log.w((String)"FileDownloadTask", (String)"The file at the server has changed.  Restarting from the beginning.");
                    this.zzots = 0L;
                    this.zzotr = null;
                    zzfbn2.zzcon();
                    ((StorageTask)this).schedule();
                    return;
                }
                this.zzotr = object;
                try {
                    bl = this.zza(zzfbn2);
                }
                catch (IOException iOException) {
                    Log.e((String)"FileDownloadTask", (String)"Exception occurred during file write.  Aborting.", (Throwable)iOException);
                    this.zzleq = iOException;
                }
            }
            zzfbn2.zzcon();
            if (bl && this.zzleq == null && this.zzcnz() == 4) {
                this.zzk(128, false);
                return;
            }
            object = new File(this.zzotp.getPath());
            this.zzots = ((File)object).exists() ? ((File)object).length() : 0L;
            if (this.zzcnz() == 8) {
                this.zzk(16, false);
                return;
            }
            if (this.zzcnz() != 32) continue;
            if (!this.zzk(256, false)) {
                int n2 = this.zzcnz();
                Log.w((String)"FileDownloadTask", (String)new StringBuilder(62).append("Unable to change download task to final state from ").append(n2).toString());
            }
            return;
        } while (this.zzotq > 0L);
        this.zzk(64, false);
    }

    @Override
    protected void onCanceled() {
        this.zzoto.cancel();
        this.zzleq = StorageException.fromErrorStatus(Status.zzftu);
    }

    @Override
    @NonNull
    final /* synthetic */ StorageTask.ProvideError zzcnt() {
        FileDownloadTask fileDownloadTask = this;
        return new TaskSnapshot(fileDownloadTask, (Exception)((Object)StorageException.fromExceptionAndHttpCode(fileDownloadTask.zzleq, fileDownloadTask.mResultCode)), fileDownloadTask.zzotq + fileDownloadTask.zzots);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long zzotq;
        private /* synthetic */ FileDownloadTask zzott;

        TaskSnapshot(@Nullable FileDownloadTask fileDownloadTask, Exception exception, long l) {
            this.zzott = fileDownloadTask;
            super(fileDownloadTask, exception);
            this.zzotq = l;
        }

        public long getBytesTransferred() {
            return this.zzotq;
        }

        public long getTotalByteCount() {
            return this.zzott.getTotalBytes();
        }
    }
}

