/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzfbk;
import com.google.android.gms.internal.zzfbl;
import com.google.android.gms.internal.zzfbn;
import com.google.firebase.FirebaseApp;
import org.json.JSONObject;

@Hide
public final class zzfbm {
    private static DynamiteModule.zzd zzoxr = DynamiteModule.zzhdm;
    private static final Object zzoxs = new Object();
    private static volatile zzfbm zzoxt;
    private zzfbk zzoxu;
    private Context mContext;
    private FirebaseApp zzotv;

    private zzfbm(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        this.mContext = firebaseApp.getApplicationContext();
        this.zzotv = firebaseApp;
        try {
            IInterface iInterface;
            DynamiteModule dynamiteModule = DynamiteModule.zza((Context)this.mContext, (DynamiteModule.zzd)zzoxr, (String)"com.google.android.gms.firebasestorage");
            IBinder iBinder = dynamiteModule.zzhk("com.google.firebase.storage.network.NetworkRequestFactoryImpl");
            this.zzoxu = iBinder == null ? null : ((iInterface = iBinder.queryLocalInterface("com.google.firebase.storage.network.INetworkRequestFactory")) instanceof zzfbk ? (zzfbk)iInterface : new zzfbl(iBinder));
        }
        catch (DynamiteModule.zzc zzc2) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"NetworkRequestFactoryProxy failed with a RemoteException:", (Throwable)zzc2);
            throw new RemoteException();
        }
        if (this.zzoxu == null) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"Unable to load Firebase Storage Network layer.");
            throw new RemoteException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfbm zzi(@NonNull FirebaseApp firebaseApp) throws RemoteException {
        if (zzoxt == null) {
            Object object = zzoxs;
            synchronized (object) {
                if (zzoxt == null) {
                    zzoxt = new zzfbm(firebaseApp);
                }
            }
        }
        return zzoxt;
    }

    private final zzfbn zze(zzfbn zzfbn2) {
        zzfbn2.zzbo("x-firebase-gmpid", this.zzotv.getOptions().getApplicationId());
        return zzfbn2;
    }

    @NonNull
    public final zzfbn zzv(Uri uri) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zza(uri, zzn.zzz((Object)this.mContext))));
    }

    @NonNull
    public final zzfbn zzw(Uri uri) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zzb(uri, zzn.zzz((Object)this.mContext))));
    }

    @NonNull
    public final zzfbn zza(Uri uri, long l) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zza(uri, zzn.zzz((Object)this.mContext), l)));
    }

    @NonNull
    public final zzfbn zza(Uri uri, String string, byte[] byArray, long l, int n, boolean bl) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zza(uri, zzn.zzz((Object)this.mContext), string, zzn.zzz((Object)byArray), l, n, bl)));
    }

    @Nullable
    public final zzfbn zza(Uri uri, String string) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zza(uri, zzn.zzz((Object)this.mContext), string)));
    }

    @NonNull
    public final zzfbn zzb(Uri uri, String string) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zzb(uri, zzn.zzz((Object)this.mContext), string)));
    }

    @NonNull
    public final zzfbn zza(Uri uri, JSONObject jSONObject, String string) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zza(uri, zzn.zzz((Object)this.mContext), zzn.zzz((Object)jSONObject), string)));
    }

    @NonNull
    public final zzfbn zza(Uri uri, JSONObject jSONObject) throws RemoteException {
        return this.zze(new zzfbn(this.zzoxu.zza(uri, zzn.zzz((Object)this.mContext), zzn.zzz((Object)jSONObject))));
    }

    @Nullable
    public final String zzcou() {
        try {
            return this.zzoxu.zzcou();
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getBackendAuthority failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }

    @Nullable
    public final String zzu(Uri uri) {
        try {
            return this.zzoxu.zzu(uri);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"NetworkRqFactoryProxy", (String)"getDefaultURL failed with a RemoteException:", (Throwable)remoteException);
            return null;
        }
    }
}

