/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class TaskExecutors {
    private static final ThreadFactory defaultThreadFactory;
    public static final Executor DEFAULT_THREAD_POOL;
    static final Executor DIRECT;

    private TaskExecutors() {
    }

    static {
        ThreadFactory factory = null;
        try {
            Class<?> c = Class.forName("com.google.appengine.api.ThreadManager");
            if (c != null) {
                factory = (ThreadFactory)c.getMethod("backgroundThreadFactory", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        defaultThreadFactory = factory != null ? factory : Executors.defaultThreadFactory();
        DEFAULT_THREAD_POOL = Executors.newCachedThreadPool(defaultThreadFactory);
        DIRECT = new Executor(){

            @Override
            public void execute(@NonNull Runnable command) {
                command.run();
            }
        };
    }
}

