/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.tubesock;

import com.google.firebase.database.tubesock.WebSocketMessage;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;

class MessageBuilderFactory {
    MessageBuilderFactory() {
    }

    static Builder builder(byte opcode) {
        if (opcode == 2) {
            return new BinaryBuilder();
        }
        return new TextBuilder();
    }

    static class TextBuilder
    implements Builder {
        private static ThreadLocal<CharsetDecoder> localDecoder = new ThreadLocal<CharsetDecoder>(){

            @Override
            protected CharsetDecoder initialValue() {
                Charset utf8 = Charset.forName("UTF8");
                CharsetDecoder decoder = utf8.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                return decoder;
            }
        };
        private static ThreadLocal<CharsetEncoder> localEncoder = new ThreadLocal<CharsetEncoder>(){

            @Override
            protected CharsetEncoder initialValue() {
                Charset utf8 = Charset.forName("UTF8");
                CharsetEncoder encoder = utf8.newEncoder();
                encoder.onMalformedInput(CodingErrorAction.REPORT);
                encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                return encoder;
            }
        };
        private StringBuilder builder = new StringBuilder();
        private ByteBuffer carryOver;

        TextBuilder() {
        }

        @Override
        public boolean appendBytes(byte[] bytes) {
            String nextFrame = this.decodeString(bytes);
            if (nextFrame != null) {
                this.builder.append(nextFrame);
                return true;
            }
            return false;
        }

        @Override
        public WebSocketMessage toMessage() {
            if (this.carryOver != null) {
                return null;
            }
            return new WebSocketMessage(this.builder.toString());
        }

        private String decodeString(byte[] bytes) {
            try {
                ByteBuffer input = ByteBuffer.wrap(bytes);
                CharBuffer buf = localDecoder.get().decode(input);
                String text = buf.toString();
                return text;
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }

        private String decodeStringStreaming(byte[] bytes) {
            try {
                ByteBuffer input = this.getBuffer(bytes);
                int bufSize = (int)((float)input.remaining() * localDecoder.get().averageCharsPerByte());
                CharBuffer output = CharBuffer.allocate(bufSize);
                while (true) {
                    CoderResult result;
                    if ((result = localDecoder.get().decode(input, output, false)).isError()) {
                        return null;
                    }
                    if (result.isUnderflow()) break;
                    if (!result.isOverflow()) continue;
                    bufSize = 2 * bufSize + 1;
                    CharBuffer o = CharBuffer.allocate(bufSize);
                    output.flip();
                    o.put(output);
                    output = o;
                }
                if (input.remaining() > 0) {
                    this.carryOver = input;
                }
                CharBuffer test = CharBuffer.wrap(output);
                localEncoder.get().encode(test);
                output.flip();
                String text = output.toString();
                return text;
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }

        private ByteBuffer getBuffer(byte[] bytes) {
            if (this.carryOver != null) {
                ByteBuffer buffer = ByteBuffer.allocate(bytes.length + this.carryOver.remaining());
                buffer.put(this.carryOver);
                this.carryOver = null;
                buffer.put(bytes);
                buffer.flip();
                return buffer;
            }
            return ByteBuffer.wrap(bytes);
        }
    }

    static class BinaryBuilder
    implements Builder {
        private List<byte[]> pendingBytes = new ArrayList<byte[]>();
        private int pendingByteCount = 0;

        BinaryBuilder() {
        }

        @Override
        public boolean appendBytes(byte[] bytes) {
            this.pendingBytes.add(bytes);
            this.pendingByteCount += bytes.length;
            return true;
        }

        @Override
        public WebSocketMessage toMessage() {
            byte[] payload = new byte[this.pendingByteCount];
            int offset = 0;
            for (int i = 0; i < this.pendingBytes.size(); ++i) {
                byte[] segment = this.pendingBytes.get(i);
                System.arraycopy(segment, 0, payload, offset, segment.length);
                offset += segment.length;
            }
            return new WebSocketMessage(payload);
        }
    }

    static interface Builder {
        public boolean appendBytes(byte[] var1);

        public WebSocketMessage toMessage();
    }
}

