/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.persistence;

import com.google.firebase.database.core.view.QuerySpec;

public class TrackedQuery {
    public final long id;
    public final QuerySpec querySpec;
    public final long lastUse;
    public final boolean complete;
    public final boolean active;

    public TrackedQuery(long id, QuerySpec querySpec, long lastUse, boolean complete, boolean active) {
        this.id = id;
        if (querySpec.loadsAllData() && !querySpec.isDefault()) {
            throw new IllegalArgumentException("Can't create TrackedQuery for a non-default query that loads all data");
        }
        this.querySpec = querySpec;
        this.lastUse = lastUse;
        this.complete = complete;
        this.active = active;
    }

    public TrackedQuery updateLastUse(long lastUse) {
        return new TrackedQuery(this.id, this.querySpec, lastUse, this.complete, this.active);
    }

    public TrackedQuery setComplete() {
        return new TrackedQuery(this.id, this.querySpec, this.lastUse, true, this.active);
    }

    public TrackedQuery setActiveState(boolean isActive) {
        return new TrackedQuery(this.id, this.querySpec, this.lastUse, this.complete, isActive);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TrackedQuery query = (TrackedQuery)o;
        return this.id == query.id && this.querySpec.equals(query.querySpec) && this.lastUse == query.lastUse && this.complete == query.complete && this.active == query.active;
    }

    public int hashCode() {
        int result = Long.valueOf(this.id).hashCode();
        result = 31 * result + this.querySpec.hashCode();
        result = 31 * result + Long.valueOf(this.lastUse).hashCode();
        result = 31 * result + Boolean.valueOf(this.complete).hashCode();
        result = 31 * result + Boolean.valueOf(this.active).hashCode();
        return result;
    }

    public String toString() {
        long l = this.id;
        String string = String.valueOf(this.querySpec);
        long l2 = this.lastUse;
        boolean bl = this.complete;
        boolean bl2 = this.active;
        return new StringBuilder(109 + String.valueOf(string).length()).append("TrackedQuery{id=").append(l).append(", querySpec=").append(string).append(", lastUse=").append(l2).append(", complete=").append(bl).append(", active=").append(bl2).append("}").toString();
    }
}

