/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection.util;

import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.logging.Logger;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RetryHelper {
    private final ScheduledExecutorService executorService;
    private final LogWrapper logger;
    private final long minRetryDelayAfterFailure;
    private final long maxRetryDelay;
    private final double jitterFactor;
    private final double retryExponent;
    private final Random random = new Random();
    private ScheduledFuture<?> scheduledRetry;
    private long currentRetryDelay;
    private boolean lastWasSuccess = true;

    private RetryHelper(ScheduledExecutorService executorService, LogWrapper logger, long minRetryDelayAfterFailure, long maxRetryDelay, double retryExponent, double jitterFactor) {
        this.executorService = executorService;
        this.logger = logger;
        this.minRetryDelayAfterFailure = minRetryDelayAfterFailure;
        this.maxRetryDelay = maxRetryDelay;
        this.retryExponent = retryExponent;
        this.jitterFactor = jitterFactor;
    }

    public void retry(final Runnable runnable) {
        long delay;
        Runnable wrapped = new Runnable(){

            @Override
            public void run() {
                RetryHelper.this.scheduledRetry = null;
                runnable.run();
            }
        };
        if (this.scheduledRetry != null) {
            this.logger.debug("Cancelling previous scheduled retry", new Object[0]);
            this.scheduledRetry.cancel(false);
            this.scheduledRetry = null;
        }
        if (this.lastWasSuccess) {
            delay = 0L;
        } else {
            if (this.currentRetryDelay == 0L) {
                this.currentRetryDelay = this.minRetryDelayAfterFailure;
            } else {
                long newDelay = (long)((double)this.currentRetryDelay * this.retryExponent);
                this.currentRetryDelay = Math.min(newDelay, this.maxRetryDelay);
            }
            delay = (long)((1.0 - this.jitterFactor) * (double)this.currentRetryDelay + this.jitterFactor * (double)this.currentRetryDelay * this.random.nextDouble());
        }
        this.lastWasSuccess = false;
        this.logger.debug("Scheduling retry in %dms", delay);
        this.scheduledRetry = this.executorService.schedule(wrapped, delay, TimeUnit.MILLISECONDS);
    }

    public void signalSuccess() {
        this.lastWasSuccess = true;
        this.currentRetryDelay = 0L;
    }

    public void cancel() {
        if (this.scheduledRetry != null) {
            this.logger.debug("Cancelling existing retry attempt", new Object[0]);
            this.scheduledRetry.cancel(false);
            this.scheduledRetry = null;
        } else {
            this.logger.debug("No existing retry attempt to cancel", new Object[0]);
        }
        this.currentRetryDelay = 0L;
    }

    public static class Builder {
        private final ScheduledExecutorService service;
        private long minRetryDelayAfterFailure = 1000L;
        private double jitterFactor = 0.5;
        private long retryMaxDelay = 30000L;
        private double retryExponent = 1.3;
        private final LogWrapper logger;

        public Builder(ScheduledExecutorService service, Logger logger, String tag) {
            this.service = service;
            this.logger = new LogWrapper(logger, tag);
        }

        public Builder withMinDelayAfterFailure(long delay) {
            this.minRetryDelayAfterFailure = delay;
            return this;
        }

        public Builder withMaxDelay(long delay) {
            this.retryMaxDelay = delay;
            return this;
        }

        public Builder withRetryExponent(double exponent) {
            this.retryExponent = exponent;
            return this;
        }

        public Builder withJitterFactor(double random) {
            if (random < 0.0 || random > 1.0) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Argument out of range: ").append(random).toString());
            }
            this.jitterFactor = random;
            return this;
        }

        public RetryHelper build() {
            return new RetryHelper(this.service, this.logger, this.minRetryDelayAfterFailure, this.retryMaxDelay, this.retryExponent, this.jitterFactor);
        }
    }
}

