/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.auth.internal.FirebaseTokenVerifier;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class FirebaseAuth {
    private static Map<String, FirebaseAuth> authInstances = new HashMap<String, FirebaseAuth>();
    private static JsonFactory jsonFactory = new GsonFactory();
    private final FirebaseApp firebaseApp;
    private final FirebaseTokenVerifier firebaseTokenVerifier;

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        if (!authInstances.containsKey(app.getName())) {
            authInstances.put(app.getName(), new FirebaseAuth(app));
        }
        return authInstances.get(app.getName());
    }

    private FirebaseAuth(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
        this.firebaseTokenVerifier = new FirebaseTokenVerifier.Builder().setProjectId(ImplFirebaseTrampolines.getProjectId(firebaseApp.getOptions())).build();
    }

    public String createCustomToken(String uid) {
        return this.createCustomToken(uid, null);
    }

    public String createCustomToken(String uid, Map<String, Object> developerClaims) {
        FirebaseTokenFactory tokenFactory = FirebaseTokenFactory.getInstance();
        GoogleCredential serviceAccount = ImplFirebaseTrampolines.getServiceAccountCredential(this.firebaseApp);
        try {
            return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims, serviceAccount.getServiceAccountId(), serviceAccount.getServiceAccountPrivateKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Task<FirebaseToken> verifyIdToken(final String token) {
        return Tasks.call(new Callable<FirebaseToken>(){

            @Override
            public FirebaseToken call() throws Exception {
                FirebaseToken firebaseToken = FirebaseToken.parse(jsonFactory, token);
                FirebaseAuth.this.firebaseTokenVerifier.verifyTokenAndSignature(firebaseToken.getToken());
                return firebaseToken;
            }
        });
    }
}

