/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

public enum StorageUnit {
    TERABYTES(0x10000000000L){

        @Override
        public long convert(long quantity, StorageUnit sourceUnit) {
            return sourceUnit.toTerabytes(quantity);
        }
    }
    ,
    GIGABYTES(0x40000000L){

        @Override
        public long convert(long quantity, StorageUnit sourceUnit) {
            return sourceUnit.toGigabytes(quantity);
        }
    }
    ,
    MEGABYTES(0x100000L){

        @Override
        public long convert(long quantity, StorageUnit sourceUnit) {
            return sourceUnit.toMegabytes(quantity);
        }
    }
    ,
    KILOBYTES(1024L){

        @Override
        public long convert(long quantity, StorageUnit sourceUnit) {
            return sourceUnit.toKilobytes(quantity);
        }
    }
    ,
    BYTES(1L){

        @Override
        public long convert(long quantity, StorageUnit sourceUnit) {
            return sourceUnit.toBytes(quantity);
        }
    };

    long numBytes;

    private StorageUnit(long numBytes) {
        this.numBytes = numBytes;
    }

    public long toBytes(long quantity) {
        return quantity * this.numBytes;
    }

    public long toKilobytes(long quantity) {
        return quantity * this.numBytes / StorageUnit.KILOBYTES.numBytes;
    }

    public long toMegabytes(long quantity) {
        return quantity * this.numBytes / StorageUnit.MEGABYTES.numBytes;
    }

    public long toGigabytes(long quantity) {
        return quantity * this.numBytes / StorageUnit.GIGABYTES.numBytes;
    }

    public long toTerabytes(long quantity) {
        return quantity * this.numBytes / StorageUnit.TERABYTES.numBytes;
    }

    public abstract long convert(long var1, StorageUnit var3);
}

