/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.session;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.PerfSession;
import com.google.firebase.perf.v1.SessionVerbosity;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PerfSession
implements Parcelable {
    private final String sessionId;
    private final Timer creationTime;
    private boolean isGaugeAndEventCollectionEnabled = false;
    public static final Parcelable.Creator<PerfSession> CREATOR = new Parcelable.Creator<PerfSession>(){

        public PerfSession createFromParcel(@NonNull Parcel in) {
            return new PerfSession(in);
        }

        public PerfSession[] newArray(int size) {
            return new PerfSession[size];
        }
    };

    public static PerfSession createWithId(@NonNull String sessionId) {
        String prunedSessionId = sessionId.replace("-", "");
        PerfSession session = new PerfSession(prunedSessionId, new Clock());
        session.setGaugeAndEventCollectionEnabled(PerfSession.shouldCollectGaugesAndEvents());
        return session;
    }

    @VisibleForTesting(otherwise=3)
    public PerfSession(String sessionId, Clock clock) {
        this.sessionId = sessionId;
        this.creationTime = clock.getTime();
    }

    private PerfSession(@NonNull Parcel in) {
        this.sessionId = in.readString();
        this.isGaugeAndEventCollectionEnabled = in.readByte() != 0;
        this.creationTime = (Timer)in.readParcelable(Timer.class.getClassLoader());
    }

    public String sessionId() {
        return this.sessionId;
    }

    public Timer getTimer() {
        return this.creationTime;
    }

    public void setGaugeAndEventCollectionEnabled(boolean enabled) {
        this.isGaugeAndEventCollectionEnabled = enabled;
    }

    public boolean isGaugeAndEventCollectionEnabled() {
        return this.isGaugeAndEventCollectionEnabled;
    }

    public boolean isVerbose() {
        return this.isGaugeAndEventCollectionEnabled;
    }

    @VisibleForTesting
    static boolean isVerbose(@NonNull com.google.firebase.perf.v1.PerfSession perfSession) {
        for (SessionVerbosity sessionVerbosity : perfSession.getSessionVerbosityList()) {
            if (sessionVerbosity != SessionVerbosity.GAUGES_AND_SYSTEM_EVENTS) continue;
            return true;
        }
        return false;
    }

    public boolean isSessionRunningTooLong() {
        return TimeUnit.MICROSECONDS.toMinutes(this.creationTime.getDurationMicros()) > ConfigResolver.getInstance().getSessionsMaxDurationMinutes();
    }

    public com.google.firebase.perf.v1.PerfSession build() {
        PerfSession.Builder sessionMetric = com.google.firebase.perf.v1.PerfSession.newBuilder().setSessionId(this.sessionId);
        if (this.isGaugeAndEventCollectionEnabled) {
            sessionMetric.addSessionVerbosity(SessionVerbosity.GAUGES_AND_SYSTEM_EVENTS);
        }
        return (com.google.firebase.perf.v1.PerfSession)sessionMetric.build();
    }

    @Nullable
    public static com.google.firebase.perf.v1.PerfSession[] buildAndSort(@NonNull List<PerfSession> sessions) {
        if (sessions.isEmpty()) {
            return null;
        }
        com.google.firebase.perf.v1.PerfSession[] perfSessions = new com.google.firebase.perf.v1.PerfSession[sessions.size()];
        com.google.firebase.perf.v1.PerfSession perfSessionAtIndexZero = sessions.get(0).build();
        boolean foundVerboseSession = false;
        for (int i = 1; i < sessions.size(); ++i) {
            com.google.firebase.perf.v1.PerfSession perfSession = sessions.get(i).build();
            if (!foundVerboseSession && sessions.get(i).isVerbose()) {
                foundVerboseSession = true;
                perfSessions[0] = perfSession;
                perfSessions[i] = perfSessionAtIndexZero;
                continue;
            }
            perfSessions[i] = perfSession;
        }
        if (!foundVerboseSession) {
            perfSessions[0] = perfSessionAtIndexZero;
        }
        return perfSessions;
    }

    public static boolean shouldCollectGaugesAndEvents() {
        ConfigResolver configResolver = ConfigResolver.getInstance();
        return configResolver.isPerformanceMonitoringEnabled() && Math.random() < configResolver.getSessionsSamplingRate();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.sessionId);
        out.writeByte((byte)(this.isGaugeAndEventCollectionEnabled ? 1 : 0));
        out.writeParcelable((Parcelable)this.creationTime, 0);
    }
}

